/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.handler.config;

import com.inet.helpdesk.plugins.forms.client.data.config.CopyFolderRequest;
import com.inet.helpdesk.plugins.forms.client.handler.AbstractTicketFormsHandler;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class CopyFormFolder
extends AbstractTicketFormsHandler<CopyFolderRequest, Void> {
    @Override
    public Void handle(HttpServletRequest req, HttpServletResponse resp, CopyFolderRequest payload) throws IOException {
        String folderId = payload.getFolderId();
        if (StringFunctions.isEmpty((String)folderId)) {
            return null;
        }
        GUID folderGuid = GUID.valueOf((String)folderId);
        FormsManager formsManager = (FormsManager)ServerPluginManager.getInstance().getSingleInstance(FormsManager.class);
        FormDir folder = formsManager.getFolder(folderGuid);
        if (folder == null || folderGuid == null) {
            return null;
        }
        GUID newParentFolderId = GUID.valueOf((String)payload.getParentFolderId());
        if (newParentFolderId == null) {
            newParentFolderId = formsManager.getRootFolderID();
        }
        try {
            formsManager.copyFolder(folderGuid, newParentFolderId);
        }
        catch (IllegalArgumentException exc) {
            throw new ClientMessageException(exc.getMessage(), (Throwable)exc);
        }
        return null;
    }

    public String getMethodName() {
        return "ticketforms.copyfolder";
    }
}

