/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.taskplanner;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.helpdesk.plugins.forms.taskplanner.GenerateFormURLJob;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.job.ConditionInfo;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.job.JobInfo;
import com.inet.taskplanner.server.api.job.JobSummaryInfo;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GenerateFormURLJobFactory
extends JobFactory<GenerateFormURLJob> {
    public static final String EXTENSION_NAME = "taskplanner.helpdesk.generateformurl";
    public static final String PROPERTY_FORM_ID = "formId";

    public GenerateFormURLJobFactory() {
        super(EXTENSION_NAME);
    }

    public List<ResultFlavor> getResultFlavors(JobDefinition definition) {
        return new ArrayList<ResultFlavor>();
    }

    protected void validateCondition(@Nonnull JobDefinition definition) throws ValidationException {
    }

    public JobInfo getInformation(@Nullable GUID taskID) {
        if (!this.isAvailable()) {
            return new JobInfo(this.getExtensionName(), "", "", null, "", new ConditionInfo(new ArrayList()), new ArrayList(), new ArrayList());
        }
        String name = FormsServerPlugin.MSG.getMsg("GenerateFormURL", new Object[0]);
        String description = FormsServerPlugin.MSG.getMsg("GenerateFormURLDesc", new Object[0]);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/forms/taskplanner/images/forms_link_32.png");
        String helpKey = "taskplanner.job.generateformurl";
        ArrayList<Object> fields = new ArrayList<Object>();
        TextField textField = new TextField("Ticket ID", FormsServerPlugin.MSG.getMsg("TicketIDLabel", new Object[0]));
        textField.setValue("{Ticket ID}");
        fields.add(textField);
        FormsManager formsManager = (FormsManager)ServerPluginManager.getInstance().getSingleInstance(FormsManager.class);
        List<HDForm> allForms = formsManager.getAllForms();
        ArrayList formOptions = allForms.stream().map(form -> new LocalizedKey(form.getId().toString(), this.getFormPath((HDForm)form, formsManager))).sorted((e1, e2) -> e1.getDisplayName().compareToIgnoreCase(e2.getDisplayName())).collect(Collectors.toCollection(ArrayList::new));
        SelectField formSelect = new SelectField(PROPERTY_FORM_ID, FormsServerPlugin.MSG.getMsg("SelectForm", new Object[0]), formOptions);
        if (!formOptions.isEmpty()) {
            formSelect.setValue(((LocalizedKey)formOptions.get(0)).getKey());
        }
        fields.add(formSelect);
        ArrayList<String> placeholderKeys = new ArrayList<String>();
        placeholderKeys.add("form.url");
        return new JobInfo(this.getExtensionName(), name, description, iconURL, helpKey, new ConditionInfo(new ArrayList()), fields, placeholderKeys);
    }

    private String getFormPath(HDForm form, FormsManager formsManager) {
        try {
            FormDir folder;
            Object path = form.getName();
            GUID parentId = form.getParentFolderId();
            while (parentId != null && !parentId.equals((Object)formsManager.getRootFolderID()) && (folder = formsManager.getFolder(parentId)) != null) {
                path = folder.getName() + "/" + (String)path;
                parentId = folder.getParentId();
            }
            return path;
        }
        catch (Exception e) {
            return form.getName();
        }
    }

    protected void validate(@Nonnull JobDefinition definition, @Nullable GUID taskID) throws ValidationException {
        Map props = definition.getProperties();
        if (props.get(PROPERTY_FORM_ID) == null || ((String)props.get(PROPERTY_FORM_ID)).isEmpty()) {
            throw new ValidationException(new String[]{FormsServerPlugin.MSG.getMsg("FormIDMissing", new Object[0])});
        }
        String formId = definition.getProperty(PROPERTY_FORM_ID);
        FormsManager formsManager = (FormsManager)ServerPluginManager.getInstance().getSingleInstance(FormsManager.class);
        HDForm form = formsManager.getForm(GUID.valueOf((String)formId));
        if (form != null) {
            if (form.getSubmitType() == 2 && (props.get("Ticket ID") == null || ((String)props.get("Ticket ID")).isEmpty())) {
                throw new ValidationException(new String[]{FormsServerPlugin.MSG.getMsg("TicketIDMissing", new Object[0])});
            }
        } else {
            throw new ValidationException(new String[]{FormsServerPlugin.MSG.getMsg("FormIDMissing", new Object[0])});
        }
    }

    public JobSummaryInfo getSummary(@Nonnull JobDefinition definition) {
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String ticketId = definition.getProperty("Ticket ID");
        String formId = definition.getProperty(PROPERTY_FORM_ID);
        FormsManager formsManager = (FormsManager)ServerPluginManager.getInstance().getSingleInstance(FormsManager.class);
        HDForm form = formsManager.getForm(GUID.valueOf((String)formId));
        summary.add(new SummaryEntry(FormsServerPlugin.MSG.getMsg("TicketIDLabel", new Object[0]), ticketId));
        if (form != null) {
            summary.add(new SummaryEntry(FormsServerPlugin.MSG.getMsg("SelectForm", new Object[0]), this.getFormPath(form, formsManager)));
        }
        return new JobSummaryInfo(summary, new ArrayList());
    }

    protected GenerateFormURLJob createInstanceFrom(@Nonnull JobDefinition definition, @Nullable GUID taskID) {
        return new GenerateFormURLJob(definition, taskID);
    }

    public boolean isAvailable() {
        return SystemPermissionChecker.checkAccess((Permission[])new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION});
    }
}

