/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.handler.execution;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddAttachmentsExtensionData;
import com.inet.helpdesk.plugins.forms.client.data.execution.FormExecutionData;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormExecutionInfo;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.http.ClientMessageException;
import com.inet.http.upload.AttachmentDescription;
import com.inet.lib.util.StringFunctions;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.shared.http.upload.AttachmentType;
import com.inet.usersandgroups.api.FieldValidationException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ExecuteFormHandler
extends ServiceMethod<FormExecutionData, Integer> {
    public Integer invoke(HttpServletRequest req, HttpServletResponse resp, FormExecutionData payload) throws IOException {
        FormsManager m = this.getFormsManager();
        String formIdOrEncodedId = payload.getFormId();
        if (!StringFunctions.isEmpty((String)formIdOrEncodedId)) {
            FormExecutionInfo formExecutionInfo = FormExecutionInfo.decodeFormExecutionInfo(formIdOrEncodedId);
            ExtensionArguments args = ExtensionArguments.create();
            HDForm form = m.getForm(formExecutionInfo.getFormGUID());
            Objects.requireNonNull(form, "The form no longer exists");
            if (!form.isActivated()) {
                throw new ClientMessageException(FormsServerPlugin.MSG_CLIENT.getMsg("ticketForms.formNotActivated", new Object[0]));
            }
            this.addAttachmentsToExtensionArgs(req, payload, args, form.getMaxAttachmentSizeMb());
            try {
                return m.applyForm(payload.getFormData(), formExecutionInfo.getFormGUID(), formExecutionInfo.getTicketGUID(), payload.getSubmittingSectionIndex(), args, this.getProcessingTime(payload), payload.isFromTicketList());
            }
            catch (ClientMessageException | FieldValidationException e) {
                throw new ClientMessageException(e.getMessage(), e);
            }
            catch (Exception e) {
                FormsServerPlugin.LOGGER.error((Throwable)e);
                throw new ClientMessageException(e.getMessage(), (Throwable)e);
            }
        }
        resp.setStatus(404);
        return null;
    }

    @Nullable
    private ProcessingTime getProcessingTime(FormExecutionData payload) {
        if (payload.getDuration() != null) {
            String endDate;
            Integer durationValue = 0;
            Long endDateTimestamp = null;
            String value = payload.getDuration().getValue();
            if (!StringFunctions.isEmpty((String)value)) {
                try {
                    durationValue = Integer.valueOf(value);
                }
                catch (NumberFormatException nfe) {
                    throw new ClientMessageException(Tickets.MSG.getMsg("error.invalidDuration", new Object[0]));
                }
            }
            if (!StringFunctions.isEmpty((String)(endDate = payload.getDuration().getEndDate()))) {
                try {
                    endDateTimestamp = Long.valueOf(endDate);
                }
                catch (NumberFormatException nfe) {
                    throw new ClientMessageException(Tickets.MSG.getMsg("error.invalidEndDate", new Object[0]));
                }
            }
            long end = endDateTimestamp == null ? System.currentTimeMillis() : endDateTimestamp;
            return ProcessingTime.ofEffortWithEndTime((int)durationValue, (long)end);
        }
        return null;
    }

    private void addAttachmentsToExtensionArgs(HttpServletRequest request, FormExecutionData input, ExtensionArguments extensionArgs, int maxAttachmentSizeMb) throws ClientMessageException {
        try {
            List<AttachmentDescription> attachments = input.getAttachments();
            if (attachments != null && !attachments.isEmpty()) {
                long maxAttSize = Math.min(0x80000000L, (long)(maxAttachmentSizeMb * 1024) * 1024L);
                ArrayList<LargeContent> attachmentsWithData = new ArrayList<LargeContent>();
                long attSize = 0L;
                for (int i = 0; i < attachments.size(); ++i) {
                    AttachmentDescription attachment = attachments.get(i);
                    final Part part = request.getPart("attachment" + i);
                    attSize += part.getSize();
                    if (attachment == null || part == null) continue;
                    LargeContent lc = new LargeContent(new LargeContent.InputStreamProvider(){

                        public InputStream getStream() {
                            try {
                                return part.getInputStream();
                            }
                            catch (Exception e) {
                                HDLogger.error((Object)e);
                                return null;
                            }
                        }

                        public long getSize() {
                            return part.getSize();
                        }
                    });
                    lc.setContentType(AttachmentType.valueOf((String)attachment.getAttachmentType().name()));
                    lc.setLastModified(attachment.getLastModified());
                    lc.setName(attachment.getName());
                    attachmentsWithData.add(lc);
                }
                if (attSize > maxAttSize) {
                    throw new IllegalArgumentException(FormsServerPlugin.MSG.getMsg("error.exceedmaxAttSize", new Object[]{(double)attSize / 1024.0 / 1024.0, maxAttSize / 1024L / 1024L}));
                }
                extensionArgs.put(AttachmentsServerPlugin.EXTARG_ATTACHMENTS, (Object)new AddAttachmentsExtensionData(attachmentsWithData));
            }
        }
        catch (Throwable t) {
            throw new ClientMessageException(t.getMessage());
        }
    }

    public String getMethodName() {
        return "ticketforms.applyform";
    }

    public short getMethodType() {
        return 1;
    }

    protected FormsManager getFormsManager() {
        return FormsManager.getInstance();
    }
}

