/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.handler.ticketlist;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.plugins.forms.client.data.config.LoadAvailableModifyFormEntriesRequest;
import com.inet.helpdesk.plugins.forms.client.data.config.LoadAvailableTicketCreationFormEntriesResponse;
import com.inet.helpdesk.plugins.forms.client.data.model.SingleFormEntryDescription;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.helpdesk.plugins.forms.server.api.model.FormExecutionInfo;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LoadAvailableModifyFormEntries
extends ServiceMethod<LoadAvailableModifyFormEntriesRequest, LoadAvailableTicketCreationFormEntriesResponse> {
    public String getMethodName() {
        return "ticketforms.loadavailablemodifyforms";
    }

    public short getMethodType() {
        return 1;
    }

    public LoadAvailableTicketCreationFormEntriesResponse invoke(HttpServletRequest req, HttpServletResponse resp, LoadAvailableModifyFormEntriesRequest payload) throws IOException {
        List<SingleFormEntryDescription> entries = new ArrayList<SingleFormEntryDescription>();
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return new LoadAvailableTicketCreationFormEntriesResponse(entries);
        }
        entries = this.getModifyFormEntries(payload.getTicketId());
        this.sortRecursively(entries);
        return new LoadAvailableTicketCreationFormEntriesResponse(entries);
    }

    private List<SingleFormEntryDescription> getModifyFormEntries(int ticketId) {
        ArrayList<SingleFormEntryDescription> entries = new ArrayList<SingleFormEntryDescription>();
        FormsManager manager = (FormsManager)ServerPluginManager.getInstance().getSingleInstance(FormsManager.class);
        GUID rootFolderID = manager.getRootFolderID();
        FormDir rootFolder = null;
        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
            rootFolder = manager.getFolder(rootFolderID);
        }
        entries.addAll(this.buildModifyFormEntryTree(rootFolder, manager, ticketId));
        return entries;
    }

    private List<SingleFormEntryDescription> buildModifyFormEntryTree(FormDir folder, FormsManager manager, int ticketId) {
        TicketVO ticket = TicketManager.getReader().getTicket(ticketId);
        ArrayList<SingleFormEntryDescription> entries = new ArrayList<SingleFormEntryDescription>();
        if (ticket == null) {
            return entries;
        }
        GUID ticketGUID = (GUID)ticket.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_TICKET_GUID);
        manager.listAnyViewableFormSharedInFolder(folder.getFolderID()).stream().filter(form -> {
            try {
                form.validate();
            }
            catch (Throwable t) {
                return false;
            }
            if (!form.isActivated()) {
                return false;
            }
            if (form.getSubmitType() != 2) {
                return false;
            }
            try {
                manager.checkCanApplyForm(form.getId(), ticketGUID);
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }).forEach(form -> {
            try {
                FormExecutionInfo info = new FormExecutionInfo(ticketGUID, form.getId());
                String encodedId = info.toEncodedString();
                SingleFormEntryDescription formEntry = new SingleFormEntryDescription(encodedId, form.getName(), false);
                entries.add(formEntry);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        for (FormDir subfolder : folder.getChildren()) {
            SingleFormEntryDescription folderEntry = new SingleFormEntryDescription(subfolder.getFolderID().toString(), subfolder.getName(), true);
            folderEntry.getChildren().addAll(this.buildModifyFormEntryTree(subfolder, manager, ticketId));
            if (folderEntry.getChildren().isEmpty()) continue;
            entries.add(folderEntry);
        }
        return entries;
    }

    private void sortRecursively(List<SingleFormEntryDescription> entries) {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        Collator collator = Collator.getInstance(ClientLocale.getThreadLocale());
        Collections.sort(entries, (e1, e2) -> {
            if (e1.isFolder() != e2.isFolder()) {
                return e1.isFolder() ? -1 : 1;
            }
            int labelCompare = collator.compare(e1.getLabel(), e2.getLabel());
            if (labelCompare != 0) {
                return labelCompare;
            }
            return e1.getId().compareTo(e2.getId());
        });
        for (SingleFormEntryDescription entry : entries) {
            this.sortRecursively(entry.getChildren());
        }
    }
}

