/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.handler.execution;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.plugins.forms.client.handler.AbstractTicketFormsHandler;
import com.inet.helpdesk.plugins.forms.client.handler.execution.GetTicketGUIDRequest;
import com.inet.helpdesk.plugins.forms.client.handler.execution.GetTicketGUIDResponse;
import com.inet.id.GUID;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class GetTicketGUID
extends AbstractTicketFormsHandler<GetTicketGUIDRequest, GetTicketGUIDResponse> {
    @Override
    public GetTicketGUIDResponse handle(HttpServletRequest req, HttpServletResponse resp, GetTicketGUIDRequest payload) throws IOException {
        Integer ticketId = payload.getTicketId();
        if (ticketId == null) {
            throw new IOException("Ticket ID null!");
        }
        TicketVO ticket = TicketManager.getReader().getTicket(ticketId.intValue());
        if (ticket == null) {
            throw new IOException("Ticket null!");
        }
        GUID guid = (GUID)ticket.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_TICKET_GUID);
        if (guid == null) {
            throw new IOException("Ticket GUID null!");
        }
        return new GetTicketGUIDResponse(guid.toString());
    }

    public String getMethodName() {
        return "ticketforms.getticketguid";
    }

    @Override
    protected boolean hasAccess(GetTicketGUIDRequest payload) {
        Integer ticketId = payload.getTicketId();
        if (ticketId == null) {
            return true;
        }
        TicketManager.getReader().getTicket(ticketId.intValue());
        return true;
    }
}

