/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.handler.execution;

import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormField;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.helpdesk.plugins.ticketlist.api.data.SelectOptionsRequest;
import com.inet.helpdesk.plugins.ticketlist.api.handler.GetSelectOptions;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import javax.annotation.Nullable;

public class GetSelectOptions_Form
extends GetSelectOptions {
    public static final String TICKETFORM_HEADER = "X-TicketFormId";

    public SelectOptionResult invoke(HttpServletRequest request, HttpServletResponse response, SelectOptionsRequest input) {
        HDForm form = this.checkTicketFormHeader(request);
        if (form == null) {
            throw new AccessDeniedException((ErrorCode)BaseErrorCode.AccessDeniedOrFileNotExists, new Object[0]);
        }
        String fieldKey = input.getFieldKey();
        if (!form.getSections().stream().anyMatch(s -> s.getFields().stream().anyMatch(f -> f.getFormFieldType() == FormField.FormFieldType.Ticket && f.getKey().equals(fieldKey)))) {
            throw new AccessDeniedException("Form does not have such field: " + fieldKey, (ErrorCode)BaseErrorCode.forbidden);
        }
        return super.invoke(request, response, input);
    }

    @Nullable
    private HDForm checkTicketFormHeader(HttpServletRequest request) {
        String formId = request.getHeader(TICKETFORM_HEADER);
        if (formId == null) {
            throw new AccessDeniedException("Must pass ID of the form", (ErrorCode)BaseErrorCode.forbidden);
        }
        return FormsManager.getInstance().getForm(GUID.valueOf((String)formId));
    }
}

