/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.data.model;

import com.inet.annotations.JsonData;
import com.inet.field.Field;
import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldTypeSelect_String;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.forms.client.data.model.AndBlockDescription;
import com.inet.helpdesk.plugins.forms.client.data.model.ConditionDescription;
import com.inet.helpdesk.plugins.forms.client.data.model.SectionDescription;
import com.inet.helpdesk.plugins.forms.server.api.model.FormField;
import com.inet.helpdesk.plugins.forms.server.api.model.FormSection;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonData
public class FormDetailsDescription {
    public static final String ALWAYS_FALSE_CONDITION = "ALWAYS_FALSE_CONDITION_";
    public static final String ALWAYS_TRUE_CONDITION = "ALWAYS_TRUE_CONDITION_";
    private int submitType;
    private String errorMessage;
    private String formId;
    private String name;
    private String title;
    private List<SectionDescription> sections;
    private boolean activated;
    private String icon;
    private boolean showOnStartPage;
    private String startPageLinkName;
    private String startPageLinkDescription;
    private boolean useFormLogo;
    private String maxAttachmentSizeMb;
    private Map<String, String> underlyingTicketData = new HashMap<String, String>();
    private String enduser;

    private FormDetailsDescription() {
    }

    public static FormDetailsDescription createForFormModification(HDForm form) {
        FormDetailsDescription description = FormDetailsDescription.createNew(form, false);
        return description;
    }

    private static FormDetailsDescription createNew(HDForm form, boolean forExecution) {
        FormDetailsDescription description = new FormDetailsDescription();
        description.name = form.getName();
        description.title = form.getTitle();
        description.formId = form.getId().toString();
        description.sections = form.getSections().stream().map(s -> new SectionDescription((FormSection)s, forExecution)).collect(Collectors.toList());
        description.activated = form.isActivated();
        description.icon = form.getIconAsDataUri();
        description.showOnStartPage = form.isShowOnStartPage();
        description.startPageLinkName = form.getStartPageLinkName();
        description.startPageLinkDescription = form.getStartPageLinkDescription();
        description.useFormLogo = form.isUseFormLogo();
        description.maxAttachmentSizeMb = String.valueOf(form.getMaxAttachmentSizeMb());
        description.submitType = form.getSubmitType();
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        String enduser = null;
        if (currentUserAccount != null && !SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
            enduser = new Json().toJson((Object)new SelectOption(currentUserAccount.getID().toString(), currentUserAccount.getDisplayName()));
        }
        description.enduser = enduser;
        return description;
    }

    public static FormDetailsDescription createForFormExecution(HDForm form, @Nullable TicketVO ticket) {
        FormDetailsDescription description = FormDetailsDescription.createNew(form, true);
        if (!StringFunctions.isEmpty((String)description.icon)) {
            description.icon = "e";
        }
        description.sections.forEach(s -> s.getFields().forEach(f -> {
            if (f.getFieldType() == FormField.FormFieldType.Ticket) {
                if (f.getKey().equals("special_ticket_text")) {
                    if (ticket != null) {
                        ReaStepTextVO ticketText = TicketManager.getReader().getReaStepText(ticket.getInitialReaStepID());
                        if (ticketText.hasHtmlContent()) {
                            ticketText = ReaStepTextVO.of((String)TicketTextFunctions.getInlinedHtml((String)ticketText.getText(), (boolean)false), (boolean)true);
                        }
                        description.underlyingTicketData.put("special_ticket_text", new Json().toJson((Object)ticketText).replace("\"htmlContent\":true", "\"htmlContent\":\"true\""));
                    }
                    return;
                }
                FieldEditDefinition editDefinition = Tickets.getFieldDefinitionByKey((String)f.getKey()).getEditDefinition();
                if (editDefinition != null) {
                    editDefinition.updateCurrentValue(ticket, ticket != null ? ticket.getOwnerID() : null, description.underlyingTicketData);
                }
            }
        }));
        if (ticket != null) {
            for (SectionDescription section : description.sections) {
                for (AndBlockDescription andBlockDescription : section.getConditions()) {
                    for (ConditionDescription condition : andBlockDescription.getConditions()) {
                        if (!condition.isForTicketValue()) continue;
                        if (FormDetailsDescription.checkTicketFieldCondition(ticket, condition)) {
                            condition.setFieldKey(ALWAYS_TRUE_CONDITION);
                            continue;
                        }
                        condition.setFieldKey(ALWAYS_FALSE_CONDITION);
                    }
                }
            }
        }
        return description;
    }

    private static <T> boolean checkTicketFieldCondition(TicketVO ticket, ConditionDescription condition) {
        FieldEditDefinition editDefinition;
        TicketFieldDefinition definition;
        String fieldkey = condition.getFieldKey();
        if (fieldkey.equals("special_ticket_text")) {
            ReaStepTextVO reaStepText = TicketManager.getReader().getReaStepText(ticket.getInitialReaStepID());
            return reaStepText != null && !reaStepText.getText().isEmpty();
        }
        TicketField fieldByKey = Tickets.getFieldByKey((String)fieldkey);
        if (fieldByKey == null) {
            fieldByKey = Tickets.getAttributeByKey((String)fieldkey);
        }
        if ((definition = Tickets.getFieldDefinitionByKey((String)fieldkey)) != null && (editDefinition = definition.getEditDefinition()) != null) {
            String expected;
            Object fieldType = fieldkey.equals(Tickets.FIELD_OWNER_GUID.getKey()) ? new FieldTypeSelect_String(fieldkey, () -> "", bool -> List.of()) : fieldByKey.getFieldType();
            if (fieldByKey instanceof TicketField) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(fieldkey, condition.getValue());
                MutableTicketData data = new MutableTicketData();
                editDefinition.updateTicketData(data, map);
                expected = fieldType.asString(data.get(fieldkey));
            } else if (fieldkey.equals(Tickets.ATTRIBUTE_STATUS_ID.getKey())) {
                try {
                    SelectOption fromJson = (SelectOption)new Json().fromJson(condition.getValue(), SelectOption.class);
                    expected = fromJson.getValue();
                }
                catch (JsonException ex) {
                    expected = null;
                }
            } else {
                throw new UnsupportedOperationException(fieldkey);
            }
            Object currentTicketValue = ticket.getFieldOrAttributeValue((Field)fieldByKey);
            String currentvalue = fieldType.asString(currentTicketValue);
            return fieldType.evaluateCondition(currentvalue, expected, condition.getOperator(), Set.of("rightvalueisrelativedate"));
        }
        return false;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getFormId() {
        return this.formId;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public List<SectionDescription> getSections() {
        return this.sections;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public int getSubmitType() {
        return this.submitType;
    }

    public boolean isShowOnStartPage() {
        return this.showOnStartPage;
    }

    @Nullable
    public String getStartPageLinkName() {
        return this.startPageLinkName;
    }

    @Nullable
    public String getStartPageLinkDescription() {
        return this.startPageLinkDescription;
    }

    public boolean isUseFormLogo() {
        return this.useFormLogo;
    }

    public void setUseFormLogo(boolean useFormLogo) {
        this.useFormLogo = useFormLogo;
    }

    public Map<String, String> getUnderlyingTicketData() {
        return this.underlyingTicketData;
    }

    public int getMaxAttachmentSizeMb() {
        try {
            return Integer.valueOf(this.maxAttachmentSizeMb);
        }
        catch (NumberFormatException wx) {
            return -1;
        }
    }
}

