/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client;

import com.inet.config.structure.model.ConfigPage;
import com.inet.config.structure.model.ConfigSearchSuggestion;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FormsConfigPage
implements ConfigPage {
    public String getPageKey() {
        return "configuration.ticketforms";
    }

    public String getParentKey() {
        return "configuration.templates";
    }

    public String getShortDisplayName() {
        return FormsServerPlugin.MSG.getMsg("forms.configuration.page.shortname", new Object[0]);
    }

    public String getFullDisplayName() {
        return FormsServerPlugin.MSG.getMsg("forms.configuration.page.fulldisplayname", new Object[0]);
    }

    public String getDescription() {
        return FormsServerPlugin.MSG.getMsg("forms.configuration.page.description", new Object[0]);
    }

    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/helpdesk/plugins/forms/server/forms_config_48.png");
    }

    public boolean isAccessAllowed() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return false;
        }
        return SystemPermissionChecker.hasAnyPermission((UserAccount)currentUserAccount, (Permission[])new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION});
    }

    public String getHelpKey() {
        return "configuration.forms";
    }

    public List<ConfigSearchSuggestion> getSearchSuggestions(String searchTerm, Map<String, String> properties) {
        String lowerCase;
        ArrayList<ConfigSearchSuggestion> suggestions = new ArrayList<ConfigSearchSuggestion>();
        String string = lowerCase = searchTerm == null ? "" : searchTerm.toLowerCase();
        if (this.getFullDisplayName().toLowerCase().contains(lowerCase)) {
            suggestions.add(new ConfigSearchSuggestion(this.getFullDisplayName(), "page/configuration.ticketforms/", HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.templates", new Object[0]), 20, true));
        }
        FormsManager ticketFormManager = (FormsManager)ServerPluginManager.getInstance().getSingleInstance(FormsManager.class);
        List<HDForm> forms = ticketFormManager.getAllForms();
        for (HDForm form : forms) {
            if (!form.getName().toLowerCase().contains(lowerCase)) continue;
            suggestions.add(new ConfigSearchSuggestion(StringFunctions.encodeHTML((String)form.getName()), "page/configuration.ticketforms/editform/" + form.getId().toString(), this.getShortDisplayName(), 20));
        }
        suggestions.addAll(this.createFolderSuggestion(lowerCase, ticketFormManager.getFolderStructure()));
        return suggestions;
    }

    private List<ConfigSearchSuggestion> createFolderSuggestion(String lowerSearchTerm, FormDir folder) {
        ArrayList<ConfigSearchSuggestion> suggestions = new ArrayList<ConfigSearchSuggestion>();
        if (!folder.getName().isEmpty() && folder.getName().toLowerCase().contains(lowerSearchTerm)) {
            suggestions.add(new ConfigSearchSuggestion(StringFunctions.encodeHTML((String)folder.getName()), "page/configuration.ticketforms/formfolder/" + folder.getFolderID().toString(), this.getShortDisplayName(), 10));
        }
        for (FormDir subFolder : folder.getChildren()) {
            suggestions.addAll(this.createFolderSuggestion(lowerSearchTerm, subFolder));
        }
        return suggestions;
    }

    public String getRelativeTemplateUrl() {
        return "weblib/configuration.forms.html";
    }
}

