/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.internal;

import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.id.GUID;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MutableFolder {
    private GUID id;
    private String name;
    private MutableFolder parent;
    private List<MutableFolder> children = new CopyOnWriteArrayList<MutableFolder>();
    private List<UsersOrGroupsSelection.SelectedMember> sharings = new CopyOnWriteArrayList<UsersOrGroupsSelection.SelectedMember>();

    public MutableFolder(GUID id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MutableFolder getParent() {
        return this.parent;
    }

    public void setParent(MutableFolder parent) {
        this.parent = parent;
    }

    public List<MutableFolder> getChildren() {
        return this.children;
    }

    public void setChildren(List<MutableFolder> children) {
        this.children = children;
    }

    @Nullable
    public List<UsersOrGroupsSelection.SelectedMember> getSharings() {
        return this.sharings;
    }

    public void setSharings(@Nullable List<UsersOrGroupsSelection.SelectedMember> sharings) {
        this.sharings = sharings;
    }

    public GUID getId() {
        return this.id;
    }

    public FormDir toImmutable() {
        List<FormDir> childs = this.children.stream().map(MutableFolder::toImmutable).collect(Collectors.toList());
        return new FormDir(this.name, this.id, this.parent == null ? null : this.parent.getId(), childs, this.sharings);
    }

    @Nullable
    public MutableFolder find(GUID folderId) {
        if (this.id.equals((Object)folderId)) {
            return this;
        }
        Optional<MutableFolder> findFirst = this.children.stream().map(f -> f.find(folderId)).filter(Objects::nonNull).findFirst();
        if (findFirst.isPresent()) {
            return findFirst.get();
        }
        return null;
    }
}

