/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.api.model;

import com.inet.lib.util.IOFunctions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import javax.annotation.Nonnull;

public interface IconProvider {
    public String getMimeType();

    public InputStream openStream();

    public static IconProvider fromBase64DataUri(String dataUri) {
        int base64Index = dataUri.toLowerCase().indexOf(";base64,");
        final String mimeType = dataUri.substring("data:".length(), dataUri.indexOf(";"));
        final byte[] data = Base64.getDecoder().decode(dataUri.substring(base64Index + 8));
        IconProvider icon = new IconProvider(){

            @Override
            public InputStream openStream() {
                return new ByteArrayInputStream(data);
            }

            @Override
            public String getMimeType() {
                return mimeType;
            }
        };
        return icon;
    }

    default public String getExtensionFromMimeType() {
        String mimeTypeFromData;
        switch (mimeTypeFromData = this.getMimeType()) {
            case "image/bmp": {
                return "bmp";
            }
            case "image/gif": {
                return "gif";
            }
            case "image/x-icon": {
                return "ico";
            }
            case "image/jp2": {
                return "jp2";
            }
            case "image/jpeg": {
                return "jpeg";
            }
            case "image/png": {
                return "png";
            }
            case "image/svg+xml": {
                return "svg";
            }
            case "image/webp": {
                return "webp";
            }
        }
        return "bmp";
    }

    @Nonnull
    default public String getAsDataUri() {
        String mimeType = this.getMimeType();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream in = this.openStream();){
            IOFunctions.copyData((InputStream)in, (OutputStream)out);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return "data:" + mimeType + ";base64," + Base64.getEncoder().encodeToString(out.toByteArray());
    }
}

