/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.api.model;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.Encryption;
import java.io.IOException;
import java.util.Base64;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class FormExecutionInfo {
    @Nullable
    private GUID ticketGUID;
    @Nonnull
    private GUID formGUID;

    private FormExecutionInfo() {
    }

    public FormExecutionInfo(@Nullable GUID ticketGUID, @Nonnull GUID formGUID) {
        this.ticketGUID = ticketGUID;
        this.formGUID = formGUID;
    }

    @Nullable
    public static FormExecutionInfo decodeFormExecutionInfo(@Nullable String encodedFormExecutionInfo) throws IOException {
        if (encodedFormExecutionInfo == null) {
            return null;
        }
        if (GUID.generateNew().toString().length() == encodedFormExecutionInfo.length()) {
            return new FormExecutionInfo(null, GUID.valueOf((String)encodedFormExecutionInfo));
        }
        String json = Encryption.decodePassword((String)Base64.getEncoder().encodeToString(Base64.getUrlDecoder().decode(encodedFormExecutionInfo)));
        FormExecutionInfo formExecutionInfo = (FormExecutionInfo)new Json().fromJson(json, FormExecutionInfo.class);
        return formExecutionInfo;
    }

    @Nullable
    public GUID getTicketGUID() {
        return this.ticketGUID;
    }

    @Nonnull
    public GUID getFormGUID() {
        return this.formGUID;
    }

    @Nullable
    public String toEncodedString() throws IOException {
        if (this.ticketGUID == null || this.formGUID == null) {
            return null;
        }
        return Base64.getUrlEncoder().encodeToString(Base64.getDecoder().decode(Encryption.encodePassword((String)new Json().toJson((Object)this))));
    }
}

