/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.internal.persistence;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.forms.server.api.model.FormSection;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.helpdesk.plugins.forms.server.api.model.IconProvider;
import com.inet.id.GUID;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class PersistedForm {
    private int submitType = 1;
    private GUID id;
    private String name;
    private boolean activated;
    private String iconName;
    private boolean showOnStartPage;
    private int maxAttachmentSizeMb = 100;
    @Nullable
    private String startPageLinkName;
    @Nullable
    private String startPageLinkDescription;
    @Nonnull
    private GUID parentFolderId;
    @Nullable
    private String title;
    private List<FormSection> sections;
    @Nullable
    @Deprecated
    private transient Integer actionId;
    private boolean useFormLogo;

    public PersistedForm(HDForm form) {
        this.id = form.getId();
        this.name = form.getName();
        this.activated = form.isActivated();
        this.parentFolderId = form.getParentFolderId();
        this.title = form.getTitle();
        this.sections = form.getSections();
        this.showOnStartPage = form.isShowOnStartPage();
        this.startPageLinkName = form.getStartPageLinkName();
        this.startPageLinkDescription = form.getStartPageLinkDescription();
        this.useFormLogo = form.isUseFormLogo();
        this.maxAttachmentSizeMb = form.getMaxAttachmentSizeMb();
        IconProvider icon = form.getIcon();
        if (icon != null) {
            String extension = icon.getExtensionFromMimeType();
            this.iconName = this.id.toString() + "_icon." + extension;
        }
        this.submitType = form.getSubmitType();
    }

    private PersistedForm() {
    }

    public GUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public GUID getParentFolderId() {
        return this.parentFolderId;
    }

    public String getTitle() {
        return this.title;
    }

    public List<FormSection> getSections() {
        return this.sections;
    }

    public String getIconName() {
        return this.iconName;
    }

    public int getSubmitType() {
        return this.submitType == 0 ? 1 : this.submitType;
    }

    public boolean isShowOnStartPage() {
        return this.showOnStartPage;
    }

    @Nullable
    public String getStartPageLinkName() {
        return this.startPageLinkName;
    }

    @Nullable
    public String getStartPageLinkDescription() {
        return this.startPageLinkDescription;
    }

    public boolean isUseFormLogo() {
        return this.useFormLogo;
    }

    public int getMaxAttachmentSizeMb() {
        return this.maxAttachmentSizeMb;
    }
}

