/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.handler.config;

import com.inet.field.SelectOption;
import com.inet.helpdesk.plugins.forms.client.data.config.GetTicketFormsFolderListResponse;
import com.inet.helpdesk.plugins.forms.client.handler.AbstractTicketFormsHandler;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.ServerPluginManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;

public class GetTicketFormsFolderList
extends AbstractTicketFormsHandler<Void, GetTicketFormsFolderListResponse> {
    @Override
    public GetTicketFormsFolderListResponse handle(HttpServletRequest req, HttpServletResponse resp, Void payload) throws IOException {
        FormsManager formsManager = (FormsManager)ServerPluginManager.getInstance().getSingleInstance(FormsManager.class);
        ArrayList<SelectOption> subOptions = new ArrayList<SelectOption>();
        FormDir rootFolder = formsManager.getFolderStructure();
        boolean hasNoForms = formsManager.listFormsInFolder(rootFolder.getFolderID()).isEmpty();
        subOptions.add(new SelectOption(rootFolder.getFolderID().toString(), FormsServerPlugin.MSG_CLIENT.getMsg("ticketforms.folder.root", new Object[0]), rootFolder.getChildren().isEmpty() && hasNoForms ? "emptyFolder" : "folder", 0));
        this.browseFolder(rootFolder, subOptions, 1, formsManager);
        return new GetTicketFormsFolderListResponse(subOptions);
    }

    private void browseFolder(FormDir parentFolder, ArrayList<SelectOption> subOptions, int level, FormsManager manager) {
        ArrayList<FormDir> subFolders = new ArrayList<FormDir>(parentFolder.getChildren());
        subFolders.sort(Comparator.comparing(FormDir::getName, Collator.getInstance(ClientLocale.getThreadLocale())));
        for (FormDir folder : subFolders) {
            boolean hasNoForms = manager.listFormsInFolder(folder.getFolderID()).isEmpty();
            subOptions.add(new SelectOption(folder.getFolderID().toString(), folder.getName(), folder.getChildren().isEmpty() && hasNoForms ? "emptyFolder" : "folder", level));
            this.browseFolder(folder, subOptions, level + 1, manager);
        }
    }

    public String getMethodName() {
        return "ticketforms.getformsfolderlist";
    }
}

