/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.handler.config;

import com.inet.helpdesk.plugins.forms.client.handler.AbstractTicketFormsHandler;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.helpdesk.plugins.forms.server.api.model.IconProvider;
import com.inet.helpdesk.plugins.forms.server.internal.FormsPersistence;
import com.inet.helpdesk.plugins.forms.server.internal.persistence.PersistedForm;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import com.inet.remote.gui.modules.importexport.ExportableWidget;
import com.inet.remote.gui.modules.importexport.GenericExportHandler;
import com.inet.shared.servlet.ServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;

public class ExportForm
extends AbstractTicketFormsHandler<Void, Void>
implements GenericExportHandler<FormDir, HDForm> {
    public String getMethodName() {
        return "ticketforms.exportform";
    }

    @Override
    public Void handle(HttpServletRequest request, HttpServletResponse response, Void input) throws IOException {
        String id = request.getParameter("formid");
        String folder = request.getParameter("folderid");
        String subfolder = request.getParameter("includesubfolder");
        if (id == null && folder == null) {
            throw new ClientMessageException(FormsServerPlugin.MSG_CLIENT.getMsg("forms.error.nosuchform", new Object[]{"-"}), (Throwable)new FileNotFoundException());
        }
        FormsManager formsManager = (FormsManager)ServerPluginManager.getInstance().getSingleInstance(FormsManager.class);
        if (StringFunctions.isEmpty((String)id)) {
            FormDir formDir;
            boolean includeFolder = "true".equals(subfolder);
            GUID folderId = formsManager.getRootFolderID();
            if (!StringFunctions.isEmpty((String)folder)) {
                folderId = GUID.valueOf((String)folder);
            }
            if ((formDir = formsManager.getFolder(folderId)) == null) {
                throw new ClientMessageException(FormsServerPlugin.MSG_CLIENT.getMsg("forms.error.nosuchform", new Object[]{"Folder " + String.valueOf(folderId)}), (Throwable)new FileNotFoundException());
            }
            this.writeFullZip(response, "forms", formDir, includeFolder);
        } else {
            HDForm form = formsManager.getForm(GUID.valueOf((String)id));
            if (form == null) {
                throw new ClientMessageException(FormsServerPlugin.MSG_CLIENT.getMsg("forms.error.nosuchform", new Object[]{id}));
            }
            ServletUtils.setContentDisposition((HttpServletResponse)response, (String)(GenericExportHandler.filterString((String)form.getName()) + ".form"), (boolean)false);
            try (FastBufferedOutputStream out = new FastBufferedOutputStream((OutputStream)response.getOutputStream());){
                this.writeWidgetData((OutputStream)out, form);
            }
        }
        return null;
    }

    public void writeFolderDataToZip(ZipOutputStream zip, FormDir folder, String subPath) throws IOException {
        super.writeFolderDataToZip(zip, (ExportableWidget)folder, subPath);
        List<UsersOrGroupsSelection.SelectedMember> sharings = folder.getSharings();
        if (sharings != null) {
            zip.putNextEntry(new ZipEntry(subPath + "folder.sharings"));
            new Json().toJson(sharings, (OutputStream)zip);
            zip.closeEntry();
        }
    }

    public void writeWidgetData(OutputStream out, HDForm form) throws IOException {
        PersistedForm persistedForm = new PersistedForm(form);
        ZipOutputStream zip = new ZipOutputStream(out);
        zip.putNextEntry(new ZipEntry("form.json"));
        new Json().toJson((Object)persistedForm, (OutputStream)zip);
        zip.closeEntry();
        IconProvider formIcon = form.getIcon();
        if (formIcon != null) {
            zip.putNextEntry(new ZipEntry(persistedForm.getIconName()));
            try (InputStream in = formIcon.openStream();){
                IOFunctions.copyData((InputStream)in, (OutputStream)zip);
            }
            zip.closeEntry();
        }
        persistedForm.getSections().forEach(s -> s.getFields().forEach(f -> {
            IconProvider image;
            String extension = f.getValues().get("imageextension");
            if (extension != null && (image = f.getImage()) != null) {
                try {
                    zip.putNextEntry(new ZipEntry(FormsPersistence.getImageFileName(form.getId(), f, extension)));
                    try (InputStream in = image.openStream();){
                        IOFunctions.copyData((InputStream)in, (OutputStream)zip);
                    }
                    zip.closeEntry();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }));
        zip.finish();
    }

    @Override
    public short getMethodType() {
        return 2;
    }

    public List<HDForm> getWidgetsFromFolder(FormDir folder) {
        return FormsManager.getInstance().listFormsInFolder(folder.getId());
    }

    @Nonnull
    public @Nonnull List<@Nonnull FormDir> getSubFoldersFromFolder(FormDir folder) {
        return folder.getChildren();
    }
}

