/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.data.config;

import com.inet.annotations.JsonData;
import com.inet.field.fieldtypes.FieldTypeCurrency;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.forms.server.api.model.FormField;
import com.inet.helpdesk.plugins.ticketlist.api.TicketFieldRendererId;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

@JsonData
public class AvailableFieldDescription {
    private FormField.FormFieldType fieldType;
    private String key;
    private String fieldDataType;
    private String label;
    private String defaultValue;
    private Map<String, String> initialProperties;

    private AvailableFieldDescription() {
    }

    public AvailableFieldDescription(FormField.FormFieldType fieldType, String key, String label, String fieldDataType, String defaultValue, Map<String, String> initialProperties) {
        this.fieldType = fieldType;
        this.key = key;
        this.label = label;
        this.fieldDataType = fieldDataType;
        this.defaultValue = defaultValue;
        this.initialProperties = initialProperties;
    }

    public static <T> AvailableFieldDescription forTicketField(TicketField<T> f, String fieldDataType) {
        String defaultValue = AvailableFieldDescription.getDefaultValueAsStringFor(f);
        return new AvailableFieldDescription(FormField.FormFieldType.Ticket, f.getKey(), f.getLabel(), fieldDataType, defaultValue, AvailableFieldDescription.initialProperties(fieldDataType));
    }

    public static String getDefaultValueAsStringFor(TicketField f) {
        FieldEditDefinition editDefinition;
        String defaultValue = f.getFieldType().asString(f.getDefaultValue());
        TicketFieldDefinition definition = Tickets.getFieldDefinitionByKey((String)f.getKey());
        if (definition != null && (editDefinition = definition.getEditDefinition()) != null) {
            HashMap map = new HashMap();
            TicketVOSingle dummy = TicketVOSingle.create((int)1, (MutableTicketAttributes)new MutableTicketAttributes(), (MutableTicketData)MutableTicketData.ofSingle((TicketField)f, (Object)f.getDefaultValue()));
            editDefinition.updateCurrentValue((TicketVO)dummy, null, map);
            defaultValue = (String)map.get(f.getKey());
        }
        return defaultValue;
    }

    public static AvailableFieldDescription forStandardField(String fieldDataType, String label) {
        String defaultValue = null;
        if (fieldDataType.equals("attachmentsadd")) {
            defaultValue = "0";
        }
        return new AvailableFieldDescription(FormField.FormFieldType.Standard, null, label, fieldDataType, defaultValue, AvailableFieldDescription.initialProperties(fieldDataType));
    }

    public static AvailableFieldDescription forUiField(String fieldDataType, String label) {
        return new AvailableFieldDescription(FormField.FormFieldType.Ui, null, label, fieldDataType, null, AvailableFieldDescription.initialProperties(fieldDataType));
    }

    public static Map<String, String> initialProperties(String fieldDataType) {
        HashMap<String, String> initialProperties = new HashMap<String, String>();
        if (fieldDataType.equals("htmltext") || fieldDataType.equals("text")) {
            initialProperties.put(TicketFieldRendererId.htmlcontent.name(), "true");
            initialProperties.put(TicketFieldRendererId.htmleditor.name(), "");
            initialProperties.put(TicketFieldRendererId.attachments.name(), "0");
            Font defaultFont = TicketTextFunctions.getDefaultFont();
            if (defaultFont != null) {
                initialProperties.put(TicketFieldRendererId.fontname.name(), defaultFont.getFamily());
                initialProperties.put(TicketFieldRendererId.fontsize.name(), defaultFont.getSize() + "pt");
            }
        } else if (fieldDataType.equals("currency")) {
            initialProperties.put("symbol", FieldTypeCurrency.getCurrency().getSymbol());
        }
        return initialProperties;
    }

    public String getKey() {
        return this.key;
    }

    public String getFieldDataType() {
        return this.fieldDataType;
    }

    public String getLabel() {
        return this.label;
    }
}

