/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.setup;

import com.inet.helpdesk.plugins.forms.client.handler.config.ImportForm;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepKey;
import com.inet.shared.utils.Version;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SampleFormsStep
extends AutoSetupStep {
    private static final String SAMPLE_FORM_RATING = "/com/inet/helpdesk/plugins/forms/server/setup/Beispiel_Bewertung.form";

    public StepKey stepKey() {
        return new StepKey("FormularSamples");
    }

    public String getStepDisplayName() {
        return FormsServerPlugin.MSG.getMsg("setup.samples.displayname", new Object[0]);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> this.getStepDisplayName();
    }

    public boolean hasPendingTasks() {
        Version lastMigratedVersionOfThisPlugin = this.getLastMigratedVersionOfThisPlugin();
        return lastMigratedVersionOfThisPlugin == null || lastMigratedVersionOfThisPlugin.getMajor() == 24;
    }

    public void execute(EmptyStepConfig stepConfig, Map metaData) throws StepExecutionException {
        Version lastMigratedVersionOfThisPlugin = this.getLastMigratedVersionOfThisPlugin();
        if (lastMigratedVersionOfThisPlugin == null) {
            this.createSampleFormular();
        } else if (lastMigratedVersionOfThisPlugin.getMajor() == 24) {
            this.addKundenzufriedenheitFormIfExampleFolderExists();
        }
    }

    private void createSampleFormular() {
        FormsManager manager = FormsManager.getInstance();
        ImportForm importForm = new ImportForm();
        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
            String sampleDirName = "Beispiele";
            if (manager.getFolderStructure().getChildren().stream().anyMatch(dir -> dir.getName().equals(sampleDirName))) {
                SetupLogger.LOGGER.warn((Object)"Skip sample-forms because already exists.");
                return;
            }
            GUID sampleFolder = manager.createFolder(new FormDir(sampleDirName, manager.getRootFolderID(), List.of(new UsersOrGroupsSelection.SelectedMember(Type.group, HDUsersAndGroups.GROUPID_SUPPORTERS))));
            URL resource = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/forms/server/setup/Allgemeine Supportanfrage.form");
            try (InputStream in = resource.openStream();){
                GUID folder = manager.createFolder(new FormDir("public", sampleFolder));
                importForm.importWidget(in, manager.getFolder(folder), new ArrayList<String>(), false, true);
            }
            catch (IOException ex) {
                SetupLogger.LOGGER.error((Object)"Cannot add sample form ");
                SetupLogger.LOGGER.error((Throwable)ex);
            }
            URL resource2 = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/forms/server/setup/Ticketerstellung.form");
            try (InputStream in = resource2.openStream();){
                importForm.importWidget(in, manager.getFolder(sampleFolder), new ArrayList<String>(), false, true);
            }
            catch (IOException ex) {
                SetupLogger.LOGGER.error((Object)"Cannot add sample form ");
                SetupLogger.LOGGER.error((Throwable)ex);
            }
            URL resource3 = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/forms/server/setup/Material bestellen.form");
            try (InputStream in = resource3.openStream();){
                importForm.importWidget(in, manager.getFolder(sampleFolder), new ArrayList<String>(), false, true);
            }
            catch (IOException ex) {
                SetupLogger.LOGGER.error((Object)"Cannot add sample form ");
                SetupLogger.LOGGER.error((Throwable)ex);
            }
            URL resource4 = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/forms/server/setup/Neuen Benutzer anlegen.form");
            try (InputStream in = resource4.openStream();){
                importForm.importWidget(in, manager.getFolder(sampleFolder), new ArrayList<String>(), false, true);
            }
            catch (IOException ex) {
                SetupLogger.LOGGER.error((Object)"Cannot add sample form ");
                SetupLogger.LOGGER.error((Throwable)ex);
            }
            URL resource5 = ((Object)((Object)this)).getClass().getResource(SAMPLE_FORM_RATING);
            try (InputStream in = resource5.openStream();){
                importForm.importWidget(in, manager.getFolder(sampleFolder), new ArrayList<String>(), false, true);
            }
            catch (IOException ex) {
                SetupLogger.LOGGER.error((Object)"Cannot add sample form ");
                SetupLogger.LOGGER.error((Throwable)ex);
            }
        }
    }

    private void addKundenzufriedenheitFormIfExampleFolderExists() {
        FormsManager manager = FormsManager.getInstance();
        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
            URL resource;
            String sampleDirName = "Beispiele";
            GUID sampleFolder = manager.getFolderStructure().getChildren().stream().filter(dir -> dir.getName().equals(sampleDirName)).findFirst().map(dir -> dir.getFolderID()).orElse(null);
            if (sampleFolder == null) {
                sampleFolder = manager.createFolder(new FormDir(sampleDirName, manager.getRootFolderID(), List.of(new UsersOrGroupsSelection.SelectedMember(Type.group, HDUsersAndGroups.GROUPID_SUPPORTERS))));
            }
            if ((resource = ((Object)((Object)this)).getClass().getResource(SAMPLE_FORM_RATING)) == null) {
                SetupLogger.LOGGER.error((Object)"Cannot add Kundenzufriedenheit form since not found: /com/inet/helpdesk/plugins/forms/server/setup/Beispiel_Bewertung.form");
                return;
            }
            try (InputStream in = resource.openStream();){
                new ImportForm().importWidget(in, manager.getFolder(sampleFolder), new ArrayList<String>(), false, true);
            }
            catch (IOException ex) {
                SetupLogger.LOGGER.error((Object)"Cannot add Kundenzufriedenheit form ");
                SetupLogger.LOGGER.error((Throwable)ex);
            }
        }
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(5850);
    }
}

