/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.setup;

import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormField;
import com.inet.helpdesk.plugins.forms.server.api.model.FormSection;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.http.ClientMessageException;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepKey;
import com.inet.shared.utils.Version;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;

public class MigrateFormsTicketFieldsToNotBeIncludedInInquiryTextStep
extends AutoSetupStep {
    public StepKey stepKey() {
        return new StepKey("MigrateFormsTicketFieldsToNotBeIncludedInInquiryTextStep");
    }

    public String getStepDisplayName() {
        return FormsServerPlugin.MSG.getMsg("setup.MigrateFormsTicketFieldsToNotBeIncludedInInquiryTextStep.displayname", new Object[0]);
    }

    public boolean hasPendingTasks() {
        return true;
    }

    @Nullable
    public Version getMigrationVersion() {
        return new Version("25.4");
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
            FormsManager.getInstance().getAllForms().forEach(form -> {
                try {
                    form.validate();
                }
                catch (ClientMessageException tt) {
                    return;
                }
                ArrayList<FormSection> newSections = new ArrayList<FormSection>();
                boolean formChanged = false;
                for (FormSection section : form.getSections()) {
                    ArrayList<FormField> newFields = new ArrayList<FormField>();
                    boolean sectionChanged = false;
                    for (FormField field : section.getFields()) {
                        if (field.getFormFieldType() == FormField.FormFieldType.Ticket && field.isApplyToTicketText()) {
                            FormField newField = new FormField(field.getKey(), field.getFormFieldType(), field.getFieldDataType(), field.getSelect_options(), field.getSelect_filter(), false, field.isIncludeLabelInInquiry(), field.isMandatory(), field.getVisibility(), field.getLabelSetting(), field.isCustomDefaultValue(), field.getDefaultValue(), field.getPlaceholder(), field.getLabel(), Map.of(), field.getImage());
                            newFields.add(newField);
                            sectionChanged = true;
                            continue;
                        }
                        newFields.add(field);
                    }
                    if (sectionChanged) {
                        FormSection newSection = new FormSection(section.getTitle(), section.getLabel(), newFields, section.getActions(), section.getConditions());
                        formChanged = true;
                        newSections.add(newSection);
                        continue;
                    }
                    newSections.add(section);
                }
                if (formChanged) {
                    HDForm newForm = new HDForm(form.getName(), form.getId(), form.getParentFolderId(), form.getTitle(), newSections, form.isActivated(), form.getIcon(), form.getSubmitType(), form.isShowOnStartPage(), form.getStartPageLinkName(), form.getStartPageLinkDescription(), form.isUseFormLogo(), form.getMaxAttachmentSizeMb());
                    FormsManager.getInstance().updateForm(newForm);
                }
            });
        }
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(5851);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> this.getStepDisplayName();
    }
}

