/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.maintenance;

import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.internal.FormsManagerImpl;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupHelper;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.FileProgress;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ApplicationDescription;
import com.inet.shared.utils.Version;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class FormsBackupTask
implements BackupTask {
    public String getKey() {
        return "forms.forms";
    }

    public String getTitle() {
        return FormsServerPlugin.MSG.getMsg("backup.task.forms.title", new Object[0]);
    }

    public String getDescription() {
        return FormsServerPlugin.MSG.getMsg("backup.task.forms.description", new Object[0]);
    }

    public URL getIconURL() {
        return FormsBackupTask.class.getResource("/com/inet/helpdesk/plugins/forms/server/forms_plugin_48.png");
    }

    public void execute(Path taskPath, BackupRunningStatus runningStatus, final BackupContentInformation contentInformation, final ProgressUpdater progressUpdater) throws Throwable {
        BackupHelper helper = new BackupHelper();
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        helper.createZipFromFolderContent(persistence.resolve("forms"), taskPath.resolve("forms.zip"), new FileProgress(){

            public void progressUpdate(int progress, int files) {
                String details = FormsServerPlugin.MSG.getMsg("backup.task.forms.taskdetail", new Object[]{files});
                contentInformation.putTaskDetails(FormsBackupTask.this.getKey(), new ArrayList<String>(List.of(details)));
                progressUpdater.updateProgress(progress);
            }
        });
        progressUpdater.updateProgress(100);
    }

    public void restore(Path taskPath, BackupRunningStatus runningStatus, ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        BackupHelper helper = new BackupHelper();
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        Path source = taskPath.resolve("forms.zip");
        PersistenceEntry target = persistence.resolve("forms");
        helper.extractZipIntoFolder(source, target, true, (progress, files) -> progressUpdater.updateProgress(progress));
        ((FormsManagerImpl)FormsManager.getInstance()).hardReset();
        progressUpdater.updateProgress(100);
    }

    public boolean isSupported() {
        PersistenceEntry users = Persistence.getRecoveryEnabledInstance().resolve("forms");
        return users.getChildren().size() > 0;
    }

    public String getWarningMessage() {
        return FormsServerPlugin.MSG.getMsg("backup.task.forms.warningMsg", new Object[0]);
    }

    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("24.10")) && ApplicationDescription.get().getVersion().isHigherOrEquals(backupVersion);
    }
}

