/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.handler.execution;

import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.forms.client.data.config.LoadFormDetailsRequest;
import com.inet.helpdesk.plugins.forms.client.data.model.FormDetailsDescription;
import com.inet.helpdesk.plugins.forms.client.handler.execution.LoadFormExecutionDataResponse;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormExecutionInfo;
import com.inet.helpdesk.plugins.forms.server.api.model.FormSection;
import com.inet.helpdesk.plugins.forms.server.api.model.FormSubmitAction;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.helpdesk.plugins.forms.server.internal.FormsManagerImpl;
import com.inet.helpdesk.plugins.ticketlist.api.editing.ApplyActionRendererProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Set;

public class LoadFormData
extends ServiceMethod<LoadFormDetailsRequest, LoadFormExecutionDataResponse> {
    public LoadFormExecutionDataResponse invoke(HttpServletRequest req, HttpServletResponse resp, LoadFormDetailsRequest payload) throws IOException {
        HDForm form;
        FormsManager m = FormsManager.getInstance();
        String encodedFormExecutionInfo = payload.getFormId();
        FormExecutionInfo formExecutionInfo = FormExecutionInfo.decodeFormExecutionInfo(encodedFormExecutionInfo);
        GUID formGuid = formExecutionInfo.getFormGUID();
        GUID ticketGUID = formExecutionInfo.getTicketGUID();
        FormDetailsDescription formDetailsDescription = null;
        boolean allowsCustomEndDate = false;
        boolean supportsEditDuration = false;
        if (formGuid != null && !StringFunctions.isEmpty((String)formGuid.toString()) && (form = m.getForm(formGuid)) != null) {
            Set<Integer> ticketsWithGUID;
            if (!form.isActivated()) {
                throw new ClientMessageException(FormsServerPlugin.MSG_CLIENT.getMsg("ticketForms.formNotActivated", new Object[0]));
            }
            try {
                m.checkCanApplyForm(formGuid, ticketGUID);
                form.validate();
            }
            catch (Exception ex) {
                throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("validation.hasErrors", new Object[0]), (Throwable)ex);
            }
            TicketVO ticket = null;
            if (ticketGUID != null && !(ticketsWithGUID = FormsManagerImpl.getTicketsWithGUID(ticketGUID)).isEmpty()) {
                ticket = TicketManager.getReaderForSystem().getTicket(ticketsWithGUID.iterator().next().intValue());
                if (payload.isInTicketList()) {
                    boolean writeLock = false;
                    TicketAccessInformationsProvider ticketAccessProvider = (TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class);
                    writeLock = ticketAccessProvider.accessTicketWrite(payload.getClientId(), ticket.getID());
                    if (!writeLock) {
                        throw new ClientMessageException(FormsServerPlugin.MSG_CLIENT.getMsg("form.ticket.lock.failed", new Object[]{String.valueOf(ticket.getID())}));
                    }
                }
            }
            formDetailsDescription = FormDetailsDescription.createForFormExecution(form, ticket);
            for (FormSection s : form.getSections()) {
                for (FormSubmitAction saction : s.getActions()) {
                    ActionVO action;
                    if (saction.getType() != 2) continue;
                    Integer actionId = saction.getActionId();
                    if (actionId == null) {
                        actionId = -41;
                    }
                    allowsCustomEndDate = !ApplyActionRendererProvider.ACTIONS_WITHOUT_CUSTOM_DURATION_ENDDATE.contains((action = (ActionVO)ActionManager.getInstance().get(actionId.intValue())).getId()) && !ApplyActionRendererProvider.STATUS_WITHOUT_CUSTOM_DURATION_ENDDATE.contains(action.getStatusID());
                    boolean bl = supportsEditDuration = action.getId() != -12 && action.getId() != -22 && 2 != (Integer)ApplyActionRendererProvider.EFFORTTIME.get();
                    if (HDUsersAndGroups.isSupporter()) continue;
                    supportsEditDuration = false;
                }
            }
            if (form.getSubmitType() == 3 && !ServerPluginManager.getInstance().isPluginLoaded("taskplanner.helpdesk") && !ServerPluginManager.getInstance().isPluginLoaded("taskplanner")) {
                throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("form.not.available", new Object[0]));
            }
        }
        return new LoadFormExecutionDataResponse(formDetailsDescription, encodedFormExecutionInfo, supportsEditDuration, allowsCustomEndDate);
    }

    public String getMethodName() {
        return "ticketforms.loadformexecutiondata";
    }

    public short getMethodType() {
        return 1;
    }
}

