/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.handler.config;

import com.inet.helpdesk.plugins.forms.client.data.config.SaveFormRequest;
import com.inet.helpdesk.plugins.forms.client.data.config.SingleFormPacket;
import com.inet.helpdesk.plugins.forms.client.data.model.FormDetailsDescription;
import com.inet.helpdesk.plugins.forms.client.handler.AbstractTicketFormsHandler;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormSection;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.helpdesk.plugins.forms.server.api.model.IconProvider;
import com.inet.id.GUID;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class SaveForm
extends AbstractTicketFormsHandler<SaveFormRequest, SingleFormPacket> {
    @Override
    public SingleFormPacket handle(HttpServletRequest req, HttpServletResponse resp, SaveFormRequest payload) throws IOException {
        HDForm form;
        FormsManager m = FormsManager.getInstance();
        FormDetailsDescription desc = payload.getForm();
        GUID formId = GUID.valueOf((String)desc.getFormId());
        List<@Nonnull FormSection> sections = payload.getForm().getSections().stream().map(s -> s.toFormSection()).collect(Collectors.toList());
        IconProvider icon = null;
        if (desc.getIcon() != null) {
            icon = IconProvider.fromBase64DataUri(desc.getIcon());
        }
        if (formId == null) {
            form = new HDForm(desc.getName(), GUID.generateNew(), GUID.valueOf((String)payload.getFolderId()), desc.getTitle(), sections, desc.isActivated(), icon, desc.getSubmitType(), desc.isShowOnStartPage(), desc.getStartPageLinkName(), desc.getStartPageLinkDescription(), desc.isUseFormLogo(), desc.getMaxAttachmentSizeMb());
            m.createForm(form);
        } else {
            HDForm oldForm = m.getForm(formId);
            Objects.requireNonNull(oldForm);
            form = new HDForm(desc.getName(), formId, oldForm.getParentFolderId(), desc.getTitle(), sections, oldForm.isActivated(), icon, oldForm.getSubmitType(), desc.isShowOnStartPage(), desc.getStartPageLinkName(), desc.getStartPageLinkDescription(), desc.isUseFormLogo(), desc.getMaxAttachmentSizeMb());
            m.updateForm(form);
        }
        return new SingleFormPacket(form.getId().toString());
    }

    public String getMethodName() {
        return "ticketforms.saveform";
    }
}

