/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.api.model;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.forms.server.api.model.FormField;
import com.inet.helpdesk.plugins.forms.server.api.model.FormSubmitAction;
import com.inet.helpdesk.plugins.forms.server.api.model.condition.AndBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@JsonData
@Immutable
public class FormSection {
    private String title;
    private String label;
    private List<FormField> fields;
    private List<FormSubmitAction> actions;
    private List<AndBlock> conditions;

    public FormSection(@Nullable String label, @Nonnull List<FormField> fields, @Nonnull List<FormSubmitAction> actions, @Nonnull List<AndBlock> conditions) {
        this(null, label, fields, actions, conditions);
    }

    public FormSection(@Nullable String title, @Nullable String label, @Nonnull List<FormField> fields, @Nonnull List<FormSubmitAction> actions, @Nonnull List<AndBlock> conditions) {
        this.title = title;
        this.label = label;
        this.conditions = new ArrayList<AndBlock>(conditions);
        this.fields = new ArrayList<FormField>(fields);
        this.actions = new ArrayList<FormSubmitAction>(actions);
    }

    private FormSection() {
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    @Nonnull
    public List<FormField> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Nonnull
    public List<FormSubmitAction> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    @Nonnull
    public List<AndBlock> getConditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }
}

