/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.api.model;

import com.inet.annotations.JsonData;
import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldOperator;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeBoolean;
import com.inet.field.fieldtypes.FieldTypeCurrency;
import com.inet.field.fieldtypes.FieldTypeDate;
import com.inet.field.fieldtypes.FieldTypeDouble;
import com.inet.field.fieldtypes.FieldTypeInteger;
import com.inet.field.fieldtypes.FieldTypeRating;
import com.inet.field.fieldtypes.FieldTypeSelect_String;
import com.inet.field.fieldtypes.FieldTypeString;
import com.inet.field.fieldtypes.FieldTypeTime;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.model.IconProvider;
import com.inet.lib.util.StringFunctions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@JsonData
@Immutable
public class FormField {
    public static final String FIELDTYPE_HTML = "htmltext";
    public static final String FIELDTYPE_ATTACHMENTS = "attachmentsadd";
    public static final String FIELD_KEY_TICKET_TEXT = "special_ticket_text";
    public static final String FIELDTYPE_UI_LINE = "line";
    public static final String FIELDTYPE_UI_LINK = "link";
    public static final String FIELDTYPE_UI_TEXT = "text";
    public static final String FIELDTYPE_UI_EMPTY_LINE = "emptyline";
    public static final String FIELDTYPE_UI_IMAGE = "image";
    @Nonnull
    private String key;
    @Nullable
    private String label;
    @Nonnull
    private FormFieldType fieldType;
    @Nonnull
    private String fieldDataType;
    @Nullable
    private List<String> select_options;
    @Nullable
    private String select_filter;
    private boolean applyToTicketText;
    private boolean includeLabelInInquiry;
    private boolean mandatory;
    @Deprecated
    private transient boolean hidden;
    private FormFieldVisibility visibility;
    @Deprecated
    private transient boolean labelInvisible;
    private FormLabelSetting labelSetting;
    private boolean customDefaultValue;
    @Nullable
    private String defaultValue;
    @Nullable
    private String placeholder;
    private Map<String, String> values = Map.of();
    @Nullable
    private transient IconProvider image;

    private FormField() {
    }

    public FormField(@Nonnull String key, @Nonnull FormFieldType fieldType, @Nonnull String fieldDataType, List<String> select_options, String select_filter, boolean applyToTicketText, boolean mandatory, String defaultValue, String placeholder, String label) {
        this(key, fieldType, fieldDataType, select_options, select_filter, applyToTicketText, true, mandatory, FormFieldVisibility.Normal, FormLabelSetting.HIDE, defaultValue, placeholder, label);
    }

    public FormField(@Nonnull String key, @Nonnull FormFieldType fieldType, @Nonnull String fieldDataType, List<String> select_options, String select_filter, boolean applyToTicketText, boolean mandatory, FormFieldVisibility visibility, String defaultValue, String placeholder, String label) {
        this(key, fieldType, fieldDataType, select_options, select_filter, applyToTicketText, true, mandatory, visibility, FormLabelSetting.HIDE, defaultValue, placeholder, label);
    }

    public FormField(@Nonnull String key, @Nonnull FormFieldType fieldType, @Nonnull String fieldDataType, List<String> select_options, String select_filter, boolean applyToTicketText, boolean includeLabelInInquiry, boolean mandatory, FormFieldVisibility visibility, FormLabelSetting labelSetting, String defaultValue, String placeholder, String label) {
        this(key, fieldType, fieldDataType, select_options, select_filter, applyToTicketText, true, mandatory, visibility, labelSetting, defaultValue != null, defaultValue, placeholder, label, Map.of(), null);
    }

    public FormField(@Nonnull String key, @Nonnull FormFieldType fieldType, @Nonnull String fieldDataType, List<String> select_options, String select_filter, boolean applyToTicketText, boolean includeLabelInInquiry, boolean mandatory, FormFieldVisibility visibility, FormLabelSetting labelSetting, boolean customDefaultValue, String defaultValue, String placeholder, String label, Map<String, String> values, @Nullable IconProvider image) {
        Objects.requireNonNull(key, "key of field cannot be null");
        Objects.requireNonNull(fieldType, "type of field cannot be null");
        Objects.requireNonNull(fieldDataType, "datatype of field cannot be null");
        this.key = key;
        this.fieldType = fieldType;
        this.fieldDataType = fieldDataType;
        this.select_options = select_options;
        this.select_filter = select_filter;
        this.applyToTicketText = applyToTicketText;
        this.includeLabelInInquiry = includeLabelInInquiry;
        this.labelSetting = labelSetting;
        this.mandatory = mandatory;
        this.visibility = visibility;
        this.customDefaultValue = fieldType == FormFieldType.Ticket ? customDefaultValue : true;
        this.defaultValue = defaultValue;
        this.placeholder = placeholder;
        this.label = label;
        this.values = new HashMap<String, String>(values);
        this.image = image;
        if (image != null) {
            this.values.put("imageextension", image.getExtensionFromMimeType());
        } else {
            this.values.remove("imageextension");
        }
    }

    public static FormField createForTicketField(TicketField<?> field, @Nullable String label, boolean mandatory, String defaultValue, boolean applyToTicketText) {
        TicketFieldDefinition fieldDefinition;
        FieldEditDefinition editDefinition;
        if (StringFunctions.isEmpty((String)label)) {
            label = field.getLabel();
        }
        if ((editDefinition = (fieldDefinition = Tickets.getFieldDefinitionByKey((String)field.getKey())).getEditDefinition()) == null) {
            throw new IllegalArgumentException("can only use field with an editInformation! key=" + field.getKey());
        }
        return new FormField(field.getKey(), FormFieldType.Ticket, editDefinition.getDisplayType(), null, null, applyToTicketText, mandatory, defaultValue, null, label);
    }

    public static FormField createForTicketField(TicketField<?> field, @Nullable String label, boolean mandatory, String defaultValue, String placeholder) {
        TicketFieldDefinition fieldDefinition;
        FieldEditDefinition editDefinition;
        if (StringFunctions.isEmpty((String)label)) {
            label = field.getLabel();
        }
        if ((editDefinition = (fieldDefinition = Tickets.getFieldDefinitionByKey((String)field.getKey())).getEditDefinition()) == null) {
            throw new IllegalArgumentException("can only use field with an editInformation! key=" + field.getKey());
        }
        return new FormField(field.getKey(), FormFieldType.Ticket, editDefinition.getDisplayType(), null, null, false, mandatory, defaultValue, placeholder, label);
    }

    public static FormField createForHtmlText(String fieldKey, boolean mandatory, String defaultValue, String placeholder, String label) {
        return new FormField(fieldKey, FormFieldType.Standard, FIELDTYPE_HTML, null, null, true, mandatory, defaultValue, placeholder, label);
    }

    public static FormField createForTicketText(boolean mandatory, boolean includeInTicketOrActionText, String defaultValue, String placeholder, String label) {
        return new FormField(FIELD_KEY_TICKET_TEXT, FormFieldType.Ticket, FIELDTYPE_HTML, null, null, includeInTicketOrActionText, mandatory, defaultValue, placeholder, label);
    }

    public static FormField createForStandardField(String fieldKey, String fieldType, boolean includeInInquiryText, boolean mandatory, String defaultValue, String placeholder, String label) {
        return FormField.createForStandardField(fieldKey, fieldType, includeInInquiryText, includeInInquiryText, mandatory, defaultValue, placeholder, label);
    }

    public static FormField createForStandardField(String fieldKey, String fieldType, boolean includeInInquiryText, boolean includeLabelInInquiryText, boolean mandatory, String defaultValue, String placeholder, String label) {
        return new FormField(fieldKey, FormFieldType.Standard, fieldType, null, null, includeInInquiryText, mandatory, FormFieldVisibility.Normal, defaultValue, placeholder, label);
    }

    public static FormField createForUIField(String fieldKey, String fieldType, String label, Map<String, String> values, @Nullable IconProvider image) {
        return new FormField(fieldKey, FormFieldType.Ui, fieldType, null, null, false, false, false, FormFieldVisibility.Normal, FormLabelSetting.SHOW, false, null, null, label, values, image);
    }

    public FormFieldType getFormFieldType() {
        return this.fieldType;
    }

    public FieldType<?> getFieldType() {
        Supplier<String> displayname = () -> this.label;
        switch (this.fieldType) {
            case Ticket: {
                if (this.getKey().equals(FIELD_KEY_TICKET_TEXT)) {
                    return new FieldTypeString(this.key, displayname){

                        public Set<FieldOperator> getSupportedOperators() {
                            return Set.of(FieldOperator.IS_NOT_EMPTY);
                        }
                    };
                }
                TicketField fieldByKey = Tickets.getFieldByKey((String)this.key);
                if (fieldByKey == null) {
                    throw new IllegalStateException("ticketfield with key " + this.key + " does not exist.");
                }
                return fieldByKey.getFieldType();
            }
            case Standard: {
                switch (this.fieldDataType) {
                    case "boolean": {
                        return new FieldTypeBoolean(this.key, displayname){

                            public Boolean valueOf(String value) {
                                Boolean valueOf = super.valueOf(value);
                                if (valueOf == null || !valueOf.booleanValue()) {
                                    return "true".equalsIgnoreCase(value);
                                }
                                return valueOf;
                            }
                        };
                    }
                    case "currency": {
                        return new FieldTypeCurrency(this.key, displayname);
                    }
                    case "dateonlyvalue": {
                        return new FieldTypeDate(this.key, displayname, false);
                    }
                    case "datevalue": {
                        return new FieldTypeDate(this.key, displayname, true);
                    }
                    case "double": {
                        return new FieldTypeDouble(this.key, displayname);
                    }
                    case "integer": {
                        return new FieldTypeInteger(this.key, displayname);
                    }
                    case "rating": {
                        return new FieldTypeRating(this.key, displayname);
                    }
                    case "select": 
                    case "selecteditable": 
                    case "selectmulti": 
                    case "selectmultieditable": {
                        return new FieldTypeSelect_String(this.key, displayname, includeDeleted -> {
                            if (this.select_options == null) {
                                return List.of();
                            }
                            return this.select_options.stream().map(str -> new SelectOption(str, str)).collect(Collectors.toList());
                        });
                    }
                    case "textarea": 
                    case "textinput": {
                        return new FieldTypeString(this.key, displayname);
                    }
                    case "htmltext": {
                        return new FieldTypeString(this.key, displayname){

                            public Set<FieldOperator> getSupportedOperators() {
                                return Set.of(FieldOperator.IS_NOT_EMPTY);
                            }
                        };
                    }
                    case "attachmentsadd": {
                        return new FieldTypeInteger(this.key, displayname);
                    }
                    case "timeonlyvalue": {
                        return new FieldTypeTime(this.key, displayname);
                    }
                }
                throw new UnsupportedOperationException(this.fieldDataType);
            }
        }
        throw new UnsupportedOperationException("No fieldType for form fields of type " + String.valueOf((Object)this.fieldType));
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getFieldDataType() {
        FieldEditDefinition editDefinition;
        TicketFieldDefinition fieldDefinition;
        if (this.fieldType == FormFieldType.Ticket && (fieldDefinition = Tickets.getFieldDefinitionByKey((String)this.key)) != null && (editDefinition = fieldDefinition.getEditDefinition()) != null) {
            return editDefinition.getDisplayType();
        }
        return this.fieldDataType;
    }

    @Nullable
    public List<String> getSelect_options() {
        return this.select_options;
    }

    public String getSelect_filter() {
        return this.select_filter;
    }

    public boolean isApplyToTicketText() {
        return this.applyToTicketText;
    }

    public boolean isIncludeLabelInInquiry() {
        return this.includeLabelInInquiry;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isCustomDefaultValue() {
        return this.customDefaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Nullable
    public String getPlaceholder() {
        return this.placeholder;
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    @Nonnull
    public FormLabelSetting getLabelSetting() {
        if (this.labelSetting == null) {
            this.labelSetting = this.labelInvisible ? FormLabelSetting.HIDE : FormLabelSetting.SHOW;
        }
        return this.labelSetting;
    }

    public Map<String, String> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    @Nullable
    public IconProvider getImage() {
        return this.image;
    }

    public static String getFieldDataTypeLabel(String fieldDataType) {
        switch (fieldDataType) {
            case "boolean": {
                return FieldSettingsType.TYPE_BOOLEAN.getLabel();
            }
            case "currency": {
                return FieldSettingsType.TYPE_CURRENCY.getLabel();
            }
            case "dateonlyvalue": {
                return FieldSettingsType.TYPE_DATE.getLabel();
            }
            case "datevalue": {
                return FieldSettingsType.TYPE_DATE_TIME.getLabel();
            }
            case "double": {
                return FieldSettingsType.TYPE_DOUBLE.getLabel();
            }
            case "integer": {
                return FieldSettingsType.TYPE_NUMBER.getLabel();
            }
            case "rating": {
                return FieldSettingsType.TYPE_RATING.getLabel();
            }
            case "select": 
            case "selecteditable": 
            case "selectmulti": 
            case "selectmultieditable": {
                return FieldSettingsType.TYPE_SELECT.getLabel();
            }
            case "textarea": {
                return FieldSettingsType.TYPE_MULTILINE_TEXT.getLabel();
            }
            case "textinput": {
                return FieldSettingsType.TYPE_TEXT.getLabel();
            }
            case "timeonlyvalue": {
                return FieldSettingsType.TYPE_TIME.getLabel();
            }
            case "htmltext": {
                return FormsServerPlugin.MSG.getMsg("fieldType.html", new Object[0]);
            }
            case "attachmentsadd": {
                return FormsServerPlugin.MSG.getMsg("fieldType.attachments", new Object[0]);
            }
            case "line": {
                return FormsServerPlugin.MSG.getMsg("fieldType.ui.line", new Object[0]);
            }
            case "link": {
                return FormsServerPlugin.MSG.getMsg("fieldType.ui.link", new Object[0]);
            }
            case "text": {
                return FormsServerPlugin.MSG.getMsg("fieldType.ui.text", new Object[0]);
            }
            case "emptyline": {
                return FormsServerPlugin.MSG.getMsg("fieldType.ui.emptyline", new Object[0]);
            }
            case "image": {
                return FormsServerPlugin.MSG.getMsg("fieldType.ui.image", new Object[0]);
            }
        }
        throw new UnsupportedOperationException(fieldDataType);
    }

    public void restoreIcon(IconProvider image) {
        this.image = image;
    }

    public FormFieldVisibility getVisibility() {
        if (this.visibility == null) {
            this.visibility = this.hidden ? FormFieldVisibility.Hidden : FormFieldVisibility.Normal;
        }
        return this.visibility;
    }

    public static enum FormFieldVisibility {
        Normal,
        ReadOnly,
        Hidden;

    }

    public static enum FormLabelSetting {
        SHOW,
        HIDE,
        KEEP_SPACE;

    }

    public static enum FormFieldType {
        Ticket,
        Standard,
        Ui;

    }
}

