/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.api.model;

import com.inet.id.GUID;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import com.inet.remote.gui.modules.importexport.ExportableWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FormDir
implements ExportableWidget {
    private String name;
    private GUID folderID;
    @Nullable
    private GUID parentId;
    @Nonnull
    private List<FormDir> children = new ArrayList<FormDir>();
    @Nullable
    private List<UsersOrGroupsSelection.SelectedMember> sharings;

    public FormDir(String name, @Nonnull GUID parent) {
        this(name, parent, null);
    }

    public FormDir(String name, @Nonnull GUID parent, List<UsersOrGroupsSelection.SelectedMember> sharings) {
        Objects.requireNonNull(parent);
        this.name = name;
        this.parentId = parent;
        if (sharings != null) {
            this.sharings = new ArrayList<UsersOrGroupsSelection.SelectedMember>(sharings);
        }
    }

    public FormDir(String name, GUID folderID, @Nullable GUID parentId, @Nonnull List<FormDir> children, @Nullable List<UsersOrGroupsSelection.SelectedMember> sharings) {
        this.name = name;
        this.folderID = folderID;
        this.parentId = parentId;
        if (sharings != null) {
            this.sharings = new ArrayList<UsersOrGroupsSelection.SelectedMember>(sharings);
        }
        this.children = new ArrayList<FormDir>(children);
    }

    public GUID getParentId() {
        return this.parentId;
    }

    public List<FormDir> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public String getName() {
        return this.name;
    }

    public GUID getFolderID() {
        return this.folderID;
    }

    @Nullable
    public List<UsersOrGroupsSelection.SelectedMember> getSharings() {
        return this.sharings == null ? null : Collections.unmodifiableList(this.sharings);
    }

    @Nullable
    public FormDir find(GUID folderId) {
        if (this.folderID.equals((Object)folderId)) {
            return this;
        }
        Optional<FormDir> findFirst = this.children.stream().map(f -> f.find(folderId)).filter(Objects::nonNull).findFirst();
        if (findFirst.isPresent()) {
            return findFirst.get();
        }
        return null;
    }

    public GUID getId() {
        return this.folderID;
    }
}

