/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.autotext.data.AutoTextPlaceholder;
import com.inet.helpdesk.config.autotext.data.AutoTextPlaceholderProvider;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeTicketGUID;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.helpdesk.plugins.forms.server.api.model.FormExecutionInfo;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.usersandgroups.api.user.UserAccount;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FormsAutoTextPlaceholderProvider
implements AutoTextPlaceholderProvider {
    private static final ConfigValue<String> EXTERNAL_URL = new ConfigValue(ConfigKey.SERVER_URL);

    @Nullable
    public List<AutoTextPlaceholder> provideAdditionalAutoTextPlaceholders() {
        ArrayList<AutoTextPlaceholder> placeholders = new ArrayList<AutoTextPlaceholder>();
        AutoTextPlaceholder forms = new AutoTextPlaceholder("Forms");
        try {
            List<HDForm> allForms = this.getFormsManager().getAllForms();
            List sortedForms = allForms.stream().map(form -> Map.entry(this.getPath((HDForm)form), form)).sorted((e1, e2) -> ((String)e1.getKey()).compareToIgnoreCase((String)e2.getKey())).collect(Collectors.toList());
            for (Map.Entry entry : sortedForms) {
                String path = (String)entry.getKey();
                String guid = ((HDForm)entry.getValue()).getId().toString();
                if (path == null || guid == null) continue;
                forms.addEntry("form.url." + guid, path);
            }
            placeholders.add(forms);
        }
        catch (AccessDeniedException allForms) {
        }
        catch (Exception e) {
            FormsServerPlugin.LOGGER.error("Error loading forms for autotext placeholders", (Throwable)e);
        }
        return placeholders;
    }

    protected FormsManager getFormsManager() {
        return FormsManager.getInstance();
    }

    @Nullable
    public String getCustomPlaceholderValue(@Nonnull String placeHolder, @Nullable TicketVO ticket, @Nullable Integer stepId, UserAccount currentUser) {
        if (ticket == null) {
            return null;
        }
        GUID ticketGUID = (GUID)ticket.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_TICKET_GUID);
        if (ticketGUID == null) {
            ticketGUID = TicketAttributeTicketGUID.getFallbackValueForTicketID((int)ticket.getID());
        }
        if (placeHolder.startsWith("form.url.")) {
            String id = placeHolder.substring("form.url.".length());
            HDForm form = this.getFormsManager().getForm(GUID.valueOf((String)id));
            if (form != null) {
                FormExecutionInfo formExecutionInfo = new FormExecutionInfo(ticketGUID, form.getId());
                String unifiedGUID = null;
                try {
                    unifiedGUID = formExecutionInfo.toEncodedString();
                    String baseURL = (String)EXTERNAL_URL.get();
                    if (baseURL.endsWith("/")) {
                        baseURL = baseURL.substring(0, baseURL.length() - 1);
                    }
                    return baseURL + "/forms/" + unifiedGUID;
                }
                catch (IOException e) {
                    HDLogger.debug((Object)e);
                }
            }
        }
        return null;
    }

    private String getPath(HDForm form) {
        try {
            FormDir folder;
            Object path = form.getName();
            GUID parentId = form.getParentFolderId();
            FormsManager formsManager = this.getFormsManager();
            while (parentId != null && !parentId.equals((Object)formsManager.getRootFolderID()) && (folder = formsManager.getFolder(parentId)) != null) {
                path = folder.getName() + "/" + (String)path;
                parentId = folder.getParentId();
            }
            return path;
        }
        catch (Exception e) {
            FormsServerPlugin.LOGGER.error("Error getting form path", (Throwable)e);
            return form.getName();
        }
    }
}

