/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.servlet;

import com.inet.error.BaseErrorCode;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.plugins.forms.client.handler.execution.ExecuteFormHandler;
import com.inet.helpdesk.plugins.forms.client.handler.execution.GetSelectOptions_Form;
import com.inet.helpdesk.plugins.forms.client.handler.execution.LoadFormData;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormExecutionInfo;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.remote.gui.angular.AngularApplicationServlet;
import com.inet.remote.gui.angular.AngularContentService;
import com.inet.remote.gui.angular.ModuleMetaData;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;

public class FormExecutionServlet
extends AngularApplicationServlet {
    public FormExecutionServlet() {
        super("/forms");
        this.addServiceMethod(new LoadFormData());
        this.addServiceMethod(new ExecuteFormHandler());
        this.addServiceMethod((ServiceMethod)new GetSelectOptions_Form());
    }

    public void handleGet(HttpServletRequest request, HttpServletResponse response, String pathInfo, HashMap<String, String> replace) throws IOException {
        if (!StringFunctions.isEmpty((String)pathInfo)) {
            if (pathInfo.endsWith("/")) {
                pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
            }
            GUID formId = null;
            GUID ticketId = null;
            try {
                try {
                    FormExecutionInfo formExecutionInfo = FormExecutionInfo.decodeFormExecutionInfo(pathInfo);
                    formId = formExecutionInfo.getFormGUID();
                    ticketId = formExecutionInfo.getTicketGUID();
                }
                catch (IOException ex) {
                    formId = GUID.valueOf((String)pathInfo);
                }
            }
            catch (IllegalArgumentException ex) {
                HDLogger.debug((Object)ex);
            }
            if (formId != null) {
                try {
                    FormsManager.getInstance().checkCanApplyForm(formId, ticketId);
                }
                catch (IllegalArgumentException ex) {
                }
                catch (AccessDeniedException ex) {
                    if (ex.getErrorCode() == BaseErrorCode.UserLoginRequired.getErrorCodeNumber()) {
                        throw ex;
                    }
                }
                catch (Exception ex) {
                    throw new ClientMessageException(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        ModuleMetaData moduleMetaData = new ModuleMetaData(this.getPath(), ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/forms/client/html/formExecution.html"));
        moduleMetaData.setName(FormsServerPlugin.MSG_CLIENT.getMsg("ticketForms.execute", new Object[0]));
        moduleMetaData.addJsPath("ticket.basic.js");
        moduleMetaData.addJsPath("ticketform.execution.js");
        moduleMetaData.addJsPath("helpdesk.attachmentdisplay.js");
        HashMap properties = new HashMap();
        AngularContentService.serveTemplate((HttpServletRequest)request, (HttpServletResponse)response, properties, (ModuleMetaData)moduleMetaData);
    }
}

