/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.handler.config;

import com.inet.field.fieldtypes.FieldOperator;
import com.inet.field.fieldtypes.FieldTypeBoolean;
import com.inet.field.fieldtypes.FieldTypeCurrency;
import com.inet.field.fieldtypes.FieldTypeDate;
import com.inet.field.fieldtypes.FieldTypeDouble;
import com.inet.field.fieldtypes.FieldTypeInteger;
import com.inet.field.fieldtypes.FieldTypeRating;
import com.inet.field.fieldtypes.FieldTypeSelect_String;
import com.inet.field.fieldtypes.FieldTypeString;
import com.inet.field.fieldtypes.FieldTypeTime;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.forms.client.data.config.AvailableFieldDescription;
import com.inet.helpdesk.plugins.forms.client.data.config.LoadFormDetailsResponse;
import com.inet.helpdesk.plugins.forms.client.data.config.SingleFormPacket;
import com.inet.helpdesk.plugins.forms.client.data.model.ActionDescription;
import com.inet.helpdesk.plugins.forms.client.data.model.FormDetailsDescription;
import com.inet.helpdesk.plugins.forms.client.handler.AbstractTicketFormsHandler;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormField;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class LoadFormDetails
extends AbstractTicketFormsHandler<SingleFormPacket, LoadFormDetailsResponse> {
    private static List<String> FIELD_DATA_TYPES;
    private static List<String> FIELD_UI_DATA_TYPES;

    @Override
    public LoadFormDetailsResponse handle(HttpServletRequest req, HttpServletResponse resp, SingleFormPacket payload) throws IOException {
        FormsManager m = FormsManager.getInstance();
        String formId = payload.getFormId();
        FormDetailsDescription formDetailsDescription = null;
        String error = null;
        if (!StringFunctions.isEmpty((String)formId)) {
            HDForm form = m.getForm(GUID.valueOf((String)formId));
            if (form == null) {
                throw new ClientMessageException(FormsServerPlugin.MSG_CLIENT.getMsg("ticketForms.noSuchForm", new Object[]{formId}));
            }
            formDetailsDescription = FormDetailsDescription.createForFormModification(form);
            try {
                form.validate();
            }
            catch (ClientMessageException | IllegalArgumentException ex) {
                error = ex.getMessage();
            }
        }
        List<AvailableFieldDescription> ticketFields = this.ticketFields();
        List<AvailableFieldDescription> standardFields = this.standardFields();
        return new LoadFormDetailsResponse(formDetailsDescription, ticketFields, standardFields, this.uiFields(), error, this.getAvailableActions(), this.createOperatorMap(ticketFields, standardFields), this.createOperatorDisplayNames());
    }

    private Map<FieldOperator, String> createOperatorDisplayNames() {
        HashMap<FieldOperator, String> map = new HashMap<FieldOperator, String>();
        for (FieldOperator op : FieldOperator.values()) {
            map.put(op, op.getOperatorDisplayName());
        }
        return map;
    }

    private Map<String, List<FieldOperator>> createOperatorMap(List<AvailableFieldDescription> ticketFields, List<AvailableFieldDescription> standardFields) {
        String fieldDataType;
        HashMap<String, List<FieldOperator>> operators = new HashMap<String, List<FieldOperator>>();
        for (AvailableFieldDescription ticketField : ticketFields) {
            fieldDataType = ticketField.getFieldDataType();
            if (ticketField.getKey().equals("special_ticket_text")) continue;
            TicketField fieldInstance = Tickets.getFieldByKey((String)ticketField.getKey());
            if (fieldInstance == null) {
                fieldInstance = Tickets.getAttributeByKey((String)ticketField.getKey());
            }
            operators.put(fieldDataType + "_" + ticketField.getKey(), new ArrayList(fieldInstance.getFieldType().getSupportedOperators()));
        }
        for (AvailableFieldDescription standardField : standardFields) {
            fieldDataType = standardField.getFieldDataType();
            String key = null;
            Supplier<String> displayname = () -> standardField.getLabel();
            Object fieldType = switch (fieldDataType) {
                case "boolean" -> new FieldTypeBoolean(key, displayname){

                    public Boolean valueOf(String value) {
                        Boolean valueOf = super.valueOf(value);
                        if (valueOf == null || !valueOf.booleanValue()) {
                            return "true".equalsIgnoreCase(value);
                        }
                        return valueOf;
                    }
                };
                case "currency" -> new FieldTypeCurrency(key, displayname);
                case "dateonlyvalue" -> new FieldTypeDate(key, displayname, false);
                case "datevalue" -> new FieldTypeDate(key, displayname, true);
                case "double" -> new FieldTypeDouble(key, displayname);
                case "integer" -> new FieldTypeInteger(key, displayname);
                case "rating" -> new FieldTypeRating(key, displayname);
                case "select", "selecteditable", "selectmulti", "selectmultieditable" -> new FieldTypeSelect_String(key, displayname, includeDeleted -> List.of());
                case "textarea", "textinput" -> new FieldTypeString(key, displayname);
                case "attachmentsadd" -> new FieldTypeInteger(key, displayname);
                case "timeonlyvalue" -> new FieldTypeTime(key, displayname);
                case "htmltext" -> new FieldTypeString(key, displayname){

                    public Set<FieldOperator> getSupportedOperators() {
                        return Set.of(FieldOperator.IS_NOT_EMPTY);
                    }
                };
                default -> throw new UnsupportedOperationException(fieldDataType);
            };
            operators.put(fieldDataType, new ArrayList(fieldType.getSupportedOperators()));
        }
        return operators;
    }

    private List<AvailableFieldDescription> ticketFields() {
        List list = Tickets.getAllTicketFields().stream().map(f -> {
            TicketFieldDefinition fieldDefinitionByKey = Tickets.getFieldDefinitionByKey((String)f.getKey());
            if (fieldDefinitionByKey != null && fieldDefinitionByKey.getEditDefinition() != null && (fieldDefinitionByKey.getEditDefinition().isAvailable(List.of()) || f.getKey().equals(Tickets.FIELD_OWNER_GUID.getKey()))) {
                return AvailableFieldDescription.forTicketField(f, fieldDefinitionByKey.getEditDefinition().getDisplayType());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        list.add(new AvailableFieldDescription(FormField.FormFieldType.Ticket, Tickets.ATTRIBUTE_STATUS_ID.getKey(), Tickets.ATTRIBUTE_STATUS_ID.getLabel(), "select", null, Collections.emptyMap()));
        list.add(new AvailableFieldDescription(FormField.FormFieldType.Ticket, "special_ticket_text", FormsServerPlugin.MSG_CLIENT.getMsg("ticketforms.configuration.field.tickettext", new Object[0]), "htmltext", null, Collections.emptyMap()));
        return list;
    }

    private List<AvailableFieldDescription> standardFields() {
        Function<String, AvailableFieldDescription> converter = fieldDataType -> AvailableFieldDescription.forStandardField(fieldDataType, FormField.getFieldDataTypeLabel(fieldDataType));
        return LoadFormDetails.standardFieldDataTypes().stream().filter(t -> !t.equals("selecteditable") && !t.equals("selectmulti")).map(converter).collect(Collectors.toList());
    }

    public static List<String> standardFieldDataTypes() {
        if (FIELD_DATA_TYPES == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("boolean");
            list.add("currency");
            list.add("dateonlyvalue");
            list.add("datevalue");
            list.add("double");
            list.add("textarea");
            list.add("integer");
            list.add("rating");
            list.add("select");
            list.add("selecteditable");
            list.add("selectmulti");
            list.add("textinput");
            list.add("timeonlyvalue");
            list.add("htmltext");
            if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                list.add("attachmentsadd");
            }
            FIELD_DATA_TYPES = list;
        }
        return FIELD_DATA_TYPES;
    }

    private List<AvailableFieldDescription> uiFields() {
        Function<String, AvailableFieldDescription> converter = fieldDataType -> AvailableFieldDescription.forUiField(fieldDataType, FormField.getFieldDataTypeLabel(fieldDataType));
        return LoadFormDetails.uiFieldDataTypes().stream().map(converter).collect(Collectors.toList());
    }

    public static List<String> uiFieldDataTypes() {
        if (FIELD_UI_DATA_TYPES == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("line");
            list.add("link");
            list.add("text");
            list.add("emptyline");
            list.add("image");
            FIELD_UI_DATA_TYPES = list;
        }
        return FIELD_UI_DATA_TYPES;
    }

    public String getMethodName() {
        return "ticketforms.loadformdetails";
    }

    private List<ActionDescription> getAvailableActions() {
        List<Integer> notAllowedActions = Arrays.asList(-41, -33, -19, -7, -3, 10, -25, -37, -1, -13, -214);
        ArrayList<ActionDescription> result = new ArrayList<ActionDescription>();
        ActionManager actionManager = ActionManager.getInstance();
        List all = actionManager.getAll(true);
        for (ActionVO actionVO : all) {
            if (actionVO.getId() != -40 && (notAllowedActions.contains(actionVO.getId()) || actionVO.isInternal())) continue;
            result.add(new ActionDescription(actionVO.getId(), actionVO.getDisplayValue(), actionVO.getStatusID()));
        }
        result.sort((a, b) -> a.getName().compareTo(b.getName()));
        ActionVO applyForm = (ActionVO)actionManager.get(-41);
        result.add(0, new ActionDescription(-41, applyForm.getDisplayValue(), applyForm.getStatusID()));
        return result;
    }
}

