/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.handler.config;

import com.inet.helpdesk.plugins.forms.client.data.config.ImportFormRequest;
import com.inet.helpdesk.plugins.forms.client.data.config.ImportFormResponse;
import com.inet.helpdesk.plugins.forms.client.handler.AbstractTicketFormsHandler;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.helpdesk.plugins.forms.server.api.model.IconProvider;
import com.inet.helpdesk.plugins.forms.server.internal.persistence.PersistedForm;
import com.inet.html.utils.Logger;
import com.inet.http.ClientMessageException;
import com.inet.http.utils.MimeTypes;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import com.inet.remote.gui.modules.importexport.GenericImportHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ImportForm
extends AbstractTicketFormsHandler<ImportFormRequest, ImportFormResponse>
implements GenericImportHandler<FormDir, HDForm> {
    public String getMethodName() {
        return "ticketforms.importform";
    }

    @Override
    public ImportFormResponse handle(HttpServletRequest req, HttpServletResponse resp, ImportFormRequest input) throws IOException {
        FormDir folder;
        FormsManager formsManager = (FormsManager)ServerPluginManager.getInstance().getSingleInstance(FormsManager.class);
        ArrayList<String> errorMessages = new ArrayList<String>();
        ArrayList<String> existingPaths = new ArrayList<String>();
        AtomicInteger importedCount = new AtomicInteger(0);
        boolean validateFirst = input.isValidateFirst();
        boolean forceOverwrite = input.isForceOverwrite();
        GUID folderId = formsManager.getRootFolderID();
        if (!StringFunctions.isEmpty((String)input.getFolderId())) {
            folderId = GUID.valueOf((String)input.getFolderId());
        }
        if ((folder = formsManager.getFolder(folderId)) == null) {
            throw new ClientMessageException("current folder does not exist", (Throwable)new FileNotFoundException(input.getFolderId()));
        }
        this.iterateParts(req, input.getAttachments(), errorMessages, existingPaths, importedCount, validateFirst, forceOverwrite, folder);
        if (validateFirst) {
            if (!existingPaths.isEmpty()) {
                return new ImportFormResponse(errorMessages, existingPaths, importedCount.get());
            }
            errorMessages.clear();
            importedCount.set(0);
            this.iterateParts(req, input.getAttachments(), errorMessages, existingPaths, importedCount, false, forceOverwrite, folder);
        }
        return new ImportFormResponse(errorMessages, null, importedCount.get());
    }

    private String createPathOfForm(FormDir folder, HDForm form, FormsManager formsManager) {
        FormDir parent = folder;
        Object parentPath = folder.getName();
        while (parent != null && parent.getParentId() != null) {
            if ((parent = formsManager.getFolder(parent.getParentId())) == null || parent.getName().isEmpty()) continue;
            parentPath = parent.getName() + "  /  " + (String)parentPath;
        }
        parentPath = (String)parentPath + (((String)parentPath).isEmpty() ? "" : "  /  ") + form.getName();
        return parentPath;
    }

    private String generateUniqueName(HDForm form, FormDir folder, FormsManager formsManager) {
        Set existingNames = formsManager.listFormsInFolder(folder.getFolderID()).stream().filter(p -> !p.getId().equals((Object)form.getId())).map(HDForm::getName).map(String::toLowerCase).collect(Collectors.toSet());
        String name = form.getName();
        if (StringFunctions.isEmpty((String)name)) {
            name = "form";
        }
        int i = 1;
        Object newName = name;
        while (existingNames.contains(((String)newName).toLowerCase())) {
            newName = name + " " + FormsServerPlugin.MSG.getMsg("import.namesuffix", new Object[0]) + (String)(i == 1 ? "" : " (" + String.valueOf(i) + ")");
            ++i;
        }
        return newName;
    }

    public GUID importFolder(boolean validateFirst, ZipFile zipFile, String path, FormDir currentfolder, String currentPath) throws IOException {
        GUID currentFolderId;
        List sh = null;
        FormsManager formsManager = FormsManager.getInstance();
        ZipEntry folderSharings = zipFile.getEntry(currentPath + "folder.sharings");
        if (folderSharings != null) {
            try {
                sh = (List)new Json().fromJson(zipFile.getInputStream(folderSharings), List.class, new Type[]{UsersOrGroupsSelection.SelectedMember.class});
            }
            catch (JsonException ex) {
                Logger.error((Throwable)ex);
            }
        }
        String folderName = path;
        if (currentfolder == null) {
            currentFolderId = GUID.generateNew();
        } else {
            Optional<FormDir> findAny = currentfolder.getChildren().stream().filter(f -> f.getName().equals(folderName)).findAny();
            if (!findAny.isPresent()) {
                currentFolderId = !validateFirst ? formsManager.createFolder(new FormDir(path, currentfolder.getFolderID(), sh)) : GUID.generateNew();
            } else {
                currentFolderId = findAny.get().getFolderID();
                if (!validateFirst) {
                    formsManager.updateFolder(currentFolderId, folderName, sh);
                }
            }
        }
        return currentFolderId;
    }

    public void importWidget(InputStream inputStream, FormDir folder, List<String> existingPathes, boolean validateFirst, boolean forceOverwrite) throws IOException {
        Optional<HDForm> optional;
        ZipEntry entry;
        FormsManager formsManager = (FormsManager)ServerPluginManager.getInstance().getSingleInstance(FormsManager.class);
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        PersistedForm persistedForm = null;
        IconProvider icon = null;
        HashMap<String, 2> images = new HashMap<String, 2>();
        while ((entry = zipInputStream.getNextEntry()) != null) {
            if (entry.getName().endsWith(".json")) {
                persistedForm = (PersistedForm)new Json().fromJson((InputStream)zipInputStream, PersistedForm.class);
            } else {
                String name = entry.getName();
                if (name.contains("_icon.")) {
                    final ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOFunctions.copyData((InputStream)zipInputStream, (OutputStream)out);
                    final String mimeType = MimeTypes.getMimeType((String)entry.getName());
                    icon = new IconProvider(){

                        @Override
                        public InputStream openStream() {
                            return new ByteArrayInputStream(out.toByteArray());
                        }

                        @Override
                        public String getMimeType() {
                            return mimeType;
                        }
                    };
                } else if (name.contains("_image_")) {
                    String fieldKey = name.substring(name.indexOf("_image_") + 7, name.lastIndexOf("."));
                    final ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOFunctions.copyData((InputStream)zipInputStream, (OutputStream)out);
                    final String mimeType = MimeTypes.getMimeType((String)entry.getName());
                    IconProvider img = new IconProvider(){

                        @Override
                        public InputStream openStream() {
                            return new ByteArrayInputStream(out.toByteArray());
                        }

                        @Override
                        public String getMimeType() {
                            return mimeType;
                        }
                    };
                    images.put(fieldKey, img);
                }
            }
            zipInputStream.closeEntry();
        }
        if (persistedForm == null) {
            throw new ClientMessageException("No form in file", (Throwable)new FileNotFoundException("No form in file"));
        }
        HDForm form = new HDForm(persistedForm.getName(), persistedForm.getId(), persistedForm.getParentFolderId(), persistedForm.getTitle(), persistedForm.getSections(), persistedForm.isActivated(), icon, persistedForm.getSubmitType(), persistedForm.isShowOnStartPage(), persistedForm.getStartPageLinkName(), persistedForm.getStartPageLinkDescription(), persistedForm.isUseFormLogo(), persistedForm.getMaxAttachmentSizeMb());
        if (!images.isEmpty()) {
            form.getSections().forEach(s -> s.getFields().forEach(f -> {
                if (f.getValues().get("imageextension") != null) {
                    IconProvider iconProvider = (IconProvider)images.get(f.getKey());
                    if (iconProvider == null) {
                        FormsServerPlugin.LOGGER.warn((Object)("[import] cannot find image for element " + f.getLabel()));
                        return;
                    }
                    f.restoreIcon(iconProvider);
                }
            }));
        }
        if (folder != null) {
            form = new HDForm(form.getName(), form.getId(), folder.getFolderID(), form.getTitle(), form.getSections(), form.isActivated(), form.getIcon(), form.getSubmitType(), form.isShowOnStartPage(), form.getStartPageLinkName(), form.getStartPageLinkDescription(), form.isUseFormLogo(), form.getMaxAttachmentSizeMb());
        }
        boolean override = false;
        GUID formId = form.getId();
        if (formsManager.getForm(formId) != null) {
            form = new HDForm(form.getName(), GUID.generateNew(), form.getParentFolderId(), form.getTitle(), form.getSections(), form.isActivated(), form.getIcon(), form.getSubmitType(), form.isShowOnStartPage(), form.getStartPageLinkName(), form.getStartPageLinkDescription(), form.isUseFormLogo(), form.getMaxAttachmentSizeMb());
        }
        String formName = form.getName();
        GUID formFoundId = null;
        if (folder != null && (optional = formsManager.listFormsInFolder(folder.getFolderID()).stream().filter(p -> p.getName().equalsIgnoreCase(formName)).findFirst()).isPresent()) {
            formFoundId = optional.get().getId();
        }
        if (formFoundId != null) {
            String parentPath = this.createPathOfForm(folder, form, formsManager);
            existingPathes.add(parentPath);
            if (forceOverwrite || validateFirst) {
                form = new HDForm(form.getName(), formFoundId, folder.getFolderID(), form.getTitle(), form.getSections(), form.isActivated(), form.getIcon(), form.getSubmitType(), form.isShowOnStartPage(), form.getStartPageLinkName(), form.getStartPageLinkDescription(), form.isUseFormLogo(), form.getMaxAttachmentSizeMb());
                override = true;
            } else {
                String uniqueName = this.generateUniqueName(form, folder, formsManager);
                if (!uniqueName.equalsIgnoreCase(form.getName())) {
                    form = new HDForm(uniqueName, form.getId(), folder.getFolderID(), form.getTitle(), form.getSections(), form.isActivated(), form.getIcon(), form.getSubmitType(), form.isShowOnStartPage(), form.getStartPageLinkName(), form.getStartPageLinkDescription(), form.isUseFormLogo(), form.getMaxAttachmentSizeMb());
                }
            }
        }
        if (!validateFirst) {
            if (override) {
                formsManager.updateForm(form, false);
            } else {
                if (folder == null) {
                    throw new ClientMessageException("No folder created", (Throwable)new FileNotFoundException("No folder created"));
                }
                formsManager.createForm(form, false);
            }
        }
    }

    public FormDir getFolderById(GUID id) {
        return FormsManager.getInstance().getFolder(id);
    }

    public List<String> listOfFilesForFolder() {
        return List.of("folder.sharings");
    }
}

