/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.handler.config;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.plugins.forms.client.data.config.GetTicketFormsListRequest;
import com.inet.helpdesk.plugins.forms.client.data.config.GetTicketFormsListResponse;
import com.inet.helpdesk.plugins.forms.client.data.model.FormDescription;
import com.inet.helpdesk.plugins.forms.client.data.model.FormFolderDescription;
import com.inet.helpdesk.plugins.forms.client.handler.AbstractTicketFormsHandler;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.helpdesk.plugins.forms.server.api.model.FormExecutionInfo;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;

public class GetTicketFormsList
extends AbstractTicketFormsHandler<GetTicketFormsListRequest, GetTicketFormsListResponse> {
    @Override
    public GetTicketFormsListResponse handle(HttpServletRequest req, HttpServletResponse resp, GetTicketFormsListRequest payload) throws IOException {
        ArrayList<FormDescription> formList = new ArrayList<FormDescription>();
        ArrayList<FormFolderDescription> foldersList = new ArrayList<FormFolderDescription>();
        Stack<FormFolderDescription> folderBreadcrumbs = new Stack<FormFolderDescription>();
        FormsManager manager = (FormsManager)ServerPluginManager.getInstance().getSingleInstance(FormsManager.class);
        String folderId = payload.getFormFolderId();
        ArrayList<HDForm> forms = null;
        List<FormDir> subfolders = null;
        String searchTerm = payload.getSearchTerm();
        FormDir rootFolder = manager.getFolderStructure();
        if (!StringFunctions.isEmpty((String)folderId)) {
            GUID folderGuid = GUID.valueOf((String)folderId);
            FormDir folder = manager.getFolder(folderGuid);
            if (folder != null) {
                if (this.hasParentMatch(searchTerm, folder, manager)) {
                    searchTerm = "";
                }
                forms = new ArrayList<HDForm>(manager.listFormsInFolder(folderGuid));
                subfolders = folder.getChildren();
            }
            this.getFolderBreadCrumbs(folderGuid, folderBreadcrumbs, manager);
        } else {
            forms = new ArrayList<HDForm>(manager.listFormsInFolder(rootFolder.getFolderID()));
            subfolders = rootFolder.getChildren();
            folderId = rootFolder.getFolderID().toString();
        }
        if (payload.isGetAllForms()) {
            this.addFormsFromSubfolders(forms, searchTerm, subfolders, manager);
        }
        if (forms != null) {
            for (HDForm ticketForm : forms) {
                boolean hasErrors = false;
                try {
                    ticketForm.validate();
                }
                catch (Throwable t) {
                    hasErrors = true;
                }
                if (payload.isModifyOnly() && ticketForm.getSubmitType() != 2) continue;
                GUID ticketGUID = null;
                if (payload.getIncludeExecutionIDsForTicket() > 0) {
                    TicketVO ticket = TicketManager.getReader().getTicket(payload.getIncludeExecutionIDsForTicket());
                    ticketGUID = (GUID)ticket.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_TICKET_GUID);
                }
                if (!StringFunctions.isEmpty((String)searchTerm) && !ticketForm.getName().toLowerCase().contains(searchTerm.toLowerCase())) continue;
                String executionInfoId = new FormExecutionInfo(ticketGUID, ticketForm.getId()).toEncodedString();
                FormDescription formDescription = new FormDescription(ticketForm.getId(), ticketForm.getName(), ticketForm.getTitle(), hasErrors, ticketForm.isActivated(), ticketForm.getIcon() != null, ticketForm.getSubmitType(), executionInfoId);
                formList.add(formDescription);
            }
        }
        if (subfolders != null && !payload.isGetAllForms()) {
            for (FormDir subfolder : subfolders) {
                if (!StringFunctions.isEmpty((String)searchTerm) && !this.isMatchingFolder(searchTerm, subfolder, manager)) continue;
                foldersList.add(new FormFolderDescription(subfolder.getFolderID().toString(), subfolder.getName(), !subfolder.getChildren().isEmpty(), !manager.listFormsInFolder(subfolder.getFolderID()).isEmpty(), subfolder.getSharings()));
            }
        }
        formList.sort(new Comparator<FormDescription>(){

            @Override
            public int compare(FormDescription o1, FormDescription o2) {
                int compare = Collator.getInstance(ClientLocale.getThreadLocale()).compare(o1.getName(), o2.getName());
                if (compare == 0) {
                    compare = o1.getId().toString().compareTo(o2.getId().toString());
                }
                return compare;
            }
        });
        foldersList.sort(new Comparator<FormFolderDescription>(){

            @Override
            public int compare(FormFolderDescription o1, FormFolderDescription o2) {
                int compare = String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
                if (compare == 0) {
                    compare = o1.getId().toString().compareTo(o2.getId().toString());
                }
                return compare;
            }
        });
        return new GetTicketFormsListResponse(folderId, rootFolder.getFolderID().toString(), formList, foldersList, folderBreadcrumbs);
    }

    private void addFormsFromSubfolders(List<HDForm> forms, String searchTerm, List<FormDir> subfolders, FormsManager manager) {
        for (FormDir subfolder : subfolders) {
            manager.listFormsInFolder(subfolder.getFolderID()).stream().filter(form -> StringFunctions.isEmpty((String)searchTerm) || form.getName().toLowerCase().contains(searchTerm.toLowerCase())).forEach(forms::add);
            this.addFormsFromSubfolders(forms, searchTerm, subfolder.getChildren(), manager);
        }
    }

    private boolean hasParentMatch(String searchTerm, FormDir folder, FormsManager manager) {
        if (searchTerm == null) {
            searchTerm = "";
        }
        if (folder.getName().toLowerCase().contains(searchTerm.toLowerCase())) {
            return true;
        }
        if (folder.getParentId() != null) {
            return this.hasParentMatch(searchTerm, manager.getFolder(folder.getParentId()), manager);
        }
        return false;
    }

    private boolean isMatchingFolder(@Nonnull String searchTerm, FormDir folder, FormsManager manager) {
        String lowerSearchTerm = searchTerm.toLowerCase();
        if (folder.getName().toLowerCase().contains(lowerSearchTerm)) {
            return true;
        }
        List<HDForm> forms = manager.listFormsInFolder(folder.getFolderID());
        if (forms.stream().anyMatch(p -> p.getName().toLowerCase().contains(lowerSearchTerm))) {
            return true;
        }
        for (FormDir ticketFormFolder : folder.getChildren()) {
            if (ticketFormFolder.getName().toLowerCase().contains(lowerSearchTerm)) {
                return true;
            }
            if (!this.isMatchingFolder(searchTerm, ticketFormFolder, manager)) continue;
            return true;
        }
        return false;
    }

    private void getFolderBreadCrumbs(GUID folderGuid, Stack<FormFolderDescription> folderBreadcrumbs, FormsManager formsManager) {
        FormDir folder = formsManager.getFolder(folderGuid);
        if (folder == null || StringFunctions.isEmpty((String)folder.getName())) {
            return;
        }
        FormFolderDescription d = new FormFolderDescription(folderGuid.toString(), folder.getName(), !folder.getChildren().isEmpty(), !formsManager.listFormsInFolder(folder.getFolderID()).isEmpty(), folder.getSharings());
        folderBreadcrumbs.insertElementAt(d, 0);
        GUID parentFolder = folder.getParentId();
        if (parentFolder != null) {
            this.getFolderBreadCrumbs(parentFolder, folderBreadcrumbs, formsManager);
        }
    }

    public String getMethodName() {
        return "ticketforms.getformslist";
    }
}

