/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.handler.config;

import com.inet.helpdesk.plugins.forms.client.data.config.EditOrDeleteFolderRequest;
import com.inet.helpdesk.plugins.forms.client.handler.AbstractTicketFormsHandler;
import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;

public class EditOrDeleteFormFolder
extends AbstractTicketFormsHandler<EditOrDeleteFolderRequest, Void> {
    @Override
    public Void handle(HttpServletRequest req, HttpServletResponse resp, EditOrDeleteFolderRequest payload) throws IOException {
        String folderId = payload.getFolderId();
        if (StringFunctions.isEmpty((String)folderId)) {
            return null;
        }
        GUID folderGuid = GUID.valueOf((String)folderId);
        FormsManager ticketFormManager = (FormsManager)ServerPluginManager.getInstance().getSingleInstance(FormsManager.class);
        FormDir folder = ticketFormManager.getFolder(folderGuid);
        if (folder == null) {
            throw new ClientMessageException(FormsServerPlugin.MSG.getMsg("error.folderDoesNotExist", new Object[0]));
        }
        String newFolderName = payload.getFolder().getName();
        String parentFolderId = payload.getParentFolderId();
        GUID newParent = StringFunctions.isEmpty((String)parentFolderId) ? ticketFormManager.getRootFolderID() : GUID.valueOf((String)parentFolderId);
        try {
            if (StringFunctions.isEmpty((String)newFolderName)) {
                ticketFormManager.deleteFolder(folderGuid);
            } else if (!Objects.equals(folder.getParentId(), newParent)) {
                ticketFormManager.moveFolder(folderGuid, newParent, newFolderName);
            } else {
                ticketFormManager.updateFolder(folderGuid, payload.getFolder().getName(), payload.getFolder().getSharings());
            }
        }
        catch (IllegalArgumentException exc) {
            throw new ClientMessageException(exc.getMessage(), (Throwable)exc);
        }
        return null;
    }

    public String getMethodName() {
        return "ticketforms.editordeletefolder";
    }
}

