/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.data.model;

import com.inet.annotations.JsonData;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.Type;
import java.util.List;
import javax.annotation.Nullable;

@JsonData
public class FormFolderDescription {
    private String id;
    private String name;
    private boolean hasSubFolders;
    private boolean hasForms;
    private UsersOrGroupsSelection sharings;

    private FormFolderDescription() {
    }

    public FormFolderDescription(String id, String name, boolean hasSubFolders, boolean hasForms, List<UsersOrGroupsSelection.SelectedMember> sharings) {
        this.id = id;
        this.name = name;
        this.hasSubFolders = hasSubFolders;
        this.hasForms = hasForms;
        this.sharings = new UsersOrGroupsSelection(sharings);
        if (sharings == null) {
            this.sharings.setPreselection("private");
        } else if (sharings.isEmpty()) {
            this.sharings.setPreselection("custom");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public List<UsersOrGroupsSelection.SelectedMember> getSharings() {
        List selectedMembers;
        if (this.sharings == null) {
            return List.of();
        }
        List list = selectedMembers = this.sharings.getSelectedMembers() == null ? List.of() : this.sharings.getSelectedMembers();
        if ("public".equals(this.sharings.getPreselection()) && selectedMembers.isEmpty()) {
            return List.of(new UsersOrGroupsSelection.SelectedMember(Type.group, UsersAndGroups.GROUPID_ALLUSERS));
        }
        if ("private".equals(this.sharings.getPreselection())) {
            return null;
        }
        return selectedMembers;
    }
}

