/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.taskplanner;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeTicketGUID;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormExecutionInfo;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.Job;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.job.ResultContainer;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;

public class GenerateFormURLJob
extends Job {
    private static final ConfigValue<String> EXTERNAL_URL = new ConfigValue(ConfigKey.SERVER_URL);
    public static final String PROPERTY_FORM_URL = "form.url";
    private final JobDefinition definition;
    private final int ticketID;
    private final GUID taskID;

    public GenerateFormURLJob(JobDefinition definition, GUID taskID) {
        super(definition.getCondition());
        this.definition = definition;
        this.ticketID = Integer.parseInt(definition.getProperty("Ticket ID"));
        this.taskID = taskID;
    }

    protected JobResultContainer run() throws TaskExecutionException {
        HashMap<String, CallSite> metaProperties = new HashMap<String, CallSite>();
        try {
            FormsManager formsManager;
            HDForm form;
            String formId = this.definition.getProperty("formId");
            if (formId != null && (form = (formsManager = (FormsManager)ServerPluginManager.getInstance().getSingleInstance(FormsManager.class)).getForm(GUID.valueOf((String)formId))) != null) {
                String baseURL = (String)EXTERNAL_URL.get();
                if (baseURL.endsWith("/")) {
                    baseURL = baseURL.substring(0, baseURL.length() - 1);
                }
                if (form.getSubmitType() == 2) {
                    TicketVO ticketVO = TicketManager.getReader().getTicket(this.ticketID);
                    GUID ticketGUID = null;
                    if (ticketVO != null) {
                        ticketGUID = (GUID)ticketVO.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_TICKET_GUID);
                    }
                    if (ticketGUID == null) {
                        ticketGUID = TicketAttributeTicketGUID.getFallbackValueForTicketID((int)this.ticketID);
                    }
                    FormExecutionInfo formExecutionInfo = new FormExecutionInfo(ticketGUID, form.getId());
                    String unifiedGUID = formExecutionInfo.toEncodedString();
                    String url = baseURL + "/forms/" + unifiedGUID;
                    metaProperties.put(PROPERTY_FORM_URL, (CallSite)((Object)url));
                } else {
                    String url = baseURL + "/forms/" + String.valueOf(form.getId());
                    metaProperties.put(PROPERTY_FORM_URL, (CallSite)((Object)url));
                }
            }
        }
        catch (IOException e) {
            throw new TaskExecutionException((Throwable)e);
        }
        return new ResultContainer(new ArrayList(), metaProperties);
    }

    protected boolean evaluateCondition(@Nonnull ConditionDefinition conditionDefinition) {
        return true;
    }
}

