/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.util;

import com.inet.helpdesk.plugins.forms.client.data.model.SingleFormEntryDescription;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class LoadFormEntriesUtil {
    @Nonnull
    public static List<SingleFormEntryDescription> getTicketCreationFormEntries() {
        ArrayList<SingleFormEntryDescription> entries = new ArrayList<SingleFormEntryDescription>();
        FormsManager manager = (FormsManager)ServerPluginManager.getInstance().getSingleInstance(FormsManager.class);
        GUID rootFolderID = manager.getRootFolderID();
        FormDir rootFolder = null;
        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
            rootFolder = manager.getFolder(rootFolderID);
        }
        Objects.requireNonNull(rootFolder);
        entries.addAll(LoadFormEntriesUtil.buildTicketCreationFormEntryTree(rootFolder, manager));
        return entries;
    }

    @Nonnull
    private static List<SingleFormEntryDescription> buildTicketCreationFormEntryTree(@Nonnull FormDir folder, @Nonnull FormsManager manager) {
        ArrayList<SingleFormEntryDescription> entries = new ArrayList<SingleFormEntryDescription>();
        manager.listAnyViewableFormSharedInFolder(folder.getFolderID()).stream().filter(form -> {
            try {
                form.validate();
            }
            catch (Throwable t) {
                return false;
            }
            if (!form.isActivated()) {
                return false;
            }
            return form.getSubmitType() == 1;
        }).forEach(form -> {
            SingleFormEntryDescription formEntry = new SingleFormEntryDescription(form.getId().toString(), form.getName(), false);
            entries.add(formEntry);
        });
        for (FormDir subfolder : folder.getChildren()) {
            SingleFormEntryDescription folderEntry = new SingleFormEntryDescription(subfolder.getFolderID().toString(), subfolder.getName(), true);
            folderEntry.getChildren().addAll(LoadFormEntriesUtil.buildTicketCreationFormEntryTree(subfolder, manager));
            entries.add(folderEntry);
        }
        return entries;
    }
}

