/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.internal;

import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.plugins.forms.server.api.model.FormDir;
import com.inet.helpdesk.plugins.forms.server.api.model.FormField;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.helpdesk.plugins.forms.server.internal.MutableFolder;
import com.inet.helpdesk.plugins.forms.server.internal.persistence.PersistedFolder;
import com.inet.helpdesk.plugins.forms.server.internal.persistence.PersistedForm;
import com.inet.helpdesk.plugins.forms.server.internal.persistence.PersistenceIconProvider;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.IOFunctions;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.Type;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class FormsPersistence {
    private MutableFolder rootFolder;
    private Map<GUID, PersistedForm> formulars;
    private Persistence persistence = Persistence.getRecoveryEnabledInstance();
    private PersistenceEntry persistence_forms = this.persistence.resolve("forms/forms");
    private PersistenceEntry persistence_folders = this.persistence.resolve("forms/folders");

    public FormsPersistence() {
        this.init();
    }

    void init() {
        ConcurrentHashMap<GUID, PersistedForm> formulars = new ConcurrentHashMap<GUID, PersistedForm>();
        this.persistence_forms.getChildren().forEach(formEntry -> {
            if (!formEntry.getName().endsWith(".json")) {
                return;
            }
            GUID id = null;
            try {
                id = GUID.valueOf((String)formEntry.getName().substring(0, formEntry.getName().length() - 5));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (id != null) {
                try (InputStream in = formEntry.getInputStream();){
                    PersistedForm form = (PersistedForm)new Json().fromJson(in, PersistedForm.class);
                    formulars.put(id, form);
                    form.getSections().forEach(s -> s.getFields().forEach(f -> this.restoreImageFromPersistence(form.getId(), (FormField)f)));
                }
                catch (JsonException ex) {
                    HDLogger.warn((Object)("Form " + String.valueOf(id) + " is corrupted and is discarded"));
                    HDLogger.warn((Object)((Object)ex));
                    try {
                        formEntry.deleteValue();
                    }
                    catch (Exception ex2) {
                        HDLogger.error((Object)ex2);
                    }
                }
                catch (IOException e) {
                    HDLogger.error((Object)("Form " + String.valueOf(id) + " cannot be read"));
                    HDLogger.error((Object)e);
                }
            }
        });
        this.rootFolder = null;
        HashMap folders = new HashMap();
        HashMap parentToChildMap = new HashMap();
        this.persistence_folders.getChildren().forEach(folderEntry -> {
            if (!folderEntry.getName().endsWith(".json")) {
                return;
            }
            GUID id = null;
            try {
                id = GUID.valueOf((String)folderEntry.getName().substring(0, folderEntry.getName().length() - 5));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (id != null) {
                try (InputStream in = folderEntry.getInputStream();){
                    PersistedFolder folder = (PersistedFolder)new Json().fromJson(in, PersistedFolder.class);
                    MutableFolder mutableFolder = new MutableFolder(id, folder.getName());
                    mutableFolder.setSharings(folder.getSharings());
                    if (folder.getParent() != null) {
                        GUID parentID = folder.getParent();
                        MutableFolder parentFolder = (MutableFolder)folders.get(parentID);
                        if (parentFolder != null) {
                            parentFolder.getChildren().add(mutableFolder);
                            mutableFolder.setParent(parentFolder);
                        } else {
                            List children = parentToChildMap.computeIfAbsent(parentID, k -> new ArrayList());
                            children.add(mutableFolder);
                        }
                    } else {
                        this.rootFolder = mutableFolder;
                    }
                    folders.put(id, mutableFolder);
                    List list = (List)parentToChildMap.get(id);
                    if (list != null) {
                        list.forEach(sub -> {
                            mutableFolder.getChildren().add((MutableFolder)sub);
                            sub.setParent(mutableFolder);
                        });
                    }
                }
                catch (JsonException ex) {
                    HDLogger.error((Object)("Folder " + String.valueOf(id) + " is corrupted and is discarded"));
                    HDLogger.error((Object)((Object)ex));
                    try {
                        folderEntry.deleteValue();
                    }
                    catch (Exception ex2) {
                        HDLogger.error((Object)ex2);
                    }
                }
                catch (IOException e) {
                    HDLogger.error((Object)("Folder " + String.valueOf(id) + " cannot be read"));
                    HDLogger.error((Object)e);
                }
            }
        });
        if (this.rootFolder == null) {
            this.rootFolder = new MutableFolder(GUID.generateNew(), "");
            this.rootFolder.setSharings(List.of(new UsersOrGroupsSelection.SelectedMember(Type.group, UsersAndGroups.GROUPID_ALLUSERS)));
            this.saveFolderInDB(this.rootFolder);
        }
        this.formulars = formulars;
    }

    public void addForm(HDForm form) {
        this.updateForm(form);
    }

    @Nullable
    public HDForm getForm(GUID formID) {
        PersistenceEntry entry;
        PersistedForm form = this.formulars.get(formID);
        if (form == null) {
            return null;
        }
        PersistenceIconProvider icon = null;
        if (form.getIconName() != null && (entry = this.persistence_forms.resolve(form.getIconName())).exists()) {
            icon = new PersistenceIconProvider(entry, () -> form.getIconName());
        }
        return new HDForm(form.getName(), formID, form.getParentFolderId(), form.getTitle(), form.getSections(), form.isActivated(), icon, form.getSubmitType(), form.isShowOnStartPage(), form.getStartPageLinkName(), form.getStartPageLinkDescription(), form.isUseFormLogo(), form.getMaxAttachmentSizeMb());
    }

    public void updateForm(HDForm formular) {
        PersistedForm newPersistedForm = new PersistedForm(formular);
        PersistenceEntry entry = this.persistence_forms.resolve(newPersistedForm.getId().toString() + ".json");
        try (OutputStream out = entry.getOutputStream();){
            new Json().toJson((Object)newPersistedForm, out);
        }
        catch (IOException e) {
            throw new PersistenceException((Throwable)e);
        }
        PersistedForm oldForm = this.formulars.get(formular.getId());
        this.formulars.put(formular.getId(), newPersistedForm);
        if (oldForm != null && oldForm.getIconName() != null && !oldForm.getIconName().equals(newPersistedForm.getIconName())) {
            PersistenceEntry resolve = this.persistence_forms.resolve(oldForm.getIconName());
            resolve.deleteValue();
        }
        if (formular.getIcon() != null && !(formular.getIcon() instanceof PersistenceIconProvider)) {
            PersistenceEntry iconEntry = this.persistence_forms.resolve(newPersistedForm.getIconName());
            try (OutputStream out = iconEntry.getOutputStream();
                 InputStream in = formular.getIcon().openStream();){
                IOFunctions.copyData((InputStream)in, (OutputStream)out);
            }
            catch (IOException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        HashSet knownImages = new HashSet();
        newPersistedForm.getSections().forEach(s -> s.getFields().forEach(f -> {
            String imageextension = f.getValues().get("imageextension");
            if (imageextension != null && f.getImage() != null) {
                String imagename = FormsPersistence.getImageFileName(formular.getId(), f, imageextension);
                knownImages.add(imagename);
                if (!(f.getImage() instanceof PersistenceIconProvider)) {
                    PersistenceEntry iconEntry = this.persistence_forms.resolve(imagename);
                    try (OutputStream out = iconEntry.getOutputStream();
                         InputStream in = f.getImage().openStream();){
                        IOFunctions.copyData((InputStream)in, (OutputStream)out);
                    }
                    catch (IOException e) {
                        throw new PersistenceException((Throwable)e);
                    }
                    this.restoreImageFromPersistence(newPersistedForm.getId(), (FormField)f);
                }
            }
        }));
        for (PersistenceEntry imageEntry : this.persistence_forms.search(formular.getId().toString() + "_image_*")) {
            if (knownImages.contains(imageEntry.getName())) continue;
            imageEntry.deleteValue();
        }
    }

    public static String getImageFileName(GUID formId, FormField f, String imageextension) {
        return formId.toString() + "_image_" + f.getKey() + "." + imageextension;
    }

    private void restoreImageFromPersistence(GUID formId, FormField field) {
        String ext = field.getValues().get("imageextension");
        if (ext != null) {
            PersistenceIconProvider icon = null;
            String imagename = FormsPersistence.getImageFileName(formId, field, ext);
            PersistenceEntry entry = this.persistence_forms.resolve(imagename);
            if (entry.exists()) {
                icon = new PersistenceIconProvider(entry, () -> imagename);
            }
            field.restoreIcon(icon);
        }
    }

    public void deleteForm(GUID formID) {
        this.deleteFormFromDB(formID);
        this.formulars.remove(formID);
    }

    private void deleteFormFromDB(GUID formID) {
        PersistedForm oldForm = this.formulars.get(formID);
        if (oldForm != null && oldForm.getIconName() != null) {
            PersistenceEntry resolve = this.persistence_forms.resolve(oldForm.getIconName());
            resolve.deleteValue();
        }
        for (PersistenceEntry imageEntry : this.persistence_forms.search(formID.toString() + "_image_*")) {
            imageEntry.deleteValue();
        }
        PersistenceEntry entry = this.persistence_forms.resolve(formID.toString() + ".json");
        entry.deleteValue();
    }

    public FormDir getRootFolder() {
        return this.rootFolder.toImmutable();
    }

    public FormDir getFolder(GUID folderID) {
        MutableFolder folder = this.rootFolder.find(folderID);
        if (folder != null) {
            return folder.toImmutable();
        }
        return null;
    }

    public GUID createFolder(FormDir dir) {
        MutableFolder parentFolder = this.rootFolder.find(dir.getParentId());
        if (parentFolder == null) {
            throw new IllegalArgumentException("Parent folder does not exist: " + String.valueOf(dir.getParentId()));
        }
        MutableFolder mutableFolder = new MutableFolder(GUID.generateNew(), dir.getName());
        mutableFolder.setParent(parentFolder);
        mutableFolder.setSharings(dir.getSharings());
        parentFolder.getChildren().add(mutableFolder);
        this.saveFolderInDB(mutableFolder);
        return mutableFolder.getId();
    }

    private void saveFolderInDB(MutableFolder mutableFolder) {
        PersistenceEntry resolve = this.persistence_folders.resolve(mutableFolder.getId().toString() + ".json");
        try (OutputStream out = resolve.getOutputStream();){
            new Json().toJson((Object)new PersistedFolder(mutableFolder), out);
        }
        catch (IOException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void updateFolder(GUID folderId, GUID newParent, String newName, List<UsersOrGroupsSelection.SelectedMember> sharings) {
        MutableFolder folder = this.rootFolder.find(folderId);
        if (folder == null) {
            throw new IllegalArgumentException("Folder does not exist: " + String.valueOf(folderId));
        }
        if (folder != this.rootFolder) {
            if (!Objects.equals(folder.getParent().getId(), newParent)) {
                MutableFolder newParentfolder = this.rootFolder.find(newParent);
                if (newParentfolder == null) {
                    throw new IllegalArgumentException("New parent not exist: " + String.valueOf(newParent));
                }
                folder.getParent().getChildren().remove(folder);
                newParentfolder.getChildren().add(folder);
                folder.setParent(newParentfolder);
            }
            folder.setName(newName);
        }
        folder.setSharings(sharings);
        this.saveFolderInDB(folder);
    }

    public void deleteFolder(GUID folderID) {
        MutableFolder folder = this.rootFolder.find(folderID);
        if (folder == null) {
            throw new IllegalArgumentException("Folder does not exist: " + String.valueOf(folderID));
        }
        if (folder.getParent() == null) {
            throw new IllegalArgumentException("Cannot delete the root: " + String.valueOf(folderID));
        }
        folder.getParent().getChildren().remove(folder);
        this.deleteFolderRecursive(folder);
    }

    private void deleteFolderRecursive(MutableFolder folder) {
        for (MutableFolder child : folder.getChildren()) {
            this.deleteFolderRecursive(child);
        }
        PersistenceEntry entry = this.persistence_folders.resolve(folder.getId().toString() + ".json");
        entry.deleteValue();
    }

    public List<HDForm> getFormsInFolder(GUID folderID) {
        return this.formulars.values().stream().filter(f -> f.getParentFolderId().equals((Object)folderID)).map(pf -> this.getForm(pf.getId())).toList();
    }

    public List<HDForm> getAllForms() {
        return this.formulars.values().stream().map(pf -> this.getForm(pf.getId())).toList();
    }
}

