/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server.internal;

import com.inet.helpdesk.plugins.forms.server.FormsServerPlugin;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.lib.json.Json;
import com.inet.logging.EventLog;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.HashMap;
import java.util.Locale;

public enum FormTicketEventLog {
    FormExecuted;

    private static final EventLog<FormTicketEventLog> EVENT_LOG;

    public void log(HDForm form, int ticketId) {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        String msg = FormsServerPlugin.MSG.getMsg(Locale.getDefault(), "eventlog." + this.name(), new Object[]{form.getName()});
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("Name", form.getName());
        data.put("ID", form.getId().toString());
        data.put("Ticket-ID", String.valueOf(ticketId));
        EVENT_LOG.log((Enum)this, userAccount, msg, new Json().toJson(data), new Object[]{ticketId});
    }

    static {
        EVENT_LOG = EventLog.register((String)"helpdeskticket");
    }
}

