/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.server;

import com.inet.classloader.I18nMessages;
import com.inet.config.structure.model.ConfigPage;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.helpdesk.config.autotext.data.AutoTextPlaceholderProvider;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManagerVetoPower;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.plugins.forms.ReaStepFieldFormId;
import com.inet.helpdesk.plugins.forms.client.FormsConfigPage;
import com.inet.helpdesk.plugins.forms.client.handler.config.ActivateForm;
import com.inet.helpdesk.plugins.forms.client.handler.config.CopyFormFolder;
import com.inet.helpdesk.plugins.forms.client.handler.config.CreateFolder;
import com.inet.helpdesk.plugins.forms.client.handler.config.DeactivateForm;
import com.inet.helpdesk.plugins.forms.client.handler.config.DeleteForm;
import com.inet.helpdesk.plugins.forms.client.handler.config.EditOrDeleteFormFolder;
import com.inet.helpdesk.plugins.forms.client.handler.config.ExportForm;
import com.inet.helpdesk.plugins.forms.client.handler.config.GetTicketFormsFolderList;
import com.inet.helpdesk.plugins.forms.client.handler.config.GetTicketFormsList;
import com.inet.helpdesk.plugins.forms.client.handler.config.ImportForm;
import com.inet.helpdesk.plugins.forms.client.handler.config.LoadFormDetails;
import com.inet.helpdesk.plugins.forms.client.handler.config.MoveForm;
import com.inet.helpdesk.plugins.forms.client.handler.config.SaveForm;
import com.inet.helpdesk.plugins.forms.client.handler.execution.ExecuteFormHandler;
import com.inet.helpdesk.plugins.forms.client.handler.execution.GetFormIcon;
import com.inet.helpdesk.plugins.forms.client.handler.execution.GetTicketGUID;
import com.inet.helpdesk.plugins.forms.client.handler.execution.LoadFormData;
import com.inet.helpdesk.plugins.forms.client.handler.ticketlist.LoadAvailableModifyFormEntries;
import com.inet.helpdesk.plugins.forms.client.handler.ticketlist.LoadAvailableTicketCreationFormEntries;
import com.inet.helpdesk.plugins.forms.client.servlet.FormExecutionServlet;
import com.inet.helpdesk.plugins.forms.client.ticketlist.AdditionalReaStepFieldDefinitionFormId;
import com.inet.helpdesk.plugins.forms.server.FormsAutoTextPlaceholderProvider;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.internal.ApplyFormActionExtension;
import com.inet.helpdesk.plugins.forms.server.internal.FormsManagerImpl;
import com.inet.helpdesk.plugins.forms.server.internal.FormsPersistence;
import com.inet.helpdesk.plugins.forms.server.maintenance.FormsBackupTask;
import com.inet.helpdesk.plugins.forms.server.reporting.DataView_Tickets_rating;
import com.inet.helpdesk.plugins.forms.server.setup.MigrateFormsTicketFieldsToNotBeIncludedInInquiryTextStep;
import com.inet.helpdesk.plugins.forms.server.setup.SampleFormsStep;
import com.inet.helpdesk.plugins.forms.taskplanner.GenerateFormURLJobFactory;
import com.inet.helpdesk.plugins.ticketlist.api.ExtendibleTicketListAngularApplicationServlet;
import com.inet.http.PluginServlet;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.permissions.Permission;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.plugin.veto.VetoManager;
import com.inet.plugin.veto.VetoType;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.report.adhoc.server.api.dataview.TemplateDataViewDefaults;
import com.inet.setupwizard.api.SetupStep;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.theme.server.ThemeResource;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.net.URL;
import java.sql.SQLException;
import javax.annotation.Nullable;

@PluginInfo(id="helpdesk.forms", version="25.10.198", group="tickets", dependencies="helpdesk; setupwizard; helpdesksetupwizard; remotegui; fieldsettings; ticketlist; htmlengine", optionalDependencies="theme; attachments; maintenance; taskplanner; taskplanner.helpdesk; reporting; adhoc", packages="com.inet.helpdesk.plugins.forms.server.api", external="", internal="", initAfter="", icon="com/inet/helpdesk/plugins/forms/server/forms_plugin_48.png", flags="")
public class FormsServerPlugin
implements ServerPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"Forms");
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.plugins.forms.server.i18n.Translations", FormsServerPlugin.class);
    public static final I18nMessages MSG_CLIENT = new I18nMessages("com.inet.helpdesk.plugins.forms.client.i18n.LanguageResource", FormsServerPlugin.class);
    private FormsPersistence formsPersistence = new FormsPersistence();
    private FormsManagerImpl formsManager = new FormsManagerImpl(this.formsPersistence);

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl("configuration", 9461, false, new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("taskplanner", 9462, false, new Permission[]{Permission.valueOfExistingOrCreate((String)"taskplanner")}){}, new String[]{"taskplanner"});
        container.add((HelpProvider)new HelpProviderImpl("ticketlist", 9463, new Permission[0]){}, new String[0]);
    }

    public void registerExtension(final ServerPluginManager spm) {
        spm.register(FormsManager.class, (Object)this.formsManager);
        spm.register(SetupStep.class, (Object)new SampleFormsStep());
        spm.register(SetupStep.class, (Object)new MigrateFormsTicketFieldsToNotBeIncludedInInquiryTextStep());
        spm.register(ConfigPage.class, (Object)new FormsConfigPage());
        FileCombiner.CombinedFile configurationPageHtml = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
        configurationPageHtml.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/html/configuration.forms.html");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 212, "configuration.forms.html", configurationPageHtml));
        FileCombiner.CombinedFile configurationEditPageHtml = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
        configurationEditPageHtml.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/html/configuration.ticketform.edit.html");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 212, "configuration.ticketform.edit.html", configurationEditPageHtml));
        FileCombiner.CombinedFile configurationSectionHtml = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
        configurationSectionHtml.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/html/configuration.ticketform.section.html");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 212, "configuration.ticketform.section.html", configurationSectionHtml));
        FileCombiner.CombinedFile configurationSectionPropsHtml = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
        configurationSectionPropsHtml.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/html/configuration.ticketform.sectionProperties.html");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 212, "configuration.ticketform.sectionProperties.html", configurationSectionPropsHtml));
        FileCombiner.CombinedFile configurationFieldHtml = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
        configurationFieldHtml.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/html/configuration.ticketform.field.html");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 212, "configuration.ticketform.field.html", configurationFieldHtml));
        FileCombiner.CombinedFile configurationFieldEditHtml = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
        configurationFieldEditHtml.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/html/configuration.ticketform.field.edit.html");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 212, "configuration.ticketform.field.edit.html", configurationFieldEditHtml));
        FileCombiner.CombinedFile formRenderer = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
        formRenderer.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/html/ticketform.formrenderer.html");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 212, "ticketform.formrenderer.html", formRenderer));
        FileCombiner.CombinedFile metadata = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
        metadata.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/html/configuration.ticketform.metadata.html");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 212, "configuration.ticketform.metadata.html", metadata));
        FileCombiner.CombinedFile configurationPageJS = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/configuration.ticketforms.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/configuration.ticketforms.edit.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/ticketformsmodel.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/ticketformsfactory.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/formHandlingService.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/ticketPreviewSettings.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/directives/sectionid.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/directives/formicondropzone.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/directives/editFormField.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/directives/formmetadata.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/directives/formsections.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/directives/formfields.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/directives/formrenderer.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/directives/folderPermissionsDisplay.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/directives/fieldrenderer.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/directives/fieldrenderer_defaultValue.js");
        configurationPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/directives/fieldrenderer_conditionValue.js");
        configurationPageJS.addMessages(MSG_CLIENT);
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configAppExtras.js", configurationPageJS));
        FileCombiner.CombinedFile executionPageJS = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
        executionPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/formExecution.js");
        executionPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/FormInterceptor.service.js");
        executionPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/formHandlingService.js");
        executionPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/directives/formrenderer.js");
        executionPageJS.add(this.getClass(), "/com/inet/helpdesk/plugins/forms/client/js/directives/fieldrenderer.js");
        executionPageJS.addMessages(MSG_CLIENT);
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 212, "ticketform.execution.js", executionPageJS));
        spm.register(ServiceMethod.class, (Object)new MoveForm());
        spm.register(ServiceMethod.class, (Object)new ActivateForm());
        spm.register(ServiceMethod.class, (Object)new DeactivateForm());
        spm.register(ServiceMethod.class, (Object)new DeleteForm());
        spm.register(ServiceMethod.class, (Object)new CreateFolder());
        spm.register(ServiceMethod.class, (Object)new EditOrDeleteFormFolder());
        spm.register(ServiceMethod.class, (Object)new GetTicketFormsFolderList());
        spm.register(ServiceMethod.class, (Object)new GetTicketFormsList());
        spm.register(ServiceMethod.class, (Object)new LoadAvailableTicketCreationFormEntries());
        spm.register(ServiceMethod.class, (Object)new LoadAvailableModifyFormEntries());
        spm.register(ServiceMethod.class, (Object)new CopyFormFolder());
        spm.register(ServiceMethod.class, (Object)new LoadFormDetails());
        spm.register(ServiceMethod.class, (Object)new SaveForm());
        spm.register(ServiceMethod.class, (Object)new ExportForm());
        spm.register(ServiceMethod.class, (Object)new ImportForm());
        spm.register(ServiceMethod.class, (Object)new GetFormIcon());
        spm.register(ServiceMethod.class, (Object)new GetTicketGUID());
        spm.register(PluginServlet.class, (Object)new FormExecutionServlet());
        spm.register(ServerPluginManagerListener.class, (Object)new ServerPluginManagerListener(){

            public void vetoFinished(@Nullable VetoType type) {
                if (type == TicketManagerVetoPower.TYPE) {
                    ActionManager actionManager = ActionManager.getInstance();
                    ActionVO ratingAction = (ActionVO)actionManager.get(-40);
                    if (ratingAction == null) {
                        try {
                            actionManager.add(new ActionVO(-40, "Ticket bewerten", -100, true, 0, 0, 0.0, false, 12, true), false);
                        }
                        catch (SQLException e) {
                            LOGGER.error((Throwable)e);
                        }
                    } else {
                        ratingAction = new ActionVO(-40, ratingAction.getDisplayValue(), ratingAction.getStatusID(), true, 0, 0, 0.0, false, 12, true);
                        try {
                            actionManager.update(ratingAction);
                        }
                        catch (SQLException e) {
                            HDLogger.error((Object)e);
                        }
                    }
                    ActionVO formDataAction = (ActionVO)actionManager.get(-41);
                    if (formDataAction == null) {
                        try {
                            actionManager.add(new ActionVO(-41, "Formular ausf\u00fchren", -100, true, 0, 0, 0.0, false, 12, true), false);
                        }
                        catch (SQLException e) {
                            HDLogger.error((Object)e);
                        }
                    }
                }
            }
        });
        spm.register(ExtensionArguments.ExtArg.class, FormsManagerImpl.EXTARG_FORM_DATA);
        spm.register(TicketActionExtensionFactory.class, (Object)new ApplyFormActionExtension());
        spm.runIfPluginLoaded("remotegui", () -> new Executable(){

            public void execute() {
                FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("text/css", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/forms/client/css/ticketforms.css");
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 219, "defaulttheme.css", combinedFile));
            }
        });
        spm.runIfPluginLoaded("theme", () -> new Executable(){

            public void execute() {
                spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/forms/client/css/ticketforms.less")));
                spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/forms/client/css/ticketforms-sprites.less")));
            }
        });
        spm.runIfPluginLoaded("maintenance", () -> new Executable(){

            public void execute() {
                spm.register(BackupTask.class, (Object)new FormsBackupTask());
            }
        });
        spm.runIfPluginLoaded("taskplanner.helpdesk", () -> new Executable(){

            public void execute() {
                spm.register(JobFactory.class, (Object)new GenerateFormURLJobFactory());
            }
        });
        spm.runIfPluginLoaded("ticketlist", () -> new Executable(){

            public void execute() {
                spm.register(ReaStepField.class, (Object)ReaStepFieldFormId.INSTANCE);
                spm.register(AdditionalReaStepFieldDefinition.class, (Object)new AdditionalReaStepFieldDefinitionFormId());
                FileCombiner.CombinedFile integrationJavaScript = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/forms/client/js/ticketformsmodel.js");
                integrationJavaScript.addMessages(MSG_CLIENT);
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 224, "helpdesk.ticket.extensions.js", integrationJavaScript));
                FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/forms/client/ticketlist/ticketlist.form.extension.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/forms/client/ticketlist/ticketlist.form.controller.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/forms/client/js/formHandlingService.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/forms/client/js/directives/fieldrenderer.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/forms/client/js/ticketformsmodel.js");
                combinedFile.addMessages(MSG_CLIENT);
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 221, "helpdesk.ticket.extensions.js", combinedFile));
                FileCombiner.CombinedFile html = new FileCombiner.CombinedFile("text/html", new URL[0]);
                html.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/forms/client/ticketlist/ticketlist.form.apply.html");
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "ticketlist.form.apply.html", html));
                DynamicExtensionManager.getInstance().register(AutoTextPlaceholderProvider.class, (Object)new FormsAutoTextPlaceholderProvider());
            }
        });
        spm.runIfPluginLoaded("adhoc", () -> new Executable(){

            public void execute() {
                spm.register(TemplateDataViewDefaults.class, (Object)new DataView_Tickets_rating());
            }
        });
    }

    public void init(final ServerPluginManager spm) {
        new Thread(new Runnable(){
            private static final Object M = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (VetoManager.getInstance().isCurrentlyVetoed()) {
                    try {
                        Object object = M;
                        synchronized (object) {
                            M.wait(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                try (UserAccountScope priv = UserAccountScope.createPrivileged();){
                    FormsServerPlugin.this.formsManager.updateStartPageModules();
                }
            }
        }, "Forms Start Page Module Provider Initializer").start();
        spm.runIfPluginLoaded("ticketlist", () -> new Executable(){

            public void execute() {
                ExtendibleTicketListAngularApplicationServlet ticketListAngularApplicationServlet = (ExtendibleTicketListAngularApplicationServlet)spm.getSingleInstance(ExtendibleTicketListAngularApplicationServlet.class);
                ticketListAngularApplicationServlet.addServiceMethod((ServiceMethod)new LoadFormData());
                ticketListAngularApplicationServlet.addServiceMethod((ServiceMethod)new ExecuteFormHandler());
            }
        });
    }

    public void reset() {
    }

    public void restart() {
    }
}

