/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.handler.execution;

import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormField;
import com.inet.helpdesk.plugins.forms.server.api.model.FormSection;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.helpdesk.plugins.forms.server.api.model.IconProvider;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.remote.gui.angular.AngularContentService;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class GetFormIcon
extends ServiceMethod<Void, Void> {
    public Void invoke(HttpServletRequest req, HttpServletResponse resp, Void payload) throws IOException {
        GUID formId;
        String formIdStr = req.getParameter("formid");
        if (StringFunctions.isEmpty((String)formIdStr)) {
            URL resource = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/forms/client/css/sprites/forms_16.png");
            try (InputStream in = resource.openStream();){
                AngularContentService.serveStaticContent((HttpServletRequest)req, (HttpServletResponse)resp, (InputStream)in, (long)0L, (String)"image/png", (boolean)true);
                Void void_ = null;
                return void_;
            }
        }
        try {
            formId = GUID.valueOf((String)formIdStr);
        }
        catch (IllegalArgumentException ex) {
            resp.setStatus(404);
            return null;
        }
        FormsManager m = FormsManager.getInstance();
        HDForm form = m.getForm(formId);
        if (form == null) {
            resp.setStatus(404);
            return null;
        }
        String fieldKey = req.getParameter("fieldKey");
        if (fieldKey == null) {
            IconProvider icon = form.getIcon();
            if (icon == null) {
                resp.setStatus(204);
                return null;
            }
            String mimeType = icon.getMimeType();
            try (InputStream in = icon.openStream();){
                AngularContentService.serveStaticContent((HttpServletRequest)req, (HttpServletResponse)resp, (InputStream)in, (long)0L, (String)mimeType, (boolean)true);
            }
        }
        for (FormSection s : form.getSections()) {
            for (FormField f : s.getFields()) {
                if (!f.getKey().equals(fieldKey)) continue;
                IconProvider icon = f.getImage();
                if (icon == null) {
                    resp.setStatus(204);
                    return null;
                }
                String mimeType = icon.getMimeType();
                try (InputStream in = icon.openStream();){
                    AngularContentService.serveStaticContent((HttpServletRequest)req, (HttpServletResponse)resp, (InputStream)in, (long)0L, (String)mimeType, (boolean)true);
                }
                return null;
            }
        }
        return null;
    }

    public String getMethodName() {
        return "ticketforms.getformicon";
    }

    public short getMethodType() {
        return 2;
    }
}

