/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.data.model;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.forms.client.data.model.AndBlockDescription;
import com.inet.helpdesk.plugins.forms.client.data.model.ConditionDescription;
import com.inet.helpdesk.plugins.forms.client.data.model.FieldDescription;
import com.inet.helpdesk.plugins.forms.server.api.model.FormField;
import com.inet.helpdesk.plugins.forms.server.api.model.FormSection;
import com.inet.helpdesk.plugins.forms.server.api.model.FormSubmitAction;
import com.inet.helpdesk.plugins.forms.server.api.model.condition.AndBlock;
import com.inet.helpdesk.plugins.forms.server.api.model.condition.FormCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class SectionDescription {
    @Nullable
    private String title;
    @Nullable
    private String label;
    @Nonnull
    private List<FieldDescription> fields = new ArrayList<FieldDescription>();
    private int submitAction = 0;
    @Nullable
    private String afterSubmitText;
    @Nullable
    private Integer actionId;
    private boolean condition_alwaysVisible;
    @Nonnull
    private List<AndBlockDescription> conditions;

    private SectionDescription() {
    }

    public SectionDescription(FormSection s, boolean forExecution) {
        this.title = s.getTitle();
        this.label = s.getLabel();
        this.fields = s.getFields().stream().map(f -> new FieldDescription((FormField)f, forExecution)).collect(Collectors.toList());
        this.conditions = s.getConditions().stream().map(c -> new AndBlockDescription(c.getConditions().stream().map(b -> new ConditionDescription((FormCondition)b)).toList())).toList();
        this.condition_alwaysVisible = this.conditions.isEmpty();
        if (s.getActions().size() > 0) {
            this.submitAction = s.getActions().get(0).getType();
            this.afterSubmitText = s.getActions().get(0).getAfterExecutionText();
            this.actionId = s.getActions().get(0).getActionId();
        }
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    public List<AndBlockDescription> getConditions() {
        return this.conditions;
    }

    public List<FieldDescription> getFields() {
        return this.fields;
    }

    public FormSection toFormSection() {
        List<FormField> formFields = this.fields.stream().map(f -> f.toFormField()).collect(Collectors.toList());
        List<FormSubmitAction> actions = this.submitAction == 0 ? List.of() : List.of(new FormSubmitAction(this.submitAction, this.afterSubmitText, this.actionId));
        List<AndBlock> conditions = this.condition_alwaysVisible ? List.of() : this.conditions.stream().map(b -> b.toAndBlock()).collect(Collectors.toList());
        return new FormSection(this.title, this.label, formFields, actions, conditions);
    }
}

