/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.forms.client.data.model;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.forms.client.data.config.AvailableFieldDescription;
import com.inet.helpdesk.plugins.forms.server.api.model.FormField;
import com.inet.helpdesk.plugins.forms.server.api.model.IconProvider;
import java.util.List;
import java.util.Map;

@JsonData
public class FieldDescription {
    private String key;
    private String label;
    private FormField.FormFieldType fieldType;
    private String fieldDataType;
    private List<String> select_options;
    private String select_filter;
    private boolean mandatory;
    private FormField.FormFieldVisibility visibility;
    private FormField.FormLabelSetting labelVisibility = FormField.FormLabelSetting.HIDE;
    private boolean includeInInquiry;
    private boolean includeLabelInInquiry;
    private String defaultValue;
    private boolean customDefaultValue;
    private String placeholder;
    private Map<String, String> properties;
    private Map<String, String> values;
    private String imageDataUri;

    public FieldDescription() {
    }

    public FieldDescription(FormField field, boolean forExecution) {
        this.key = field.getKey();
        this.defaultValue = field.getDefaultValue();
        this.fieldType = field.getFormFieldType();
        this.fieldDataType = field.getFieldDataType();
        if (this.fieldType == FormField.FormFieldType.Ticket && !field.getKey().equals("special_ticket_text")) {
            TicketFieldDefinition fieldDefinition = Tickets.getFieldDefinitionByKey((String)this.key);
            if (fieldDefinition == null) {
                this.fieldType = FormField.FormFieldType.Standard;
            } else {
                FieldEditDefinition editDefinition = fieldDefinition.getEditDefinition();
                if (editDefinition == null) {
                    this.fieldType = FormField.FormFieldType.Standard;
                }
            }
        }
        if (this.fieldType == FormField.FormFieldType.Standard) {
            this.customDefaultValue = true;
        } else if (this.fieldType == FormField.FormFieldType.Ticket) {
            TicketField ticketField;
            this.customDefaultValue = field.isCustomDefaultValue();
            if (!this.customDefaultValue && (ticketField = Tickets.getFieldByKey((String)this.key)) != null) {
                this.defaultValue = AvailableFieldDescription.getDefaultValueAsStringFor(ticketField);
            }
        }
        this.mandatory = field.isMandatory();
        this.visibility = field.getVisibility();
        this.labelVisibility = field.getLabelSetting();
        this.includeInInquiry = field.isApplyToTicketText();
        this.includeLabelInInquiry = field.isIncludeLabelInInquiry();
        this.placeholder = field.getPlaceholder();
        this.select_filter = field.getSelect_filter();
        this.select_options = field.getSelect_options();
        this.label = field.getLabel();
        this.properties = AvailableFieldDescription.initialProperties(this.fieldDataType);
        this.values = field.getValues();
        if (field.getImage() != null && !forExecution) {
            this.imageDataUri = field.getImage().getAsDataUri();
        }
    }

    public String getKey() {
        return this.key;
    }

    public FormField.FormFieldType getFieldType() {
        return this.fieldType;
    }

    public String getFieldDataType() {
        return this.fieldDataType;
    }

    public List<String> getSelect_options() {
        return this.select_options;
    }

    public String getSelect_filter() {
        return this.select_filter;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public FormField.FormFieldVisibility getVisibility() {
        return this.visibility;
    }

    public FormField.FormLabelSetting isLabelVisibility() {
        return this.labelVisibility;
    }

    public boolean isIncludeInInquiry() {
        return this.includeInInquiry;
    }

    public boolean isIncludeLabelInInquiry() {
        return this.includeLabelInInquiry;
    }

    public boolean isCustomizeDefaultValue() {
        return this.customDefaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public String getLabel() {
        return this.label;
    }

    public FormField toFormField() {
        IconProvider image = null;
        if (this.imageDataUri != null) {
            image = IconProvider.fromBase64DataUri(this.imageDataUri);
        }
        return new FormField(this.key, this.fieldType, this.fieldDataType, this.select_options, this.select_filter, this.includeInInquiry, this.includeLabelInInquiry, this.mandatory, this.visibility, this.labelVisibility, this.customDefaultValue, this.defaultValue, this.placeholder, this.label, this.values, image);
    }
}

