/*
 * Decompiled with CFR 0.152.
 */
package com.inet.help.server.sbom;

import com.inet.classloader.BaseLocator;
import com.inet.help.HelpServerPlugin;
import com.inet.help.server.sbom.c;
import com.inet.help.server.sbom.model.SBOM;
import com.inet.help.server.sbom.model.SBOMComponent;
import com.inet.help.server.sbom.model.SBOMDependency;
import com.inet.http.ClientMessageException;
import com.inet.http.PluginServlet;
import com.inet.lib.json.Json;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.fs.ResourceFile;
import com.inet.shared.servlet.ServletUtils;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class b
implements PluginServlet {
    @Nonnull
    public String getPathSpec() {
        return "/.well-known/sbom";
    }

    public void init(ServletConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!SystemPermissionChecker.isAdministrator()) {
            throw new AccessDeniedException(Permission.CONFIGURATION);
        }
        if (!"application/json; charset=utf-8".equals(request.getHeader("accept"))) {
            throw new IllegalArgumentException("The request must accept the content type: 'application/json; charset=utf-8'");
        }
        if (!b.a(response)) {
            throw new ClientMessageException("There was an error while genering the sbom. Please check the server logs.");
        }
        c.aM.a(new Object[0]);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The file location is fixed by the system. User input is verified against a well known location.")
    protected static boolean a(HttpServletResponse httpServletResponse) {
        ServerPluginManager serverPluginManager;
        Json json = new Json();
        SBOM sBOM = null;
        File file = new File(BaseLocator.getBaseDirectory().getAbsolutePath(), "licenses/sbom.json");
        HelpServerPlugin.LOGGER.debug((Object)("Checking for core SBOM at: " + file.getAbsolutePath()));
        if (file.exists()) {
            try {
                serverPluginManager = new HashMap();
                sBOM = (SBOM)json.fromJson((InputStream)new FileInputStream(file), SBOM.class, serverPluginManager, null);
            }
            catch (Exception exception) {
                HelpServerPlugin.LOGGER.error((Object)"Could not load core sbom.json file.");
                HelpServerPlugin.LOGGER.debug((Object)exception);
                return false;
            }
        } else {
            HelpServerPlugin.LOGGER.error((Object)"Did not find core SBOM file. Non-standard installation is not supported.");
            return false;
        }
        b.a(sBOM);
        serverPluginManager = ServerPluginManager.getInstance();
        String[] stringArray = serverPluginManager.getAvailablePlugins();
        for (int i = 0; i < stringArray.length; ++i) {
            SBOM sBOM2;
            block12: {
                String string = stringArray[i];
                try {
                    ResourceFile resourceFile = serverPluginManager.getPluginFile(string, "sbom.json");
                    if (resourceFile == null) {
                        throw new IllegalStateException("SBOM file not found for plugin:" + string);
                    }
                    try {
                        HashMap hashMap = new HashMap();
                        sBOM2 = (SBOM)json.fromJson(resourceFile.getInputStream(), SBOM.class, hashMap, null);
                        break block12;
                    }
                    catch (Exception exception) {
                        HelpServerPlugin.LOGGER.error((Object)("Could not load plugin SBOM json file for:" + string));
                    }
                }
                catch (Exception exception) {
                    HelpServerPlugin.LOGGER.debug((Object)("Could not load the sbom.json file for plugin: " + string));
                }
                continue;
            }
            b.a(sBOM, sBOM2);
        }
        ServletUtils.setContentDisposition((HttpServletResponse)httpServletResponse, (String)"sbom.json", (boolean)false);
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("application/json; charset=utf-8");
        try {
            json.toJson((Object)sBOM, (OutputStream)httpServletResponse.getOutputStream());
        }
        catch (IOException iOException) {
            HelpServerPlugin.LOGGER.error((Throwable)iOException);
            return false;
        }
        return true;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The file location is fixed by the system and can not be modified by the user to expose private information.")
    private static void a(SBOM sBOM) {
        ResourceFile resourceFile = ServerPluginManager.getInstance().getPluginDir().createChild("persistence");
        if (!resourceFile.exists()) {
            return;
        }
        for (ResourceFile resourceFile2 : resourceFile.listFiles()) {
            if (!resourceFile2.isDirectory() || !resourceFile2.getName().endsWith("licenses")) continue;
            File file = new File(resourceFile2.getAbsolutePath(), "sbom.json");
            HelpServerPlugin.LOGGER.debug((Object)("Checking for persistence SBOM at: " + file.getAbsolutePath()));
            if (!file.exists()) continue;
            try {
                HashMap hashMap = new HashMap();
                SBOM sBOM2 = (SBOM)new Json().fromJson((InputStream)new FileInputStream(file), SBOM.class, hashMap, null);
                b.a(sBOM, sBOM2);
            }
            catch (Exception exception) {
                HelpServerPlugin.LOGGER.error((Object)"Could not load persistence sbom.json file.");
            }
        }
    }

    private static void a(SBOM sBOM, SBOM sBOM2) {
        SBOMComponent sBOMComponent = sBOM2.getMetadata().getComponent();
        for (SBOMComponent object2 : sBOM2.getComponents()) {
            if (sBOMComponent == null) continue;
            sBOMComponent.addComponent(object2);
        }
        List<SBOMDependency> list = sBOM2.getDependencies();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SBOMDependency sBOMDependency = (SBOMDependency)iterator.next();
            sBOM.addDependency(sBOMDependency);
        }
        sBOM.addComponent(sBOMComponent);
    }
}

