/*
 * Decompiled with CFR 0.152.
 */
package com.inet.help.api.utils;

import com.inet.annotations.InternalApi;
import com.inet.help.api.model.HelpPageDescription;
import com.inet.help.model.InternalHelpPage;
import com.inet.lib.util.EncodingFunctions;
import com.inet.plugin.help.HelpPage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class HelpPageFunctions {
    public static final String REMOTEGUI_APP_HELP_PRINTING_FILE = "helpprinting.css";
    public static final String HELP_PRINTING_KEY = "helpprinting";

    @SuppressFBWarnings(value={"FORMAT_STRING_MANIPULATION"}, justification="Debug output to inform about misconfiguration of the help pages")
    public static List<InternalHelpPage> mergeTOCs(List<InternalHelpPage> specificPages, List<InternalHelpPage> rootPages) {
        for (InternalHelpPage internalHelpPage : specificPages) {
            String string = internalHelpPage.getKey();
            InternalHelpPage internalHelpPage2 = HelpPageFunctions.findPageByKey(string, rootPages);
            if (internalHelpPage2 == null) {
                StringBuilder stringBuilder = new StringBuilder();
                for (InternalHelpPage internalHelpPage3 : rootPages) {
                    stringBuilder.append(internalHelpPage3.getKey() + " (" + internalHelpPage3.getTitle() + "),");
                }
                throw new IllegalStateException(String.format("There is a page '%s' (URL=%s) which is available for a specific locale, but it is not available for the root-locale. This violates the contract that the root-locale must have all page-keys and the specific locales may not add additional keys. This is necessary to make sure the ToC always has all items for any supported or non-supported locale. Available Rootpages " + String.valueOf(stringBuilder), string, internalHelpPage.getUrl()));
            }
            if (internalHelpPage.getTitle() != null) {
                internalHelpPage2.setTitle(internalHelpPage.getTitle());
            }
            if (internalHelpPage.getUrl() != null) {
                internalHelpPage2.setUrl(internalHelpPage.getUrl());
            }
            HelpPageFunctions.mergeTOCs(internalHelpPage.getChildPages(), rootPages);
        }
        return rootPages;
    }

    public static InternalHelpPage findPageByKey(String key, List<InternalHelpPage> pages) {
        for (InternalHelpPage internalHelpPage : pages) {
            if (internalHelpPage.getKey().equals(key) || internalHelpPage.getAlternativeKeys().contains(key)) {
                return internalHelpPage;
            }
            InternalHelpPage internalHelpPage2 = HelpPageFunctions.findPageByKey(key, internalHelpPage.getChildPages());
            if (internalHelpPage2 == null) continue;
            return internalHelpPage2;
        }
        return null;
    }

    public static String sanitizedHelpPageURL(String helpTitle, String helpKey) {
        Object object = helpKey;
        object = (String)object + HelpPageFunctions.sanitizeHelpPageTitle(helpTitle, helpKey);
        object = EncodingFunctions.encodeUrlPath((String)object);
        return ((String)object).replace(":", "%3A");
    }

    public static String sanitizeHelpPageTitle(String helpTitle, String helpKey) {
        if (helpTitle == null) {
            return "";
        }
        String string = helpTitle;
        if (string == null || string.length() == 0) {
            return "";
        }
        string = string.replaceAll("[^a-zA-Z0-9]", "-").toLowerCase();
        string = string.replaceAll("-+", "-");
        string = string.replaceAll("^-+", "");
        if ((string = string.replaceAll("-+$", "")).equalsIgnoreCase(helpKey)) {
            return "";
        }
        if (string.replace("-", "").equalsIgnoreCase(helpKey)) {
            return "";
        }
        return "/p/" + string;
    }

    public static HelpPageDescription convertHelpPagesToDescriptions(HelpPage helpPage) {
        String string = HelpPageFunctions.sanitizedHelpPageURL(helpPage.getTitle(), helpPage.getKey());
        HelpPageDescription helpPageDescription = new HelpPageDescription(helpPage.getKey(), string, helpPage.getTitle());
        helpPageDescription.setAlternativeKeys(helpPage.getAlternativeKeys());
        ArrayList<HelpPageDescription> arrayList = new ArrayList<HelpPageDescription>();
        arrayList.add(helpPageDescription);
        List list = helpPage.getChildPages();
        if (list != null) {
            for (HelpPage helpPage2 : list) {
                helpPageDescription.getChildPages().add(HelpPageFunctions.convertHelpPagesToDescriptions(helpPage2));
            }
        }
        return helpPageDescription;
    }
}

