/*
 * Decompiled with CFR 0.152.
 */
package com.inet.help.server.sbom.model;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.annotations.JsonField;
import com.inet.help.server.sbom.model.SBOMComponent;
import com.inet.help.server.sbom.model.SBOMDependency;
import com.inet.help.server.sbom.model.SBOMMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

@JsonData
public class SBOM {
    @JsonField(name="$schema")
    @JsonExcludeNull
    private String schema;
    private String serialNumber;
    private String bomFormat;
    private String specVersion;
    private Number version;
    private SBOMMetadata metadata;
    private List<SBOMComponent> components;
    private List<SBOMDependency> dependencies;

    private SBOM() {
    }

    public SBOMMetadata getMetadata() {
        return this.metadata;
    }

    @Nonnull
    public List<SBOMComponent> getComponents() {
        if (this.components == null) {
            this.components = new ArrayList<SBOMComponent>();
        } else if (!(this.components instanceof ArrayList)) {
            this.components = new ArrayList<SBOMComponent>(this.components);
        }
        return this.components;
    }

    public void addComponent(SBOMComponent component) {
        this.getComponents().add(component);
    }

    @Nonnull
    public List<SBOMDependency> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<SBOMDependency>();
        }
        if (!(this.dependencies instanceof ArrayList)) {
            this.dependencies = new ArrayList<SBOMDependency>(this.dependencies);
        }
        return this.dependencies;
    }

    public void addDependency(@Nonnull SBOMDependency dependency) {
        List<SBOMDependency> list = this.getDependencies();
        Optional<SBOMDependency> optional = list.stream().filter(d2 -> dependency.getRef().equals(d2.getRef())).findFirst();
        if (optional.isPresent()) {
            optional.get().addDependsOn(dependency.getDependsOn());
        } else {
            list.add(dependency);
        }
    }
}

