/*
 * Decompiled with CFR 0.152.
 */
package com.inet.help.api.utils;

import com.inet.annotations.InternalApi;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@InternalApi
public class NodeIterator
implements Iterable<Element>,
Iterator<Element> {
    private Element r;
    private Element s;

    public NodeIterator(Element startNode) {
        this.r = startNode;
    }

    @Override
    public boolean hasNext() {
        return this.a(true) != null;
    }

    @Override
    public void remove() {
        Element element = this.r;
        this.s = this.a(false);
        this.r = null;
        element.remove();
    }

    public void moveTo(Element element) {
        this.r = element;
        this.s = null;
    }

    @Override
    public Element next() {
        Element element = this.a(true);
        if (element == null) {
            throw new NoSuchElementException();
        }
        this.s = null;
        this.r = element;
        return this.r;
    }

    public Element previous() {
        if (this.s != null) {
            this.next();
            return this.previous();
        }
        if (this.r == null) {
            throw new IllegalStateException("Cannot go back if the end was reached");
        }
        if (this.r.previousElementSibling() != null) {
            this.r = this.a(this.r.previousElementSibling());
            return this.r;
        }
        this.r = this.r.parent();
        return this.r;
    }

    private Element a(Element element) {
        Elements elements = element.children();
        if (elements.isEmpty()) {
            return element;
        }
        return this.a((Element)elements.get(elements.size() - 1));
    }

    private Element a(boolean bl) {
        if (this.s != null) {
            return this.s;
        }
        if (this.r == null) {
            return null;
        }
        if (bl && this.r.children().size() > 0) {
            return this.r.child(0);
        }
        if (this.r.nextElementSibling() != null) {
            return this.r.nextElementSibling();
        }
        Element element = this.r;
        boolean bl2 = element instanceof Document;
        while ((element = element.parent()) != null) {
            if (element.nextElementSibling() != null) {
                return element.nextElementSibling();
            }
            bl2 = element instanceof Document;
        }
        if (!bl2) {
            throw new IllegalStateException(String.format("The current node %s was removed from the document, cannot continue with iteration.", this.r.nodeName()));
        }
        return null;
    }

    @Override
    @Nonnull
    public Iterator<Element> iterator() {
        return this;
    }
}

