/*
 * Decompiled with CFR 0.152.
 */
package com.inet.ftp.drive;

import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveFileTypeHandler;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveIOException;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.OperationProgressListener;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.DriveFeature;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.api.feature.Synchronization;
import com.inet.drive.api.feature.Thumbnail;
import com.inet.drive.api.mount.MountDescription;
import com.inet.drive.api.mount.MountUtils;
import com.inet.error.ErrorCode;
import com.inet.ftp.drive.c;
import com.inet.ftp.drive.d;
import com.inet.ftp.drive.e;
import com.inet.ftp.drive.f;
import com.inet.ftp.drive.g;
import com.inet.ftp.drive.h;
import com.inet.ftp.drive.k;
import com.inet.id.GUID;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class i
implements MetaData {
    @Nonnull
    private static final List<Class<? extends DriveFeature>> H = Collections.unmodifiableList(Arrays.asList(Folder.class, MetaData.class, Synchronization.class, Thumbnail.class));
    @Nonnull
    private static final List<Class<? extends DriveFeature>> I = Collections.unmodifiableList(Arrays.asList(Content.class, MetaData.class, Synchronization.class, Thumbnail.class));
    @Nonnull
    private final DriveEntry J;
    @Nonnull
    private final MountDescription F;
    @Nonnull
    private final g o;
    @Nonnull
    private final f p;
    private final String q;
    @Nonnull
    private final String K;
    @Nonnull
    private final String s;
    @Nonnull
    private final String G;
    @Nonnull
    private final String r;
    @Nonnull
    private final String L;

    public i(@Nonnull DriveEntry driveEntry, @Nonnull MountDescription mountDescription, @Nonnull String string, @Nonnull String string2, @Nonnull g g2, @Nonnull f f2) {
        this.J = driveEntry;
        this.F = mountDescription;
        this.o = g2;
        this.p = f2;
        this.s = f.l(string);
        this.G = f.l(string2);
        this.L = MountUtils.toAbsolutePath((String)mountDescription.getRoot().getPath(), (String)string);
        this.K = MountUtils.getIDForPath((String)this.L);
        if (string.equals("/")) {
            this.r = "";
            this.q = null;
        } else {
            int n = this.s.lastIndexOf("/");
            this.q = n == 0 ? "/" : string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string3.startsWith("/")) {
                string3 = string3.substring(1);
            }
            this.r = string3;
        }
    }

    public boolean exists() {
        return this.s() != null;
    }

    @Nullable
    private e s() {
        return this.p.g(this.s).p();
    }

    @Nullable
    public DriveEntry getParent() {
        if (this.q == null || this.q.equals("/")) {
            return this.F.getRoot();
        }
        String string = "/";
        int n = this.G.lastIndexOf("/");
        if (n > 0) {
            string = this.G.substring(0, n);
        }
        return d.a(this.F, this.q, string, this.o);
    }

    public <T> void setMetaData(@Nonnull MetaKey<T> key, @Nullable T value) throws DriveEntry.UnmodifiableEntryException, DriveOperationConflictException {
        String string;
        Object object2;
        if (MetaData.NAME.equals(key)) {
            String string2;
            String string3 = string2 = value != null ? String.valueOf(value).trim() : null;
            if (string2 == null || string2.isEmpty() || string2.equals(".") || string2.equals("..")) {
                String string4 = DriveUtils.MSG.getMsg("drive.entry.notallowedname", new Object[]{string2});
                DriveOperationConflictException.SingleEntryConflict singleEntryConflict = new DriveOperationConflictException.SingleEntryConflict(null, this.K, DriveOperationConflictException.CONFLICT.invalidName, string4);
                throw DriveOperationConflictException.createSingleConflictException((boolean)false, (DriveOperationConflictException.SingleEntryConflict)singleEntryConflict);
            }
            if (this.s.equals("/") || this.G.equals("/")) {
                throw new IllegalArgumentException(DriveUtils.MSG.getMsg("drive.entry.cannotchangename", new Object[]{this.r, string2}));
            }
            boolean bl = this.J.hasFeature(Folder.class);
            if (this.q != null) {
                this.p.j(this.q);
            }
            for (Object object2 : ((Folder)this.J.getParent().getFeature(Folder.class)).getChildren()) {
                if (!string2.equals(object2.getName())) continue;
                String string5 = ((Mount)object2.getFeature(Mount.class)).getOriginID();
                DriveOperationConflictException.SingleEntryConflict singleEntryConflict = DriveOperationConflictException.createAlreadyExistConflict((String)string5, (String)this.K, (String)this.J.getName(), (String)this.J.getPath(), (boolean)bl);
                throw DriveOperationConflictException.createSingleConflictException((boolean)false, (DriveOperationConflictException.SingleEntryConflict)singleEntryConflict);
            }
            string = this.q.endsWith("/") ? this.q + string2 : this.q + "/" + string2;
            try {
                this.o.a(this.s, string);
            }
            catch (Exception exception) {
                throw (RuntimeException)ErrorCode.throwAny((Throwable)exception);
            }
            if (this.q != null) {
                this.p.j(this.q);
            }
            if (bl) {
                this.p.k(this.s);
                this.p.k(string);
            } else {
                this.p.j(this.s);
                this.p.j(string);
            }
        } else {
            throw new DriveEntry.UnmodifiableEntryException(this.J);
        }
        object2 = MountUtils.toAbsolutePath((String)this.F.getRoot().getPath(), (String)string);
        String string6 = MountUtils.getIDForPath((String)object2);
        Drive drive = Drive.getInstance();
        drive.notifyObservers(DriveObserver.EventType.REMOVED, (Object)new DriveObserver.EventType.RemoveEvent(DriveIDUtils.getMountRootID((GUID)this.F.getID(), (String)this.K), (String)this.getMetaData(MetaData.PARENT_ID), this.r));
        DriveEntry driveEntry = drive.resolve(DriveIDUtils.getMountRootID((GUID)this.F.getID(), (String)string6));
        drive.notifyObservers(DriveObserver.EventType.CREATED, (Object)driveEntry);
    }

    @Nullable
    public <T> T getMetaData(@Nonnull MetaKey<T> key) {
        String string;
        switch (string = key.getKey()) {
            case "MODIFIED": {
                e e2 = this.s();
                if (e2 == null) {
                    return (T)Long.valueOf(0L);
                }
                return (T)Long.valueOf(e2.l());
            }
            case "NAME": {
                return (T)this.r;
            }
            case "PARENT_ID": {
                DriveEntry driveEntry = this.J.getParent();
                return (T)(driveEntry != null ? driveEntry.getID() : null);
            }
            case "ID": {
                return (T)this.K;
            }
            case "SIZE": {
                Content content = this.getFeature(Content.class);
                return (T)(content != null ? Long.valueOf(content.getSize()) : null);
            }
            case "PATH": {
                e e3 = this.s();
                if (e3 != null && e3.m()) {
                    if (this.G.equals("/")) {
                        return (T)this.G;
                    }
                    return (T)(this.G + "/");
                }
                return (T)this.G;
            }
            case "FILETYPE": {
                Content content = this.getFeature(Content.class);
                return (T)(content != null ? DriveFileTypeHandler.getSuffix((String)this.J.getName()) : null);
            }
        }
        return null;
    }

    @Nullable
    public <T extends DriveFeature> T getFeature(Class<T> type) throws DriveIOException {
        e e2 = this.s();
        if (e2 == null) {
            return null;
        }
        if (type == Folder.class && e2.m()) {
            return (T)new h(this.F, this.o, this.p, this.s, this.G);
        }
        if (type == Content.class && e2.n()) {
            return (T)new c(this.o, this.p, this.s, this.q, this.r);
        }
        if (type == MetaData.class) {
            return (T)this;
        }
        if (type == Synchronization.class) {
            return (T)new a();
        }
        if (type == Thumbnail.class) {
            String string;
            c c2;
            if (e2.getSize() > 0L && e2.getSize() <= 0x100000L && (c2 = (c)this.getFeature(Content.class)) != null && k.N.contains(string = DriveFileTypeHandler.getSuffix((String)this.J.getName()))) {
                return (T)new k(c2, e2.l());
            }
            return null;
        }
        return null;
    }

    public void a(@Nullable OperationProgressListener operationProgressListener) throws DriveOperationConflictException {
        try {
            e e2 = this.p.i(this.s).p();
            if (e2 != null) {
                this.o.a(this.s, e2.m());
                if (this.q != null) {
                    this.p.j(this.q);
                }
                if (e2.m()) {
                    this.p.k(this.s);
                } else {
                    this.p.j(this.s);
                }
            }
        }
        catch (Exception exception) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)exception);
        }
    }

    private class a
    implements Synchronization {
        private a() {
        }

        public long lastSynchronization() {
            f.a a2 = i.this.p.h(i.this.s);
            return a2 != null ? a2.r() : -1L;
        }

        public void synchronize() {
            i.this.p.k(i.this.s);
        }
    }
}

