/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.filter.regex;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.filter.regex.RegexPlugin;
import com.inet.pdfc.generator.continuous.structure.StructureElement;
import com.inet.pdfc.generator.filter.SortFilterBase;
import com.inet.pdfc.generator.message.BasicHighlightDataImpl;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.model.text.WordElement;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.util.LocationUtils;
import com.inet.pdfc.util.TextExtractor;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@InternalApi
public class RegexFilter
extends SortFilterBase {
    public static final String FILTER_NAME = "REGEXP";
    private List<Pattern> a = null;
    private RegexHighlightData b = new RegexHighlightData();
    private boolean c;

    public RegexFilter() {
        super(FILTER_NAME);
    }

    public RegexFilter setProfile(IProfile profile) {
        super.setProfile(profile);
        this.c = !profile.getBool(RegexPlugin.REGEX_MATCH_WORDS);
        List<PatternDefinition> list = RegexFilter.getPatternsFromConfig(profile);
        if (list != null) {
            this.a = new ArrayList<Pattern>();
            for (PatternDefinition patternDefinition : list) {
                if (!patternDefinition.isActive() || patternDefinition.getPattern() == null) continue;
                this.a.add(patternDefinition.getPattern());
            }
            if (this.a.isEmpty()) {
                this.a = null;
            }
        }
        return this;
    }

    public static List<PatternDefinition> getPatternsFromConfig(IProfile config) {
        ArrayList<PatternDefinition> arrayList = new ArrayList<PatternDefinition>();
        String string = config.getString(PDFCProperty.FILTER_PATTERNS);
        if (string != null) {
            for (String string2 : string.split("\n")) {
                if (string2.trim().isEmpty()) continue;
                arrayList.add(new PatternDefinition(string2.replace("[[CR]]", "\n")));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public List<DrawableElement> sortOrFilterPage(int pageNr, List<DrawableElement> pageElements, boolean first, List<CompareDiffGroup> diffGroups) {
        Object object;
        RemoveRange removeRange;
        Object object2;
        Pattern pattern22;
        if (this.a == null || this.a.isEmpty()) {
            return pageElements;
        }
        TextExtractor.PageDescription pageDescription = new TextExtractor(this.getProfile()).createPageDescription(pageElements);
        List<RemoveRange> list = null;
        for (Pattern pattern22 : this.a) {
            object2 = pattern22.matcher(pageDescription.getContent());
            while (((Matcher)object2).find()) {
                if (((Matcher)object2).groupCount() == 0) {
                    removeRange = new RemoveRange(((Matcher)object2).start(), ((Matcher)object2).end());
                    list = this.a(list, removeRange);
                    continue;
                }
                for (int i = 1; i <= ((Matcher)object2).groupCount(); ++i) {
                    if (((Matcher)object2).start(i) < 0) continue;
                    RemoveRange removeRange2 = new RemoveRange(((Matcher)object2).start(i), ((Matcher)object2).end(i));
                    list = this.a(list, removeRange2);
                }
            }
        }
        if (list == null) {
            return pageElements;
        }
        HashMap hashMap = new HashMap();
        pattern22 = new StructureElement(ElementType.Page, null, pageElements, pageNr, ElementID.DUMMY);
        object2 = list.iterator();
        removeRange = null;
        block3: for (Object object3 : pageDescription.getContentRef()) {
            while ((removeRange == null || removeRange.n <= object3.getStart()) && object2.hasNext()) {
                removeRange = (RemoveRange)object2.next();
            }
            Object var13_16 = null;
            while (removeRange != null && removeRange.isInRange((TextExtractor.WordEntry)object3)) {
                void object4;
                if (object4 == null) {
                    a a2 = new a((TextExtractor.WordEntry)object3);
                    object = object3.getContainer() != null ? object3.getContainer() : pattern22;
                    this.a(object, a2, hashMap);
                }
                if (this.c) {
                    object4.a(removeRange);
                }
                if (removeRange.n > object3.getEnd()) continue block3;
                if (!object2.hasNext()) break block3;
                removeRange = (RemoveRange)object2.next();
            }
        }
        int n = 0;
        if (hashMap.isEmpty()) {
            return pageElements;
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            n = 0;
            object = (List)entry.getValue();
            StructureElement structureElement = (StructureElement)entry.getKey();
            List list2 = structureElement.getChildren();
            a a3 = (a)object.get(n++);
            ArrayList<Object> arrayList = new ArrayList<Object>(list2.size() - object.size());
            for (DrawableElement drawableElement : list2) {
                if (a3 == null || drawableElement != a3.c()) {
                    arrayList.add(drawableElement);
                    continue;
                }
                for (WordElement wordElement : a3.f()) {
                    this.b.addMarker((DrawableElement)wordElement, pageNr, first);
                }
                if (a3.e() != null) {
                    arrayList.addAll(a3.e());
                }
                a3 = n < object.size() ? (a)object.get(n++) : null;
            }
            list2.clear();
            list2.addAll(arrayList);
        }
        return pattern22.getChildren();
    }

    private <A, B> void a(A a2, B b, Map<A, List<B>> map) {
        List<B> list = map.get(a2);
        if (list == null) {
            list = new ArrayList<B>();
            map.put(a2, list);
        }
        list.add(b);
    }

    private List<RemoveRange> a(List<RemoveRange> list, RemoveRange removeRange) {
        ArrayList<RemoveRange> arrayList = new ArrayList<RemoveRange>(list != null ? list.size() + 1 : 1);
        if (list != null) {
            for (RemoveRange removeRange2 : list) {
                if (removeRange == null || removeRange2.n < removeRange.m) {
                    arrayList.add(removeRange2);
                    continue;
                }
                if (removeRange2.m > removeRange.n) {
                    arrayList.add(removeRange);
                    removeRange = null;
                    arrayList.add(removeRange2);
                    continue;
                }
                removeRange.m = Math.min(removeRange2.m, removeRange.m);
                removeRange.n = Math.max(removeRange2.n, removeRange.n);
            }
        }
        if (removeRange != null) {
            arrayList.add(removeRange);
        }
        return arrayList;
    }

    public RegexHighlightData getHighlightProvider() {
        return this.b;
    }

    @JsonData
    private static class RegexHighlightData
    extends BasicHighlightDataImpl {
        private static final Color OUTLINE = new Color(192, 0, 0, 128);

        private RegexHighlightData() {
            super(RegexFilter.FILTER_NAME);
        }

        public void addMarker(DrawableElement el, int page, boolean left) {
            Rectangle rectangle = LocationUtils.getOutline((PagedElement)el);
            HighlightData.Highlight highlight = new HighlightData.Highlight(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2, el.getType().name(), HighlightData.Highlight.Appearance.FILLED_RECTANGLE, OUTLINE);
            HashMap hashMap = left ? this.getFirst() : this.getSecond();
            List list = hashMap.computeIfAbsent(page, k -> new ArrayList());
            list.add(highlight);
        }

        public List<HighlightData.Highlight> getPageHighlights(int pageNr, boolean firstDocument) {
            return (List)(firstDocument ? this.getFirst() : this.getSecond()).get(pageNr);
        }
    }

    @InternalApi
    public static class PatternDefinition {
        private ACTIVETYPE active;
        private PATTERNTYPE f;
        private Pattern g;
        private String h;

        public PatternDefinition(String configPattern) {
            configPattern = configPattern.trim();
            if (configPattern.endsWith("|" + ACTIVETYPE.inactive.name())) {
                this.active = ACTIVETYPE.inactive;
                configPattern = configPattern.substring(0, configPattern.length() - ACTIVETYPE.inactive.name().length() - 1).trim();
            } else {
                if (configPattern.endsWith("|" + ACTIVETYPE.active.name())) {
                    configPattern = configPattern.substring(0, configPattern.length() - ACTIVETYPE.active.name().length() - 1).trim();
                }
                this.active = ACTIVETYPE.active;
            }
            this.f = PATTERNTYPE.text;
            if (configPattern.endsWith("|" + PATTERNTYPE.text.name())) {
                configPattern = configPattern.substring(0, configPattern.length() - PATTERNTYPE.text.name().length() - 1).trim();
            } else if (configPattern.endsWith("|" + PATTERNTYPE.regexp.name())) {
                configPattern = configPattern.substring(0, configPattern.length() - PATTERNTYPE.regexp.name().length() - 1).trim();
                this.f = PATTERNTYPE.regexp;
            }
            if (configPattern.isEmpty()) {
                this.h = "";
                this.g = null;
            } else {
                this.h = configPattern;
                if (this.f == PATTERNTYPE.text) {
                    configPattern = Pattern.quote(configPattern);
                }
                try {
                    this.g = Pattern.compile(configPattern);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    PDFCCore.LOGGER_COMPARE.warn((Object)("Could not load pattern '" + configPattern + "' : " + patternSyntaxException.getDescription() + " near index " + patternSyntaxException.getIndex()));
                }
            }
        }

        public PatternDefinition(ACTIVETYPE active, PATTERNTYPE type, String pattern) {
            this.active = active;
            this.f = type;
            this.g = Pattern.compile(type == PATTERNTYPE.regexp ? pattern : Pattern.quote(pattern));
            this.h = pattern;
        }

        public void setActive(boolean active) {
            this.active = active ? ACTIVETYPE.active : ACTIVETYPE.inactive;
        }

        public void setType(PATTERNTYPE type) {
            this.f = type;
        }

        public void setPatternString(String patternString) throws PatternSyntaxException {
            this.h = patternString;
            try {
                this.g = Pattern.compile(this.f == PATTERNTYPE.regexp ? patternString : Pattern.quote(patternString));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.g = null;
                throw patternSyntaxException;
            }
        }

        public boolean isActive() {
            return this.active == ACTIVETYPE.active;
        }

        public boolean isUsed() {
            return this.active == ACTIVETYPE.active && this.h != null && !this.h.isEmpty() && this.g != null;
        }

        public PATTERNTYPE getType() {
            return this.f;
        }

        public boolean isRegEx() {
            return this.f == PATTERNTYPE.regexp;
        }

        public Pattern getPattern() {
            return this.g;
        }

        public String getPlainPattern() {
            return this.h;
        }

        public String toString() {
            String string = this.h;
            if (string != null) {
                string = string.replace("\n", "[[CR]]");
            }
            return string + (String)(this.f != null ? "|" + String.valueOf((Object)this.f) : "") + (String)(this.active != null ? "|" + String.valueOf((Object)this.active) : "");
        }
    }

    @InternalApi
    public static class RemoveRange
    implements Comparable<RemoveRange> {
        private int m;
        private int n;

        public RemoveRange(int from, int to) {
            this.m = from;
            this.n = to;
        }

        @Override
        public int compareTo(RemoveRange o) {
            return this.m - o.m;
        }

        public boolean isInRange(TextExtractor.WordEntry e) {
            return e.getStart() < this.n && e.getEnd() > this.m;
        }

        public String toString() {
            return "Range " + this.m + " - " + this.n;
        }

        public int getTo() {
            return this.n;
        }

        public int getFrom() {
            return this.m;
        }

        public void setTo(int to) {
            this.n = to;
        }

        public void setFrom(int from) {
            this.m = from;
        }
    }

    private static class a {
        private TextExtractor.WordEntry i;
        private List<WordElement> j = null;
        private List<WordElement> k = null;
        private List<RemoveRange> l;

        public a(TextExtractor.WordEntry wordEntry) {
            this.i = wordEntry;
        }

        public void a(RemoveRange removeRange) {
            if (removeRange.m > this.i.getStart() || removeRange.n < this.i.getEnd()) {
                if (this.l == null) {
                    this.l = new ArrayList<RemoveRange>();
                }
                this.l.add(removeRange);
            }
        }

        public WordElement c() {
            return this.i.getWord();
        }

        private void d() {
            if (this.l == null) {
                return;
            }
            int n = 0;
            this.k = new ArrayList<WordElement>();
            this.j = new ArrayList<WordElement>();
            int n2 = this.i.getEnd() - this.i.getStart();
            for (RemoveRange removeRange : this.l) {
                int n3 = Math.max(0, removeRange.m - this.i.getStart());
                int n4 = Math.min(n2, removeRange.n - this.i.getStart());
                if (n < n3) {
                    this.j.add(this.i.getWord().subText(n, n3));
                }
                this.k.add(this.i.getWord().subText(n3, n4));
                n = n4;
            }
            if (n < n2) {
                this.j.add(this.i.getWord().subText(n, n2));
            }
            this.l = null;
        }

        public List<WordElement> e() {
            this.d();
            return this.j;
        }

        public List<WordElement> f() {
            this.d();
            return this.k != null ? this.k : Arrays.asList(this.i.getWord());
        }
    }

    @InternalApi
    public static final class PATTERNTYPE
    extends Enum<PATTERNTYPE> {
        public static final /* enum */ PATTERNTYPE regexp = new PATTERNTYPE();
        public static final /* enum */ PATTERNTYPE text = new PATTERNTYPE();
        private static final /* synthetic */ PATTERNTYPE[] e;

        public static PATTERNTYPE[] values() {
            return (PATTERNTYPE[])e.clone();
        }

        public static PATTERNTYPE valueOf(String name) {
            return Enum.valueOf(PATTERNTYPE.class, name);
        }

        private static /* synthetic */ PATTERNTYPE[] b() {
            return new PATTERNTYPE[]{regexp, text};
        }

        static {
            e = PATTERNTYPE.b();
        }
    }

    @InternalApi
    public static final class ACTIVETYPE
    extends Enum<ACTIVETYPE> {
        public static final /* enum */ ACTIVETYPE active = new ACTIVETYPE();
        public static final /* enum */ ACTIVETYPE inactive = new ACTIVETYPE();
        private static final /* synthetic */ ACTIVETYPE[] d;

        public static ACTIVETYPE[] values() {
            return (ACTIVETYPE[])d.clone();
        }

        public static ACTIVETYPE valueOf(String name) {
            return Enum.valueOf(ACTIVETYPE.class, name);
        }

        private static /* synthetic */ ACTIVETYPE[] a() {
            return new ACTIVETYPE[]{active, inactive};
        }

        static {
            d = ACTIVETYPE.a();
        }
    }
}

