/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.filter.ocr;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.graphics.buffered.GraphicsFilter;
import com.inet.pdfc.PDFCCorePlugin;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.ValidValueProvider;
import com.inet.pdfc.filter.ocr.OCRPlugin;
import com.inet.pdfc.generator.analysis.FeatureKey;
import com.inet.pdfc.generator.continuous.structure.StructureElement;
import com.inet.pdfc.generator.filter.ISortFilter;
import com.inet.pdfc.generator.message.BasicHighlightDataImpl;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.model.forms.GeomShape;
import com.inet.pdfc.generator.model.text.TextModuleUtils;
import com.inet.pdfc.generator.model.text.WordElement;
import com.inet.pdfc.model.AWTFontInfo;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.FontInfo;
import com.inet.pdfc.model.Page;
import com.inet.pdfc.model.ShapeElement;
import com.inet.pdfc.model.TextElement;
import com.inet.pdfc.ocr.Language;
import com.inet.pdfc.ocr.LanguageManager;
import com.inet.pdfc.ocr.OcrAnalyseFilterBase;
import com.inet.pdfc.ocr.OcrUsage;
import com.inet.pdfc.ocr.OcrWord;
import com.inet.pdfc.thread.PdfcSession;
import com.inet.pdfc.util.ElementSorter;
import com.inet.pdfc.util.FilteredGraphics;
import com.inet.pdfc.util.OCRGraphicsFilter;
import com.inet.pdfc.util.Pair;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.utils.UmlautsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class OCRFilter
extends OcrAnalyseFilterBase {
    private static int a = 2;
    private List<Pair<Dimension>> b = new ArrayList<Pair<Dimension>>();
    private boolean c;
    private BasicHighlightDataImpl d = new BasicHighlightDataImpl("OCR");
    public static final PDFCProperty<String> NORMALIZATION_LEVEL = new PDFCProperty("NORMALIZATION_LEVEL", "1", new ValidValueProvider(Arrays.asList(new a(0), new a(1), new a(2), new a(3))));
    public static final ConfigKey NORMALIZATION_LEVEL_KEY = new ConfigKey("pdfc.filter.NORMALIZATION_LEVEL.WEBGUI", (String)NORMALIZATION_LEVEL.getDefaultValue(), Integer.class);

    public ISortFilter setProfile(IProfile profile) {
        PdfcSession.getSession().getSessionProperties().setProperty("filter.nobreakiterator", "true");
        this.c = !profile.getBool(PDFCProperty.COMPARE_TEXT_CASE_SENSITIVE);
        return super.setProfile(profile);
    }

    public void setTotalPages(int pageCount, boolean first) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyze(int pageNr, Dimension size, List<DrawableElement> pageElements, boolean first) {
        OCRFilter oCRFilter = this;
        synchronized (oCRFilter) {
            while (pageNr >= this.b.size()) {
                this.b.add((Pair<Dimension>)new Pair());
            }
        }
        this.b.get(pageNr).set(first, (Object)size);
    }

    public List<DrawableElement> sortOrFilterPage(int pageNr, List<DrawableElement> pageElements, boolean first, @Nullable List<CompareDiffGroup> diffGroups) {
        if (!this.isActive()) {
            return pageElements;
        }
        boolean bl = pageElements.size() > 0;
        block3: for (DrawableElement object2 : pageElements) {
            switch (object2.getType()) {
                case Text: 
                case TextWord: 
                case Annotation: {
                    continue block3;
                }
            }
            bl = false;
        }
        if (bl) {
            return pageElements;
        }
        Dimension dimension = (Dimension)this.b.get(pageNr).get(first);
        List<HighlightData.Highlight> list = this.a(pageNr, first);
        ArrayList<DrawableElement> arrayList = new ArrayList<DrawableElement>(pageElements);
        Pair pair = new Pair();
        pair.set(true, (Object)this.a(arrayList, 0));
        b b2 = new b(pageNr, dimension.width, dimension.height, 0, first);
        pageElements.clear();
        pageElements.addAll(this.a(b2, arrayList, pageNr, first, (Pair<Integer>)pair));
        String string = OCRPlugin.MSG.getMsg("pdfc.filter.OCR.hightlight", new Object[]{dimension.getWidth() + "x" + dimension.getHeight(), pair.get(true), pair.get(false)});
        list.add(new HighlightData.Highlight(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight(), string, HighlightData.Highlight.Appearance.FILLED_RECTANGLE, new Color(0, 100, 255)));
        return pageElements;
    }

    private int a(List<DrawableElement> list, int n) {
        for (DrawableElement drawableElement : list) {
            if (drawableElement.getType() == ElementType.Image) {
                ++n;
                continue;
            }
            if (!drawableElement.getType().isStructuralType()) continue;
            n = this.a(((StructureElement)drawableElement).getChildren(), n);
        }
        return n;
    }

    private List<DrawableElement> a(Page page, List<DrawableElement> list, int n, boolean bl, Pair<Integer> pair) {
        try {
            Object object;
            Object object2;
            Rectangle rectangle;
            String string = this.applyOCRLanguage(bl);
            List list2 = this.getOcrUsage().getWords(page, (GraphicsFilter)new OCRGraphicsFilter().blockText(), bl);
            pair.set(false, (Object)list2.size());
            if (list2.size() == 0 && list.size() > 0) {
                return list;
            }
            ArrayList<TextElement> arrayList = new ArrayList<TextElement>();
            ArrayList<DrawableElement> arrayList2 = new ArrayList<DrawableElement>(list);
            BufferedImage bufferedImage = new BufferedImage((int)page.getWidth(), (int)page.getHeight(), 10);
            Graphics graphics = bufferedImage.getGraphics();
            ElementID elementID = new ElementID(new int[]{n, (int)page.getWidth(), (int)page.getHeight(), 0});
            block3: for (OcrWord ocrWord : list2) {
                DrawableElement drawableElement;
                rectangle = ocrWord.getArea();
                if (ocrWord.getText().trim().isEmpty() || ocrWord.getFont().getSize() == 0 || rectangle.height > 50 && ocrWord.getText().length() == 1) continue;
                object2 = new Rectangle2D.Double(rectangle.x - a, rectangle.y - a, rectangle.width + 2 * a, rectangle.height + 2 * a);
                object = this.a((Rectangle2D)object2, arrayList2);
                String string2 = ocrWord.getText();
                if (string2.trim().length() == 0) continue;
                Object object3 = object.iterator();
                while (object3.hasNext()) {
                    drawableElement = (DrawableElement)object3.next();
                    if (drawableElement.getType() != ElementType.TextWord || !string2.equals(drawableElement.getLabel())) continue;
                    continue block3;
                }
                object3 = object.iterator();
                while (object3.hasNext()) {
                    drawableElement = (DrawableElement)object3.next();
                    if (!(drawableElement instanceof ShapeElement) && !(drawableElement instanceof GeomShape)) continue;
                    arrayList2.remove(drawableElement);
                }
                object3 = ocrWord.getFont();
                drawableElement = new AWTFontInfo((Font)object3);
                Color color = Color.BLACK;
                Color color2 = Color.WHITE;
                double[] dArray = new double[string2.length()];
                FontMetrics fontMetrics = drawableElement.getMetrics(ocrWord.getFont().getSize());
                double d = 0.0;
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = fontMetrics.charWidth(string2.charAt(i));
                    d += dArray[i];
                }
                Rectangle2D rectangle2D = new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if ((double)(fontMetrics.getHeight() * 2) < Math.abs(rectangle2D.getHeight())) {
                    rectangle2D = fontMetrics.getStringBounds(string2, graphics);
                    OCRPlugin.LOGGER.warn((Object)("The bounds for " + string2 + " was corrected"));
                }
                double d2 = rectangle2D.getWidth() / d;
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = dArray[i] * d2;
                }
                AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, -1.0, rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight() * 0.75);
                TextElement textElement = new TextElement((FontInfo)drawableElement, (float)(rectangle2D.getHeight() * 0.75), affineTransform, string2, (Paint)color, (Paint)color2, dArray, null, false, true, elementID);
                elementID = elementID.getNext();
                textElement.setPageIndex(n);
                arrayList.add(textElement);
                ArrayList arrayList3 = new ArrayList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    i += TextModuleUtils.convertText((int)i, arrayList, arrayList3, null, (String)string, (boolean)false) - 1;
                }
                arrayList2.addAll(arrayList3);
                arrayList.clear();
            }
            if (this.c) {
                for (DrawableElement drawableElement : arrayList2) {
                    if (drawableElement.getType() != ElementType.TextWord || ((String)(object = ((String)(object2 = UmlautsUtils.replaceUmlauts((String)(rectangle = (WordElement)drawableElement).getLabel()))).toLowerCase())).equals(rectangle.getLabel())) continue;
                    rectangle.setWord((String)object, true);
                }
            }
            ElementSorter.alignAndSort(arrayList2, (double)0.5, (boolean)true, (boolean)false, (boolean)true);
            list = arrayList2;
        }
        catch (IOException iOException) {
            OCRPlugin.LOGGER.error((Throwable)iOException);
            OCRPlugin.LOGGER.error((Object)OCRPlugin.MSG.getMsg("pdfc.filter.OCR.function.tesseract", new Object[0]));
        }
        catch (Error error) {
            throw new IllegalStateException("OCR Filter, page " + (n + 1) + ": " + error.getMessage(), error);
        }
        return list;
    }

    protected String applyOCRLanguage(boolean first) {
        Language language = LanguageManager.getInstance().getLanguage(first);
        OcrUsage ocrUsage = this.getOcrUsage();
        if (language != null && ocrUsage != null) {
            ocrUsage.setLanguage(language);
            return language.getCountry();
        }
        return null;
    }

    private List<DrawableElement> a(Rectangle2D rectangle2D, List<DrawableElement> list) {
        ArrayList<DrawableElement> arrayList = new ArrayList<DrawableElement>();
        Rectangle2D rectangle2D2 = this.a(rectangle2D);
        for (DrawableElement drawableElement : list) {
            double d;
            if (drawableElement.getBounds() == null) continue;
            Rectangle2D rectangle2D3 = this.a(drawableElement.getBounds());
            if (rectangle2D3.getHeight() == 0.0) {
                rectangle2D3.setRect(rectangle2D3.getX(), rectangle2D3.getY(), rectangle2D3.getWidth(), 1.0);
            }
            if (rectangle2D3.getWidth() == 0.0) {
                rectangle2D3.setRect(rectangle2D3.getX(), rectangle2D3.getY(), 1.0, rectangle2D3.getHeight());
            }
            if (!((d = this.a(rectangle2D3, rectangle2D2)) >= 0.5)) continue;
            arrayList.add(drawableElement);
        }
        return arrayList;
    }

    private double a(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (rectangle2D.contains(rectangle2D2)) {
            return 1.0;
        }
        Rectangle2D rectangle2D3 = rectangle2D.createIntersection(rectangle2D2);
        if (rectangle2D3.getHeight() < 0.0 || rectangle2D3.getWidth() < 0.0) {
            return 0.0;
        }
        return rectangle2D3.getWidth() * rectangle2D3.getHeight() / (rectangle2D.getWidth() * rectangle2D.getHeight());
    }

    private Rectangle2D a(Rectangle2D rectangle2D) {
        return this.a(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    private Rectangle2D a(double d, double d2, double d3, double d4) {
        if (d3 < 0.0) {
            d += d3;
            d3 *= -1.0;
        }
        if (d4 < 0.0) {
            d2 += d4;
            d4 *= -1.0;
        }
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    private List<HighlightData.Highlight> a(int n, boolean bl) {
        ArrayList<HighlightData.Highlight> arrayList = new ArrayList<HighlightData.Highlight>();
        if (bl) {
            this.d.getFirst().put(n, arrayList);
        } else {
            this.d.getSecond().put(n, arrayList);
        }
        return arrayList;
    }

    public HighlightData getHighlightProvider() {
        return this.d;
    }

    public int getLookAheadWindowSize() {
        return 1;
    }

    public void setCurrentSyncOffset(int offset) {
    }

    public void reInit(IProfile profile) {
    }

    @Nonnull
    public String getExtensionName() {
        return "OCR";
    }

    public List<FeatureKey> getAcceptedPreAnalyzeFeatures() {
        if (ServerPluginManager.getInstance().isPluginLoaded("analysis.language")) {
            try {
                return Arrays.asList(PDFCCorePlugin.FEATURE_LANGUAGE_DETECTION);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return super.getAcceptedPreAnalyzeFeatures();
    }

    private static class b
    extends Page {
        private final boolean g;

        private b(int n, float f, float f2, int n2, boolean bl) {
            super(n, f, f2, n2);
            this.g = bl;
        }

        public void releaseResources() {
        }

        public Exception getRecentError() {
            return null;
        }

        public BufferedImage getImage(int width, int height, Rectangle2D clip, boolean drawbg, boolean wait) {
            double d = ((double)width / (double)this.getWidth() + (double)height / (double)this.getHeight()) / 2.0;
            return PdfcSession.getSession().getStoreMap().getPageImage(this.g, this.getPageIndex(), d, d, FilteredGraphics.FILTERTYPES.NO_TEXTELEMENTS);
        }
    }

    private static class a
    implements ValidValueProvider.ValidValue {
        private int f;

        public a(int n) {
            this.f = n;
        }

        public String getProfileValue() {
            return Integer.toString(this.f);
        }

        public String getDisplayString() {
            return OCRPlugin.MSG.getMsg("pdfc.filter.NORMALIZATION_LEVEL." + this.f, new Object[0]);
        }
    }
}

