/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.filter.multicolumn;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.generator.continuous.structure.StructureElement;
import com.inet.pdfc.generator.filter.SortFilterBase;
import com.inet.pdfc.generator.filter.SorterUtils;
import com.inet.pdfc.generator.message.BasicHighlightDataImpl;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.model.forms.GeomShape;
import com.inet.pdfc.generator.model.forms.LineShape;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.HasBounds;
import com.inet.pdfc.util.ElementSorter;
import com.inet.pdfc.util.LocationUtils;
import com.inet.pdfc.util.RattleSort;
import com.inet.pdfc.util.Sample;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@InternalApi
public class MultiColumnFilter
extends SortFilterBase {
    public static final Color OUTLINE_COLOR = Color.GREEN.darker();
    private MultiColHighlightData a = new MultiColHighlightData();

    public MultiColumnFilter(IProfile conf) {
        this();
    }

    public MultiColumnFilter() {
        super("MULTICOLUMN");
    }

    public List<DrawableElement> sortOrFilterPage(int pageIndex, List<DrawableElement> pageElements, boolean first, List<CompareDiffGroup> diffGroups) {
        boolean bl;
        Object object;
        double d;
        Rectangle2D rectangle2D = this.getTextBounds(pageElements);
        if (rectangle2D == null) {
            this.a.addHighlightDataForCurrentPage(first, new ArrayList<a>(), pageIndex);
            return pageElements;
        }
        Dimension dimension = this.getPageSize(pageIndex, first);
        Rectangle2D rectangle2D2 = LocationUtils.getJoinedBounds(pageElements, (boolean)true);
        int n = (int)(rectangle2D2.getWidth() > (double)(dimension.width / 2) ? rectangle2D2.getWidth() : (double)dimension.width);
        int n2 = dimension.height;
        ArrayList<DrawableElement> arrayList2 = new ArrayList<DrawableElement>(pageElements.size() / 4);
        HashSet<DrawableElement> hashSet = new HashSet<DrawableElement>(pageElements.size() / 128);
        ArrayList<DrawableElement> arrayList3 = new ArrayList<DrawableElement>(pageElements.size() / 4);
        boolean bl2 = false;
        for (DrawableElement bArray2 : pageElements) {
            bl2 = false;
            double arrayList4 = bArray2.getBounds().getWidth();
            if (MultiColumnFilter.isDetectionType(bArray2)) {
                Rectangle2D d3;
                if (bArray2.getType() == ElementType.Image && ((d3 = bArray2.getBounds()).getMinY() < rectangle2D.getMinY() || d3.getMaxY() > rectangle2D.getMaxY() || d3.getHeight() > (double)(n2 / 2) || d3.getWidth() < 20.0)) {
                    hashSet.add(bArray2);
                    continue;
                }
                arrayList2.add(bArray2);
                continue;
            }
            if (!(arrayList4 > 20.0) || !(arrayList4 < (double)n * 0.95) || !this.a(bArray2.getFillPaint()) && !this.a(bArray2.getStrokePaint())) continue;
            bl2 = true;
            arrayList3.add(bArray2);
        }
        if (bl2) {
            arrayList3.remove(arrayList3.size() - 1);
        }
        Collections.sort(arrayList3, ElementSorter.YX_COMPARATOR);
        b[] bArray3 = this.a(pageElements, n, rectangle2D);
        b[] bArray = this.b(pageElements, n2, rectangle2D);
        ArrayList<c> arrayList = new ArrayList<c>();
        List<com.inet.pdfc.filter.multicolumn.a> list = com.inet.pdfc.filter.multicolumn.a.a(arrayList2, false, bArray);
        if (list.size() > 1) {
            Object object2;
            Object object3;
            double object4 = 5.0;
            d = list.get(0).q();
            double list2 = list.get(list.size() - 1).r();
            double d2 = (list2 - d) / 2.0 + d;
            int n3 = -1;
            for (int rectangle2D4 = 1; rectangle2D4 < list.size(); ++rectangle2D4) {
                object3 = list.get(rectangle2D4 - 1);
                object2 = list.get(rectangle2D4);
                if (!(((com.inet.pdfc.filter.multicolumn.a)object3).r() < d2 + object4) || !(((com.inet.pdfc.filter.multicolumn.a)object2).q() > d2 - object4)) continue;
                n3 = rectangle2D4;
                break;
            }
            if (n3 > 0 && list2 - d > (double)(n / 2)) {
                Rectangle2D rectangle2D3 = LocationUtils.getJoinedBounds(arrayList2);
                object3 = this.a(n, list, rectangle2D3.getMinY(), rectangle2D3.getMaxY());
                object2 = (a)object3.get(0);
                for (int a2 = 1; a2 < n3; ++a2) {
                    ((a)object2).a((a)object3.get(a2), true);
                }
                a a2 = (a)object3.get(n3);
                for (int arrayList5 = n3 + 1; arrayList5 < object3.size(); ++arrayList5) {
                    a2.a((a)object3.get(arrayList5), true);
                }
                if (((a)object2).c.getHeight() > ((a)object2).f * 4.0 && a2.c.getHeight() > a2.f * 4.0) {
                    ((a)object2).i = Boolean.TRUE;
                    a2.i = Boolean.TRUE;
                }
                arrayList.add(new c(new ArrayList<a>(Arrays.asList(object2, a2))));
                ArrayList<DrawableElement> arrayList4 = new ArrayList<DrawableElement>(arrayList3);
                ListIterator listIterator = arrayList3.listIterator();
                Dimension dimension2 = this.getPageSize(pageIndex, first);
                double d3 = (list2 - d) * 0.75;
                double d4 = (double)dimension2.height * 0.1;
                double d5 = (double)dimension2.height * 0.9;
                while (listIterator.hasNext()) {
                    DrawableElement drawableElement = (DrawableElement)listIterator.next();
                    rectangle2D3 = drawableElement.getBounds();
                    if (rectangle2D3.getMaxY() < d4 || rectangle2D3.getMinY() > d5) {
                        listIterator.remove();
                        continue;
                    }
                    if (drawableElement.getType() != ElementType.LineHorizontal || !(rectangle2D3.getMinX() > d) && !(rectangle2D3.getMaxX() < list2) || !(rectangle2D3.getWidth() < d3)) continue;
                    listIterator.remove();
                }
                this.a(arrayList3, arrayList);
                if (arrayList.size() == 1 && ((c)arrayList.get(0)).h().size() == 1) {
                    arrayList.clear();
                    arrayList3 = arrayList4;
                }
            }
        }
        if (arrayList.isEmpty()) {
            Object object4 = null;
            List<com.inet.pdfc.filter.multicolumn.a> list2 = com.inet.pdfc.filter.multicolumn.a.a(arrayList2, true, bArray3);
            for (com.inet.pdfc.filter.multicolumn.a a3 : list2) {
                List<com.inet.pdfc.filter.multicolumn.a> b2 = com.inet.pdfc.filter.multicolumn.a.a(a3.p(), false, bArray);
                object = new c(this.a(n, b2, a3.q(), a3.r()));
                if (object4 != null) {
                    ((c)object).a(!b.a(((c)object4).c.getMaxY(), ((c)object).c.getMinY(), bArray3));
                }
                if (arrayList.size() > 0 && ((c)arrayList.get(arrayList.size() - 1)).a((c)object, false, hashSet, bArray3)) continue;
                arrayList.add((c)object);
                object4 = object;
            }
        }
        if (bArray3.length > 7) {
            for (c c3 : arrayList) {
                d = c3.g();
                b a3 = b.a(c3.c.getMinY(), bArray3, true);
                object = b.a(c3.c.getMaxY(), bArray3, false);
                if (!(a3.k > c3.c.getMinY() - d) || !(((b)object).k < c3.c.getMaxY() + d) || !(c3.c.getHeight() < (double)(n2 / 3))) continue;
                c3.k();
            }
        }
        this.a(arrayList3, arrayList);
        do {
            bl = false;
            if (MultiColumnFilter.c(hashSet, arrayList, bArray3)) {
                this.a(arrayList3, arrayList);
                bl = true;
            }
            if (MultiColumnFilter.b(hashSet, arrayList, bArray3)) {
                this.a(arrayList3, arrayList);
                bl = true;
            }
            if (bl) continue;
            bl |= MultiColumnFilter.a(hashSet, arrayList);
        } while (bl);
        this.a(arrayList3, arrayList);
        MultiColumnFilter.a(hashSet, arrayList, bArray3);
        arrayList.forEach(c::l);
        ArrayList<a> arrayList5 = arrayList.stream().map(c2 -> c2.h()).flatMap(Collection::stream).collect(Collectors.toList());
        this.a.addHighlightDataForCurrentPage(first, arrayList5.size() > 1 ? arrayList5 : new ArrayList<a>(), pageIndex);
        if (arrayList5.size() <= 1) {
            return pageElements;
        }
        for (DrawableElement drawableElement : pageElements) {
            if (MultiColumnFilter.isDetectionType(drawableElement) || drawableElement.getType() == ElementType.Image && !hashSet.contains(drawableElement)) continue;
            a a4 = MultiColumnFilter.a(arrayList5, LocationUtils.getBounds((HasBounds)drawableElement));
            if (a4 == null) {
                PDFCCore.LOGGER_COMPARE.warn((Object)("MultiColumn: No Column for " + String.valueOf(drawableElement) + " on page " + (drawableElement.getPageIndex() + 1)));
                return pageElements;
            }
            a4.e.add(drawableElement);
        }
        pageElements = new ArrayList<DrawableElement>(arrayList5.size());
        for (a a5 : arrayList5) {
            Collections.sort(a5.e, ElementSorter.YX_COMPARATOR);
            if (a5.e.size() == 1) {
                pageElements.addAll(a5.e);
                continue;
            }
            pageElements.add((DrawableElement)new StructureElement(ElementType.Paragraph, a5.c, a5.e, pageIndex, a5.e.get(0).getElementID().getDescendant()));
        }
        return pageElements;
    }

    private List<a> a(int n, List<com.inet.pdfc.filter.multicolumn.a> list, double d, double d2) {
        ArrayList<a> arrayList = new ArrayList<a>();
        for (com.inet.pdfc.filter.multicolumn.a a2 : list) {
            Rectangle2D rectangle2D = new Rectangle2D.Double(a2.q(), d, a2.r() - a2.q(), d2 - d).getBounds();
            double d3 = a2.p().stream().mapToDouble(drawableElement -> Math.max(drawableElement.getBounds().getMinY(), drawableElement.getBounds().getMaxY())).max().orElse(rectangle2D.getMaxY()) + a2.g() * 1.5;
            double d4 = a2.p().stream().mapToDouble(drawableElement -> LocationUtils.getNormedBounds((HasBounds)drawableElement).getY()).min().orElse(rectangle2D.getY());
            if (d3 < rectangle2D.getMaxY()) {
                rectangle2D = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), d3 - rectangle2D.getY());
            }
            if (d4 > rectangle2D.getY() + a2.g() / 2.0) {
                rectangle2D = new Rectangle2D.Double(rectangle2D.getX(), d4, rectangle2D.getWidth(), rectangle2D.getMaxY() - d4);
            }
            arrayList.add(new a(rectangle2D, a2.p(), a2.o(), n, a2.n()));
        }
        return arrayList;
    }

    private boolean a(Paint paint) {
        if (paint instanceof Color) {
            Color color = (Color)paint;
            if (color.getAlpha() < 5) {
                return false;
            }
            if (Color.WHITE.equals(color)) {
                return false;
            }
        }
        return paint != null;
    }

    private void a(List<DrawableElement> list, List<c> list2) {
        for (c c2 : list2) {
            c2.c(list);
        }
    }

    private b[] a(List<DrawableElement> list, double d, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2;
        if (list.size() < 10) {
            return new b[0];
        }
        if (rectangle2D == null) {
            return new b[0];
        }
        double d2 = rectangle2D.getWidth() * 2.0 / 3.0 + 0.001;
        HashSet<b> hashSet = new HashSet<b>();
        for (DrawableElement object : list) {
            switch (object.getType()) {
                case Shape: {
                    rectangle2D2 = object.getBounds();
                    rectangle2D2 = object.getBounds();
                    if (!(rectangle2D2.getWidth() > d2)) break;
                    double d3 = Math.max(rectangle2D2.getMinX(), rectangle2D.getMinX());
                    double d4 = Math.min(rectangle2D2.getMaxX(), rectangle2D.getMaxX());
                    if (!(d4 - d3 > d2)) break;
                    if (rectangle2D2.getHeight() < 12.0) {
                        hashSet.add(new b(rectangle2D2.getCenterY()).e(object));
                        break;
                    }
                    hashSet.add(new b(rectangle2D2.getMinY()).e(object));
                    hashSet.add(new b(rectangle2D2.getMaxY()).e(object));
                    break;
                }
                case Image: 
                case LineHorizontal: {
                    rectangle2D2 = object.getBounds();
                    if (!(rectangle2D2.getWidth() > d2)) break;
                    double d3 = Math.max(rectangle2D2.getMinX(), rectangle2D.getMinX());
                    double d4 = Math.min(rectangle2D2.getMaxX(), rectangle2D.getMaxX());
                    if (!(d4 - d3 > d2)) break;
                    hashSet.add(new b(rectangle2D2.getCenterY()).e(object));
                    break;
                }
            }
        }
        Object[] objectArray = hashSet.toArray(new b[hashSet.size()]);
        Arrays.sort(objectArray);
        if (objectArray.length > 0) {
            Object object = objectArray[objectArray.length - 1];
            rectangle2D2 = LocationUtils.getNormedBounds((HasBounds)((HasBounds)list.get(list.size() - 1)));
            if (rectangle2D2.getMaxY() <= ((b)object).e().get(0).getMaxY()) {
                hashSet.remove(object);
                objectArray = hashSet.toArray(new b[hashSet.size()]);
                Arrays.sort(objectArray);
            }
        }
        return objectArray;
    }

    private b[] b(List<DrawableElement> list, double d, Rectangle2D rectangle2D2) {
        Cloneable cloneable;
        if (list.size() < 10) {
            return new b[0];
        }
        if (rectangle2D2 == null) {
            return new b[0];
        }
        double d2 = rectangle2D2.getHeight() / 10.0;
        ArrayList<b> arrayList = new ArrayList<b>();
        for (DrawableElement object2 : list) {
            switch (object2.getType()) {
                case Shape: {
                    cloneable = object2.getBounds();
                    if (((RectangularShape)cloneable).getWidth() < ((RectangularShape)cloneable).getHeight() * 10.0) break;
                }
                case Image: {
                    if (object2.getBounds().getWidth() > 10.0) break;
                }
                case LineVertical: {
                    if (object2.getStrokePaint() == null && object2.getType() != ElementType.Image || !(((RectangularShape)(cloneable = object2.getBounds())).getHeight() > d2)) break;
                    double iterator = Math.max(((RectangularShape)cloneable).getMinY(), rectangle2D2.getMinY());
                    double b3 = Math.min(((RectangularShape)cloneable).getMaxY(), rectangle2D2.getMaxY());
                    if (!(b3 - iterator > d2)) break;
                    arrayList.add(new b(((RectangularShape)cloneable).getCenterX()).e(object2));
                    break;
                }
            }
        }
        RattleSort rattleSort = new RattleSort(b2 -> b2.k);
        List list2 = rattleSort.sort(arrayList, 2);
        cloneable = new ArrayList();
        for (Sample sample : list2) {
            b b3 = new b(sample.doubleValue());
            sample.getOccurrences().stream().flatMap(b2 -> b2.l.stream()).forEach(rectangle2D -> b2.l.add((Rectangle2D)rectangle2D));
            cloneable.add(b3);
        }
        return cloneable.toArray(new b[cloneable.size()]);
    }

    protected Rectangle2D getTextBounds(List<DrawableElement> elements) {
        Rectangle2D rectangle2D = null;
        for (DrawableElement drawableElement : elements) {
            if (drawableElement.getType() != ElementType.TextWord) continue;
            if (rectangle2D == null) {
                rectangle2D = LocationUtils.getNormedBounds((HasBounds)drawableElement);
                continue;
            }
            Rectangle2D.union(rectangle2D, LocationUtils.getNormedBounds((HasBounds)drawableElement), rectangle2D);
        }
        return rectangle2D;
    }

    private static void a(Set<DrawableElement> set, List<c> list, b[] bArray) {
        for (int i = 0; i < list.size(); ++i) {
            c c2 = list.get(i);
            if (c2.j() > 1) {
                for (int j = 0; j < c2.m.size(); ++j) {
                    a a2 = c2.m.get(j);
                    if (!a2.a() || c2.j() <= 1) continue;
                    a a3 = j > 0 ? c2.m.get(j - 1) : c2.m.get(j + 1);
                    a3.a(a2, true);
                    c2.m.remove(j);
                    --j;
                }
            }
            if (i <= 0) continue;
            c c3 = list.get(i - 1);
            if (!c2.i() && c3.a(c2, true, set, bArray)) {
                list.remove(i);
                --i;
                continue;
            }
            if (c2.j() != 1 || c3.j() != 1) continue;
            c3.h().get(0).a(c2.h().get(0), true);
            list.remove(i);
            --i;
        }
    }

    private static boolean a(Set<DrawableElement> set, List<c> list) {
        c c2;
        int n;
        boolean bl = false;
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            c2 = list.get(n);
            if (c2.j() <= 3 && c2.i()) continue;
            n2 = Math.max(n2, c2.j());
        }
        if (n2 <= 1) {
            return false;
        }
        for (n = 0; n < list.size(); ++n) {
            c2 = list.get(n);
            if (c2.j() <= 3 && c2.i() || c2.j() != n2) continue;
            c2.m();
            bl = true;
        }
        if (bl) {
            MultiColumnFilter.b(set, list);
        }
        return bl;
    }

    private static boolean b(Set<DrawableElement> set, List<c> list, b[] bArray) {
        boolean bl = false;
        boolean bl2 = false;
        do {
            bl2 = false;
            MultiColumnFilter.b(set, list);
            for (int i = 0; i < list.size() - 1; ++i) {
                boolean bl3;
                c c2 = i > 0 ? list.get(i - 1) : null;
                c c3 = list.get(i);
                c c4 = list.get(i + 1);
                c c5 = MultiColumnFilter.a(c2, c3, bArray);
                c c6 = MultiColumnFilter.a(c3, c4, bArray);
                boolean bl4 = c5 != null && c5.j() > 1 && (c5.i() || MultiColumnFilter.a(c2, c3, c5));
                boolean bl5 = bl3 = c6 != null && c6.j() > 1 && (c6.i() || MultiColumnFilter.a(c3, c4, c6));
                if (!bl4 && !bl3) continue;
                if (bl4 && bl3) {
                    if (c6.j() > c5.j()) {
                        c6.a(set);
                        list.set(i + 1, c6);
                    } else {
                        c5.a(set);
                        list.set(i - 1, c5);
                    }
                } else if (bl3) {
                    c6.a(set);
                    list.set(i + 1, c6);
                } else {
                    c5.a(set);
                    list.set(i - 1, c5);
                }
                list.remove(i);
                --i;
                bl2 = true;
            }
            if (!bl2) continue;
            bl = true;
        } while (bl2);
        if (bl2) {
            MultiColumnFilter.b(set, list);
        }
        return bl;
    }

    private static boolean a(c c2, c c3, c c4) {
        Rectangle2D rectangle2D;
        Rectangle2D rectangle2D2;
        int n;
        boolean bl;
        if (c4 == null || c2.j() < 2 || c3.j() < 2) {
            return false;
        }
        int n2 = c4.j();
        if (c4.j() == c2.j()) {
            bl = true;
            for (n = 0; n < n2; ++n) {
                rectangle2D2 = c2.h().get((int)n).c;
                rectangle2D = c4.h().get((int)n).c;
                if (!(rectangle2D.getMinX() < rectangle2D2.getMinX() - 1.0) && !(rectangle2D.getMaxX() > rectangle2D2.getMaxX() + 1.0)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return true;
            }
        }
        if (c4.j() == c3.j()) {
            bl = true;
            for (n = 0; n < n2; ++n) {
                rectangle2D2 = c3.h().get((int)n).c;
                rectangle2D = c4.h().get((int)n).c;
                if (!(rectangle2D.getMinX() < rectangle2D2.getMinX() - 1.0) && !(rectangle2D.getMaxX() > rectangle2D2.getMaxX() + 1.0)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    private static boolean c(Set<DrawableElement> set, List<c> list, b[] bArray) {
        boolean bl = false;
        boolean bl2 = true;
        do {
            bl2 = false;
            MultiColumnFilter.b(set, list);
            for (int i = 0; i < list.size() - 1; ++i) {
                c c2 = list.get(i);
                c c3 = list.get(i + 1);
                boolean bl3 = c2.i();
                if (c2.j() <= 3 && c2.j() != c3.j() && bl3 || !c3.a(c2, !bl3, set, bArray)) continue;
                list.remove(i);
                --i;
                bl2 = true;
                bl = true;
            }
        } while (bl2);
        if (bl2) {
            MultiColumnFilter.b(set, list);
        }
        return bl;
    }

    private static c a(c c2, c c3, b[] bArray) {
        if (c2 == null || c3 == null || !c2.b(c3)) {
            return null;
        }
        if ((c2.i() || c3.i()) && b.a(c2.c.getMaxY(), c3.c.getMinY(), bArray)) {
            return null;
        }
        ArrayList<a> arrayList = new ArrayList<a>(c2.h());
        arrayList.addAll(c3.h());
        Collections.sort(arrayList, (a2, a3) -> Double.compare(a2.c.getX(), a3.c.getX()));
        ArrayList<a> arrayList2 = new ArrayList<a>();
        a a4 = null;
        for (a a5 : arrayList) {
            if (a4 == null || a5.c.getX() > a4.c.getMaxX()) {
                a4 = a5.c();
                arrayList2.add(a4);
                continue;
            }
            a4.a(a5, false);
        }
        c c4 = new c(arrayList2);
        c4.a(c2.n & c3.n);
        return c4;
    }

    private static void b(Set<DrawableElement> set, List<c> list) {
        list.forEach(c2 -> c2.a(set));
    }

    private static void a(Set<DrawableElement> set, a a2) {
        Iterator<DrawableElement> iterator = set.iterator();
        while (iterator.hasNext()) {
            DrawableElement drawableElement = iterator.next();
            Rectangle rectangle = LocationUtils.getBounds((HasBounds)drawableElement);
            if (!a2.c.intersects(rectangle)) continue;
            iterator.remove();
            a2.c(drawableElement);
        }
    }

    public static boolean isDetectionType(DrawableElement e) {
        switch (e.getType()) {
            case Text: 
            case TextWord: {
                return e.getRotation() == 0.0 || e.getRotation() == Math.PI;
            }
            case Paragraph: 
            case TextLine: {
                return !(Math.abs(e.getBounds().getWidth()) < Math.abs(e.getBounds().getHeight()));
            }
            case Image: {
                return true;
            }
        }
        return false;
    }

    public static double getEnd(Rectangle2D bounds, boolean vertical) {
        if (vertical) {
            return LocationUtils.getMaxY((Rectangle2D)bounds) + Math.abs(bounds.getHeight()) / 1.1;
        }
        return LocationUtils.getMaxX((Rectangle2D)bounds) + Math.abs(bounds.getHeight()) / 2.0;
    }

    private static a a(List<a> list, Rectangle rectangle) {
        double d = -1.0;
        a a2 = null;
        for (a a3 : list) {
            double d2;
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            Rectangle2D.intersect(a3.c, rectangle, double_);
            if (!(((RectangularShape)double_).getWidth() > 0.0) || !((d2 = ((RectangularShape)double_).getWidth() * ((RectangularShape)double_).getHeight()) > d)) continue;
            d = d2;
            a2 = a3;
        }
        if (a2 == null) {
            double d3 = 1000000.0;
            for (a a4 : list) {
                int n;
                int n2 = (double)(rectangle.x + rectangle.width) < a4.c.getX() ? -1 : (n = (double)rectangle.x > a4.c.getMaxX() ? 1 : 0);
                int n3 = (double)(rectangle.y + rectangle.height) < a4.c.getY() ? -1 : ((double)rectangle.y > a4.c.getMaxY() ? 1 : 0);
                double d4 = switch (n3) {
                    case -1 -> {
                        switch (n) {
                            case -1: {
                                yield Point.distance(rectangle.getMaxX(), rectangle.getMaxY(), a4.c.getMinX(), a4.c.getMinY());
                            }
                            case 0: {
                                yield a4.c.getMinY() - rectangle.getMaxY();
                            }
                        }
                        yield Point.distance(rectangle.getMinX(), rectangle.getMaxY(), a4.c.getMaxX(), a4.c.getMinY());
                    }
                    case 0 -> {
                        switch (n) {
                            case -1: {
                                yield a4.c.getMinX() - rectangle.getMaxX();
                            }
                            case 1: {
                                yield rectangle.getMinX() - a4.c.getMaxX();
                            }
                        }
                        yield 0.0;
                    }
                    default -> {
                        switch (n) {
                            case -1: {
                                yield Point.distance(rectangle.getMaxX(), rectangle.getMinY(), a4.c.getMinX(), a4.c.getMaxY());
                            }
                            case 0: {
                                yield rectangle.getMinY() - a4.c.getMaxY();
                            }
                        }
                        yield Point.distance(rectangle.getMinX(), rectangle.getMinY(), a4.c.getMaxX(), a4.c.getMaxY());
                    }
                };
                if (!(d4 < d3)) continue;
                a2 = a4;
                d3 = d4;
            }
        }
        return a2;
    }

    public MultiColHighlightData getHighlightProvider() {
        return this.a;
    }

    @JsonData
    private static class MultiColHighlightData
    extends BasicHighlightDataImpl {
        public MultiColHighlightData() {
            super("MULTICOLUMN");
        }

        public void addHighlightDataForCurrentPage(boolean first, List<a> columns, int pageIndex) {
            ArrayList<HighlightData.Highlight> arrayList = new ArrayList<HighlightData.Highlight>();
            int n = 1;
            for (a a2 : columns) {
                Rectangle rectangle = a2.c.getBounds();
                arrayList.add(new HighlightData.Highlight(rectangle.x, rectangle.y, rectangle.width, rectangle.height, "Column " + n++, HighlightData.Highlight.Appearance.RECTANGLE, OUTLINE_COLOR));
            }
            HashMap hashMap = first ? this.getFirst() : this.getSecond();
            hashMap.put(pageIndex, arrayList);
        }
    }

    public static class b
    implements Comparable<b> {
        private double k;
        private List<Rectangle2D> l = new ArrayList<Rectangle2D>();

        public b(double d) {
            this.k = d;
        }

        public b e(DrawableElement drawableElement) {
            this.l.add(LocationUtils.getNormedBounds((HasBounds)drawableElement));
            return this;
        }

        public boolean equals(Object obj) {
            return obj instanceof b && ((b)obj).k == this.k;
        }

        public int hashCode() {
            return Double.hashCode(this.k);
        }

        public int c(b b2) {
            return Double.compare(this.k, b2.d());
        }

        public double d() {
            return this.k;
        }

        public List<Rectangle2D> e() {
            return this.l;
        }

        public static b a(double d, b[] bArray, boolean bl) {
            int n = Arrays.binarySearch(bArray, new b(d));
            if (n >= 0) {
                return bArray[n];
            }
            if ((n = -(n + 1) + (bl ? -1 : 0)) < 0) {
                return new b(0.0);
            }
            if (n >= bArray.length) {
                return new b(1.073741823E9);
            }
            return bArray[n];
        }

        public static boolean a(double d, double d2, b[] bArray) {
            int n;
            int n2 = Arrays.binarySearch(bArray, new b(d));
            return n2 != (n = Arrays.binarySearch(bArray, new b(d2))) || n2 > 0;
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.c((b)object);
        }
    }

    private static class a {
        private Rectangle2D c;
        private Rectangle2D d;
        private List<DrawableElement> e;
        private double f;
        private double g = 0.0;
        private int h;
        private Boolean i;
        private boolean j;

        public a(Rectangle2D rectangle2D, List<DrawableElement> list, double d, int n, boolean bl) {
            this.c = rectangle2D;
            this.e = list;
            this.j = bl;
            this.d = com.inet.pdfc.filter.multicolumn.MultiColumnFilter$a.a(list);
            this.f = d;
            this.h = n;
            this.g += this.b(list);
        }

        private static Rectangle2D a(List<DrawableElement> list) {
            if (list.size() == 0) {
                return new Rectangle2D.Double();
            }
            double d = 2.147483647E9;
            double d2 = 2.147483647E9;
            double d3 = -2.147483648E9;
            double d4 = -2.147483648E9;
            for (DrawableElement drawableElement : list) {
                double d5 = drawableElement.getX();
                double d6 = drawableElement.getY();
                d = d5 < d ? d5 : d;
                d2 = d6 < d2 ? d6 : d2;
                d3 = d5 > d3 ? d5 : d3;
                d4 = d6 > d4 ? d6 : d4;
            }
            return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        }

        private a() {
        }

        public boolean a() {
            return !this.e.stream().filter(drawableElement -> drawableElement.getType() != ElementType.Image).findAny().isPresent();
        }

        public void c(DrawableElement drawableElement) {
            Rectangle2D rectangle2D = LocationUtils.getNormedBounds((HasBounds)drawableElement);
            this.g += rectangle2D.getWidth() * rectangle2D.getHeight();
            this.e.add(drawableElement);
        }

        private double b(List<DrawableElement> list) {
            double d = 0.0;
            for (DrawableElement drawableElement : list) {
                Rectangle rectangle = LocationUtils.getBounds((Rectangle2D)drawableElement.getBounds());
                d += Math.abs(((RectangularShape)rectangle).getWidth() * ((RectangularShape)rectangle).getHeight());
            }
            return d;
        }

        public void a(a a2, boolean bl) {
            if (bl && !a2.j && !a2.a()) {
                this.i = Boolean.FALSE;
            }
            if (this.i != null || a2.i != null) {
                if (this.i == Boolean.FALSE || a2.i == Boolean.FALSE) {
                    this.i = Boolean.FALSE;
                }
                if (this.i == Boolean.TRUE && a2.i == Boolean.TRUE) {
                    this.i = Boolean.TRUE;
                }
            }
            Rectangle2D.union(this.c, a2.c, this.c);
            Rectangle2D.union(this.d, a2.d, this.d);
            this.e.addAll(a2.e);
            this.f = Math.max(this.f, a2.f);
            this.g += a2.g;
        }

        public boolean b() {
            if (this.i != null) {
                return this.i;
            }
            if (this.c.getHeight() < this.f * 4.0) {
                return false;
            }
            if (this.c.getWidth() < (double)this.h * 0.25) {
                return false;
            }
            return this.g * 4.75 > this.c.getWidth() * this.c.getHeight();
        }

        public String toString() {
            return "col " + this.c.toString().substring(this.c.getClass().getName().length()) + ", #" + this.e.size() + ", " + (this.b() ? "valid" : (Boolean.FALSE == this.i ? "VERY INVALID" : "INVALID"));
        }

        public void a(a a2) {
            this.c = a2.c;
            this.d = a2.d;
            this.e = a2.e;
            this.f = a2.f;
            this.g = a2.g;
            this.h = a2.h;
        }

        public a c() {
            a a2 = new a();
            a2.c = this.c.getBounds();
            a2.d = this.d.getBounds();
            a2.e = new ArrayList<DrawableElement>(this.e);
            a2.f = this.f;
            a2.g = this.g;
            a2.h = this.h;
            a2.j = this.j;
            a2.i = this.i;
            return a2;
        }
    }

    private static class c {
        private List<a> m;
        private Rectangle2D c;
        private boolean n = true;

        public c(List<a> list) {
            this.m = list;
            this.f();
        }

        private void f() {
            this.c = null;
            for (a a2 : this.m) {
                if (this.c == null) {
                    this.c = LocationUtils.getJoinedBounds(a2.e);
                } else {
                    Rectangle2D.union(this.c, LocationUtils.getJoinedBounds(a2.e), this.c);
                }
                a2.d = com.inet.pdfc.filter.multicolumn.MultiColumnFilter$a.a(a2.e);
            }
        }

        public double g() {
            return this.m.stream().mapToDouble(a2 -> a2.f).max().getAsDouble();
        }

        public List<a> h() {
            return this.m;
        }

        public void a(boolean bl) {
            this.n = bl;
        }

        public boolean i() {
            return this.m.size() <= 3 && !this.m.stream().filter(a2 -> !a2.b()).findAny().isPresent();
        }

        public int j() {
            return this.m.size();
        }

        public void k() {
            a a2 = this.m.get(0);
            for (int i = 1; i < this.m.size(); ++i) {
                a2.a(this.m.get(i), true);
            }
            this.m.clear();
            this.m.add(a2);
        }

        public void l() {
            for (int i = 1; i < this.m.size(); ++i) {
                a a2 = this.m.get(i - 1);
                a a3 = this.m.get(i);
                double d = a2.c.getMaxX();
                double d2 = a3.c.getMinX();
                if (!(d2 > d)) continue;
                double d3 = (d2 - d) / 2.0;
                a2.c = new Rectangle2D.Double(a2.c.getX(), a2.c.getY(), a2.c.getWidth() + d3, a2.c.getHeight());
                a3.c = new Rectangle2D.Double(a3.c.getX() - d3, a3.c.getY(), a3.c.getWidth() + d3, a3.c.getHeight());
            }
        }

        public boolean c(List<DrawableElement> list) {
            boolean bl = false;
            for (int i = 1; i < this.m.size(); ++i) {
                a a2;
                a a3 = this.m.get(i - 1);
                if (!this.a(a3, a2 = this.m.get(i), list)) continue;
                a3.a(a2, true);
                this.m.remove(i--);
                bl = true;
            }
            for (a a3 : this.m) {
                bl |= this.a(a3, list, true);
                bl |= this.a(a3, list, false);
            }
            return bl;
        }

        private boolean a(a a2, List<DrawableElement> list, boolean bl) {
            int n;
            Rectangle2D rectangle2D = bl ? a2.c : a2.d;
            int n2 = SorterUtils.findIndex((double)rectangle2D.getMinX(), (double)rectangle2D.getMinY(), list, (boolean)false);
            int n3 = SorterUtils.findIndex((double)rectangle2D.getMaxX(), (double)rectangle2D.getMaxX(), list, (boolean)true);
            double d = rectangle2D.getMinX();
            double d2 = rectangle2D.getMaxX();
            double d3 = rectangle2D.getMinY();
            double d4 = rectangle2D.getMaxY();
            for (n = n2; n < n3; n += 1) {
                Rectangle2D rectangle2D2;
                DrawableElement drawableElement = list.get(n);
                if (drawableElement.getType() != ElementType.LineHorizontal) continue;
                LineShape lineShape = (LineShape)drawableElement;
                if (bl && lineShape.getStrokePaint() == null || !bl && lineShape.getFillPaint() == null || (rectangle2D2 = LocationUtils.getNormedBounds((HasBounds)drawableElement)).getMaxX() < rectangle2D.getMinX() || rectangle2D2.getMinX() > rectangle2D.getMaxX() || rectangle2D2.getMaxY() < d3 || rectangle2D2.getMinY() > d4) continue;
                d = Math.min(rectangle2D2.getMinX(), d);
                d2 = Math.max(rectangle2D2.getMaxX(), d2);
            }
            int n4 = n = d < rectangle2D.getMinX() || d2 > rectangle2D.getMaxX() ? 1 : 0;
            if (n) {
                a2.c = new Rectangle2D.Double(d, a2.c.getMinY(), d2 - d, a2.c.getHeight()).getBounds();
            }
            return n != 0;
        }

        private boolean a(a a2, a a3, List<DrawableElement> list) {
            double d = a2.c.getMaxX();
            double d2 = a3.c.getMinX();
            double d3 = a2.c.getMinY() + Math.min(a2.f / 3.0, a3.f / 2.0);
            double d4 = Math.max(a2.c.getMaxY(), a3.c.getMaxY());
            double d5 = a2.d.getMaxX();
            double d6 = a3.d.getMinX();
            double d7 = a2.d.getMinY();
            double d8 = Math.max(a2.d.getMaxY(), a3.d.getMaxY());
            int n = SorterUtils.findIndex((double)d, (double)d3, list, (boolean)false);
            int n2 = SorterUtils.findIndex((double)d2, (double)d4, list, (boolean)true);
            n2 = Math.min(n2, list.size() - 1);
            for (int i = n; i <= n2; ++i) {
                DrawableElement drawableElement = list.get(i);
                Rectangle2D rectangle2D = drawableElement.getBounds();
                if (drawableElement instanceof GeomShape && ((GeomShape)drawableElement).getFillPaint() != null) {
                    if (!(rectangle2D.getMaxY() <= d8) || !(rectangle2D.getMinY() >= d7) || !(rectangle2D.getMinX() < d5) || !(rectangle2D.getMaxX() > d6)) continue;
                    return true;
                }
                double d9 = rectangle2D.getMaxY();
                if (!(rectangle2D.getMaxY() <= d4) || !(rectangle2D.getMinY() >= d3) || !(rectangle2D.getMinX() < d) || !(rectangle2D.getMaxX() > d2) || drawableElement.getType() == ElementType.LineHorizontal && d9 > d8 && rectangle2D.getMinX() > a2.d.getMinX() - 0.01) continue;
                return true;
            }
            return false;
        }

        public void m() {
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            int n3 = Integer.MAX_VALUE;
            int n4 = -1;
            for (int i = 1; i < this.m.size(); ++i) {
                a a2 = this.m.get(i);
                a a3 = this.m.get(i - 1);
                int n5 = (int)a2.c.getMaxX() - (int)a3.c.getMinX();
                if (a2.j) {
                    if (n5 >= n3) continue;
                    n4 = i - 1;
                    n3 = n5;
                    continue;
                }
                if (n5 >= n) continue;
                n2 = i - 1;
                n = n5;
            }
            if (n4 >= 0) {
                this.m.get(n4).a(this.m.get(n4 + 1), true);
                this.m.remove(n4 + 1);
            } else {
                this.m.get(n2).a(this.m.get(n2 + 1), true);
                this.m.remove(n2 + 1);
            }
        }

        public void a(Set<DrawableElement> set) {
            Iterator<DrawableElement> iterator = set.iterator();
            block0: while (iterator.hasNext()) {
                DrawableElement drawableElement = iterator.next();
                Rectangle rectangle = LocationUtils.getBounds((HasBounds)drawableElement);
                for (a a2 : this.m) {
                    if (!a2.c.contains(rectangle)) continue;
                    iterator.remove();
                    a2.c(drawableElement);
                    continue block0;
                }
            }
        }

        public boolean b(c c2) {
            double d;
            c c3;
            c c4 = this.c.getY() < c2.c.getY() ? this : c2;
            c c5 = c3 = c4 == this ? c2 : this;
            if (!c3.n) {
                return false;
            }
            double d2 = c3.c.getMinY() - c4.c.getMaxY();
            if (d2 < 0.0) {
                return true;
            }
            double d3 = c4.m.stream().mapToDouble(a2 -> a2.f).max().getAsDouble();
            return d2 < (d3 + (d = c3.m.stream().mapToDouble(a2 -> a2.f).max().getAsDouble())) * 3.0;
        }

        public boolean a(c c2, boolean bl, Set<DrawableElement> set, b[] bArray) {
            double d;
            if (!bl && this.m.size() < c2.j()) {
                return false;
            }
            if (!this.b(c2)) {
                return false;
            }
            if ((this.i() || c2.i()) && b.a(this.c.getMaxY(), c2.c.getMinY(), bArray)) {
                return false;
            }
            LinkedHashMap<a, List<a>> linkedHashMap = new LinkedHashMap<a, List<a>>();
            this.m.forEach(a2 -> linkedHashMap.put((a)a2, new ArrayList()));
            boolean bl2 = true;
            block0: for (a a3 : c2.m) {
                double d2 = a3.c.getMinX();
                d = a3.c.getMaxX();
                int n = 0;
                for (a object : this.m) {
                    double d3 = object.c.getMinX();
                    double d4 = object.c.getMaxX();
                    if (!(d2 <= d4) || !(d >= d3)) continue;
                    List list = (List)linkedHashMap.get(object);
                    if (list.size() > 0) {
                        bl2 = false;
                        break block0;
                    }
                    list.add(a3);
                    ++n;
                }
                if (n == true) continue;
                bl2 = false;
                break;
            }
            double d5 = this.c.getMinY();
            if (bl2 && (bl2 = this.a(linkedHashMap, set))) {
                if (c2.c.getMinY() < d5) {
                    this.n = c2.n;
                }
                return true;
            }
            if (!bl2) {
                if (this.m.size() == 1 && c2.m.size() > 1) {
                    return false;
                }
                linkedHashMap.clear();
                this.m.forEach(a2 -> linkedHashMap.put((a)a2, new ArrayList()));
                block2: for (a a3 : c2.m) {
                    d = a3.c.getMinX() + 1.0;
                    double d6 = a3.c.getMaxX() - 1.0;
                    for (a a4 : this.m) {
                        if (!(d > a4.c.getMinX()) || !(d6 < a4.c.getMaxX())) continue;
                        ((List)linkedHashMap.get(a4)).add(a3);
                        continue block2;
                    }
                    return false;
                }
            }
            if ((bl2 = this.a(linkedHashMap, set)) && c2.c.getMinY() < d5) {
                this.n = c2.n;
            }
            return bl2;
        }

        private boolean a(Map<a, List<a>> map, Set<DrawableElement> set) {
            HashMap<a, a> hashMap = new HashMap<a, a>();
            HashSet<DrawableElement> hashSet = new HashSet<DrawableElement>(set);
            for (Map.Entry<a, List<a>> entry : map.entrySet()) {
                a a2 = entry.getKey().c();
                boolean bl = a2.b();
                boolean bl2 = true;
                for (a a3 : entry.getValue()) {
                    bl2 &= a3.b();
                    a2.a(a3, true);
                }
                MultiColumnFilter.a(hashSet, a2);
                if ((bl || bl2) && !a2.b()) {
                    set.clear();
                    set.addAll(hashSet);
                    return false;
                }
                hashMap.put(entry.getKey(), a2);
            }
            for (Map.Entry<a, List<a>> entry : hashMap.entrySet()) {
                entry.getKey().a((a)((Object)entry.getValue()));
            }
            this.f();
            return true;
        }
    }
}

