/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.filter.invisibleelements;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.TextStyleType;
import com.inet.pdfc.filter.invisibleelements.InvisibleElementsPlugin;
import com.inet.pdfc.filter.invisibleelements.a;
import com.inet.pdfc.generator.comparator.ElementComparatorFactory;
import com.inet.pdfc.generator.comparator.IElementComparator;
import com.inet.pdfc.generator.continuous.structure.StructureElement;
import com.inet.pdfc.generator.filter.ISortFilter;
import com.inet.pdfc.generator.filter.SortFilterBase;
import com.inet.pdfc.generator.message.BasicHighlightDataImpl;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.model.forms.LineShape;
import com.inet.pdfc.generator.resultfilter.IResultFilter;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementComparator;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.HasBounds;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.model.ShapeElement;
import com.inet.pdfc.model.TextElement;
import com.inet.pdfc.util.ElementSearch;
import com.inet.pdfc.util.LocationUtils;
import com.inet.pdfc.util.Pair;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@InternalApi
public class InvisibleObjectsFilter
extends SortFilterBase
implements IResultFilter {
    public static final Color OUTLINE = new Color(0, 0, 192, 128);
    private static final String n = String.valueOf(TextStyleType.FONT) + "," + String.valueOf(TextStyleType.SIZE) + "," + String.valueOf(TextStyleType.STYLES) + "," + String.valueOf(TextStyleType.COLOR);
    private static final DrawableElement o = new ShapeElement(true, 0, null, null, null, (Paint)OUTLINE, (Paint)OUTLINE, ElementID.DUMMY);
    private RemoveHighlights p = new RemoveHighlights();
    private Pair<Rectangle2D> q = new Pair();
    private Map<Integer, Pair<Rectangle>> r = new HashMap<Integer, Pair<Rectangle>>();
    private IElementComparator s;
    private boolean t;

    public InvisibleObjectsFilter() {
        super("INVISIBLEELEMENTS");
    }

    public ISortFilter setProfile(IProfile profile) {
        this.d();
        this.t = profile.getBool(InvisibleElementsPlugin.PROP_COMPUTE_CLIPPING);
        return this;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.d();
    }

    private void d() {
        DefaultProfile defaultProfile = new DefaultProfile();
        defaultProfile.putValue(PDFCProperty.CONTINUOUS_COMPARE, "STRICT");
        defaultProfile.putValue(PDFCProperty.TOLERANCE_TEXT_LOCATION, "1");
        defaultProfile.putValue(PDFCProperty.TOLERANCE_LINE_POSITION, "1");
        defaultProfile.putValue(PDFCProperty.TOLERANCE_LINE_SIZE, "0");
        defaultProfile.putValue(PDFCProperty.TOLERANCE_IMAGE_SIZE, "1");
        defaultProfile.putValue(PDFCProperty.TOLERANCE_IMAGE_PIXEL_VALUE, "0.01");
        defaultProfile.putValue(PDFCProperty.COMPARE_TEXT_CASE_SENSITIVE, "true");
        defaultProfile.putValue(PDFCProperty.COMPARE_TEXT_STYLES, n);
        defaultProfile.putValue(PDFCProperty.COMPARE_LINE_STYLES, "true");
        defaultProfile.putValue(PDFCProperty.TOLERANCE_COLOR, "0");
        this.s = ElementComparatorFactory.createComparator((IProfile)defaultProfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DrawableElement> sortOrFilterPage(int pageNr, List<DrawableElement> pageElements, boolean first, List<CompareDiffGroup> diffGroups) {
        Rectangle rectangle;
        this.q.set(first, null);
        Map<Integer, Pair<Rectangle>> map = this.r;
        synchronized (map) {
            rectangle = (Rectangle)this.r.get(pageNr).get(first);
        }
        if (this.t) {
            return new a().a(pageElements, rectangle);
        }
        return this.filter(pageNr, pageElements, first, rectangle, new HashMap<Rectangle, DrawableElement>());
    }

    protected List<DrawableElement> filter(int pageNr, List<DrawableElement> pageElements, boolean first, Rectangle pageSize, Map<Rectangle, DrawableElement> checkMap) {
        ArrayList<DrawableElement> arrayList = new ArrayList<DrawableElement>(pageElements.size());
        ElementSearch elementSearch = new ElementSearch((Rectangle2D)pageSize);
        elementSearch.addAll(pageElements);
        elementSearch.setSearchAreaTolerance(0.0);
        for (DrawableElement drawableElement : pageElements) {
            boolean bl;
            DrawableElement drawableElement2 = this.a(drawableElement, pageSize, first, checkMap, (ElementSearch<DrawableElement>)elementSearch);
            if (drawableElement2 == o) continue;
            if (drawableElement2 == null) {
                this.p.addMarker(drawableElement, pageNr, first);
                continue;
            }
            Rectangle2D rectangle2D = drawableElement.getBounds();
            Rectangle rectangle = rectangle2D.getBounds();
            DrawableElement drawableElement3 = checkMap.get(rectangle);
            boolean bl2 = bl = drawableElement.getType() == ElementType.Annotation || drawableElement3 == null || !this.c(drawableElement3, drawableElement) || !rectangle2D.equals(drawableElement3.getBounds()) && drawableElement.getType() != ElementType.Text;
            if (bl) {
                if (drawableElement instanceof TextElement) {
                    ((TextElement)drawableElement).setClip((Rectangle2D)this.q.get(first));
                }
                arrayList.add(drawableElement);
                checkMap.put(rectangle, drawableElement);
                continue;
            }
            this.p.addMarker(drawableElement, pageNr, first);
        }
        return arrayList;
    }

    private boolean c(DrawableElement drawableElement, DrawableElement drawableElement2) {
        if (drawableElement == null || drawableElement2 == null || drawableElement.getType() != drawableElement2.getType()) {
            return false;
        }
        switch (drawableElement.getType()) {
            case Image: {
                return false;
            }
            case Text: 
            case Shape: 
            case ControlCheckBox: 
            case ControlList: 
            case ControlSignature: 
            case ControlText: 
            case Annotation: {
                return ElementComparator.NOLOG_COMPARATOR.isSame(drawableElement, drawableElement2);
            }
        }
        return this.s.isEqual(drawableElement, drawableElement2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyze(int pageNr, Dimension size, List<DrawableElement> pageElements, boolean first) {
        Pair pair;
        Integer n = pageNr;
        Map<Integer, Pair<Rectangle>> map = this.r;
        synchronized (map) {
            pair = this.r.get(n);
            if (pair == null) {
                pair = new Pair();
                this.r.put(n, (Pair<Rectangle>)pair);
            }
        }
        pair.set(first, (Object)new Rectangle(size));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private DrawableElement a(DrawableElement drawableElement, Rectangle rectangle, boolean bl, Map<Rectangle, DrawableElement> map, ElementSearch<DrawableElement> elementSearch) {
        Rectangle2D rectangle2D = this.f(drawableElement);
        if (drawableElement.getType() == ElementType.Shape && ((ShapeElement)drawableElement).getIsClip()) {
            this.q.set(bl, (Object)rectangle2D);
            return o;
        }
        if (rectangle2D == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = (Rectangle2D)this.q.get(bl);
        if (rectangle2D2 != null && !drawableElement.getType().isStructuralType() && !LocationUtils.intersects((Rectangle2D)rectangle2D, (Rectangle2D)rectangle2D2)) {
            return null;
        }
        if (drawableElement.getType() == ElementType.Annotation) {
            return drawableElement;
        }
        if (!LocationUtils.intersects((Rectangle2D)rectangle, (Rectangle2D)rectangle2D)) {
            return null;
        }
        if (drawableElement.getType().isStructuralType()) {
            List<DrawableElement> list = this.filter(drawableElement.getPageIndex(), ((StructureElement)drawableElement).getChildren(), bl, rectangle, map);
            if (list.size() > 0) {
                return new StructureElement(drawableElement.getType(), drawableElement.getBounds(), list, drawableElement.getPageIndex(), drawableElement.getElementID());
            }
            return null;
        }
        switch (drawableElement.getType()) {
            case Text: 
            case TextWord: {
                return drawableElement.getFillPaint() != null || drawableElement.getStrokePaint() != null ? drawableElement : null;
            }
            case Image: {
                if (rectangle2D.getWidth() <= 0.0 || rectangle2D.getHeight() <= 0.0) {
                    return null;
                }
                return drawableElement;
            }
            case ControlCheckBox: 
            case ControlSignature: 
            case ControlText: {
                return drawableElement;
            }
            case Shape: {
                Shape shape;
                boolean bl2;
                double d;
                double d2;
                if (rectangle2D2 != null) {
                    Rectangle2D.intersect(rectangle2D2, rectangle2D, rectangle2D);
                }
                if (Math.sqrt((d2 = rectangle2D.getWidth()) * d2 + (d = rectangle2D.getHeight()) * d) <= 0.9) {
                    return null;
                }
                if (d2 + d < 1.0) {
                    return null;
                }
                ShapeElement shapeElement = (ShapeElement)drawableElement;
                boolean bl3 = bl2 = shapeElement.getStrokePaint() != null && shapeElement.getStroke() != null && shapeElement.getStroke().getLineWidth() > 0.0f;
                if (!bl2 && shapeElement.getShape() != null) {
                    shape = new Area(shapeElement.getShape());
                    if (shapeElement.getStroke() == null && ((Area)shape).isEmpty()) {
                        return null;
                    }
                }
                if (Color.WHITE.equals(drawableElement.getFillPaint()) && !this.a(drawableElement.getStrokePaint()) || Color.WHITE.equals(drawableElement.getStrokePaint()) && !this.a(drawableElement.getFillPaint())) {
                    shape = drawableElement.getBounds();
                    if (((RectangularShape)shape).getY() <= 0.0 && ((RectangularShape)shape).getMaxY() >= rectangle.getHeight() || ((RectangularShape)shape).getX() <= 0.0 && ((RectangularShape)shape).getMaxX() >= rectangle.getWidth()) {
                        return null;
                    }
                    @Nonnull List list = elementSearch.getElementsInArea(rectangle2D);
                    boolean bl4 = true;
                    for (DrawableElement drawableElement2 : list) {
                        ShapeElement shapeElement2;
                        if (drawableElement2.getElementID().compareTo(drawableElement.getElementID()) >= 0 || !LocationUtils.intersects((Rectangle2D)rectangle2D, (Rectangle2D)this.f(drawableElement2)) || drawableElement2 instanceof ShapeElement && (shapeElement2 = (ShapeElement)drawableElement2).getIsClip() || this.a(drawableElement2, rectangle, bl, map, elementSearch) == null) continue;
                        bl4 = false;
                        break;
                    }
                    return bl4 ? null : drawableElement;
                }
                return !this.a(drawableElement.getFillPaint()) && !bl2 ? null : drawableElement;
            }
        }
        Paint paint = drawableElement.getFillPaint();
        Paint paint2 = drawableElement.getStrokePaint();
        if (this.a(paint) || this.a(paint2)) {
            return drawableElement;
        }
        return null;
    }

    private Rectangle2D f(DrawableElement drawableElement) {
        Rectangle2D rectangle2D = LocationUtils.getNormedBounds((HasBounds)drawableElement);
        if (rectangle2D == null) {
            return null;
        }
        if (rectangle2D.getHeight() == 0.0) {
            if (drawableElement.getType() == ElementType.Shape) {
                ShapeElement shapeElement = (ShapeElement)drawableElement;
                if (drawableElement.getStrokePaint() != null && shapeElement.getStroke() != null && shapeElement.getStroke().getLineWidth() > 0.0f) {
                    float f = shapeElement.getStroke().getLineWidth();
                    rectangle2D = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() - (double)(f / 2.0f), rectangle2D.getWidth(), f);
                }
            } else if (drawableElement.getType() == ElementType.LineHorizontal) {
                LineShape lineShape = (LineShape)drawableElement;
                if (drawableElement.getStrokePaint() != null && lineShape.getStroke() != null && lineShape.getStroke().getLineWidth() > 0.0f) {
                    float f = lineShape.getStroke().getLineWidth();
                    rectangle2D = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() - (double)(f / 2.0f), rectangle2D.getWidth(), f);
                }
            }
        } else if (rectangle2D.getWidth() == 0.0) {
            if (drawableElement.getType() == ElementType.Shape) {
                ShapeElement shapeElement = (ShapeElement)drawableElement;
                if (drawableElement.getStrokePaint() != null && shapeElement.getStroke() != null && shapeElement.getStroke().getLineWidth() > 0.0f) {
                    float f = shapeElement.getStroke().getLineWidth();
                    rectangle2D = new Rectangle2D.Double(rectangle2D.getX() - (double)(f / 2.0f), rectangle2D.getY(), f, rectangle2D.getHeight());
                }
            } else if (drawableElement.getType() == ElementType.LineVertical) {
                LineShape lineShape = (LineShape)drawableElement;
                if (drawableElement.getStrokePaint() != null && lineShape.getStroke() != null && lineShape.getStroke().getLineWidth() > 0.0f) {
                    float f = lineShape.getStroke().getLineWidth();
                    rectangle2D = new Rectangle2D.Double(rectangle2D.getX() - (double)(f / 2.0f), rectangle2D.getY(), f, rectangle2D.getHeight());
                }
            }
        }
        return rectangle2D;
    }

    private boolean a(Paint paint) {
        if (paint instanceof Color) {
            Color color = (Color)paint;
            if (color.getAlpha() < 5) {
                return false;
            }
            if (Color.WHITE.equals(color)) {
                return false;
            }
        }
        return paint != null;
    }

    public IResultFilter setResultFilterProfile(IProfile profile) {
        return this;
    }

    public List<CompareDiffGroup> filterResult(List<CompareDiffGroup> groups, boolean finalize) {
        if (groups == null || groups.isEmpty()) {
            return groups;
        }
        ArrayList<CompareDiffGroup> arrayList = new ArrayList<CompareDiffGroup>();
        block3: for (CompareDiffGroup compareDiffGroup : groups) {
            switch (compareDiffGroup.getType()) {
                case MetadataChanged: 
                case Modified: 
                case Sync: {
                    arrayList.add(compareDiffGroup);
                    continue block3;
                }
            }
            boolean bl = false;
            for (boolean bl2 : new boolean[]{true, false}) {
                for (Modification modification : compareDiffGroup.getModifications()) {
                    List list = modification.getAffectedElements(bl2);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        PagedElement pagedElement = (PagedElement)iterator.next();
                        if (!this.a(pagedElement)) continue;
                        iterator.remove();
                        bl = true;
                    }
                }
            }
            if (bl) {
                compareDiffGroup.resetCache();
            }
            if (compareDiffGroup.getAddedElements().size() <= 0 && compareDiffGroup.getRemovedElements().size() <= 0) continue;
            arrayList.add(compareDiffGroup);
        }
        return arrayList;
    }

    private boolean a(PagedElement pagedElement) {
        if (pagedElement.getType() != ElementType.Curve && pagedElement.getType().getBaseType() != ElementType.Line) {
            return false;
        }
        Rectangle2D rectangle2D = pagedElement.getBounds();
        return Math.sqrt(rectangle2D.getWidth() * rectangle2D.getWidth() + rectangle2D.getHeight() * rectangle2D.getHeight()) <= 0.9;
    }

    public RemoveHighlights getHighlightProvider() {
        return this.p;
    }

    @JsonData
    static class RemoveHighlights
    extends BasicHighlightDataImpl {
        public RemoveHighlights() {
            super("INVISIBLEELEMENTS");
        }

        public void addMarker(DrawableElement el, int page, boolean left) {
            Integer n;
            Rectangle rectangle = LocationUtils.getOutline((PagedElement)el);
            if (rectangle == null) {
                return;
            }
            HighlightData.Highlight highlight = new HighlightData.Highlight(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2, el.getType().name(), HighlightData.Highlight.Appearance.FILLED_RECTANGLE, OUTLINE);
            HashMap hashMap = left ? this.getFirst() : this.getSecond();
            ArrayList<HighlightData.Highlight> arrayList = (ArrayList<HighlightData.Highlight>)hashMap.get(n = Integer.valueOf(page));
            if (arrayList == null) {
                arrayList = new ArrayList<HighlightData.Highlight>();
                hashMap.put(n, arrayList);
            }
            arrayList.add(highlight);
        }
    }
}

