/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.filter.cmappatch;

import com.inet.annotations.JsonData;
import com.inet.pdfc.filter.cmappatch.CMapPatchPlugin;
import java.util.HashMap;
import java.util.Map;

@JsonData
public class MappedCharacter {
    private static final Integer ZERO = 0;
    public static final int UNKNOW = 61438;
    private double confidence = 0.0;
    private Integer characterMappedCodePoint = null;
    private Integer highConfidenceCharacterCodePoint = null;
    private int count = 0;
    private HashMap<Integer, Integer> characterCount = new HashMap();

    void setHighConfidenceMappedCharacter(Integer highConfidenceCharacterCodePoint) {
        this.highConfidenceCharacterCodePoint = highConfidenceCharacterCodePoint;
        this.confidence = 1.0;
    }

    public double getConfidence() {
        return this.confidence;
    }

    boolean characterHasMapValue() {
        return this.characterMappedCodePoint != null;
    }

    int getCharacterMappedCodePoint() {
        if (this.highConfidenceCharacterCodePoint != null) {
            return this.highConfidenceCharacterCodePoint;
        }
        if (this.characterMappedCodePoint == null) {
            return 61438;
        }
        int n = this.characterMappedCodePoint;
        int n2 = 0;
        for (Map.Entry<Integer, Integer> entry : this.characterCount.entrySet()) {
            int n3 = entry.getValue();
            if (n3 <= n2) continue;
            n = entry.getKey();
            n2 = n3;
        }
        return n;
    }

    void setCharacterMapped(int characterMappedCodePoint) {
        ++this.count;
        Integer n = characterMappedCodePoint;
        if (this.characterMappedCodePoint != null && this.characterMappedCodePoint != characterMappedCodePoint) {
            CMapPatchPlugin.LOGGER.debug((Object)("\tConfused (" + this.characterMappedCodePoint + ") vs (" + characterMappedCodePoint + ")"));
        } else {
            this.characterMappedCodePoint = n;
        }
        Integer n2 = this.characterCount.getOrDefault(n, ZERO);
        this.characterCount.put(n, n2 + 1);
        if (this.count > 10) {
            if (this.characterCount.size() == 1) {
                this.confidence = 1.0;
            } else {
                for (Integer n3 : this.characterCount.values()) {
                    double d2 = n3.doubleValue() / (double)this.count;
                    if (!(d2 > 0.8)) continue;
                    this.confidence = d2;
                }
            }
        }
    }

    String getAllCharacters() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer n : this.characterCount.keySet()) {
            stringBuilder.append(n).append(" '").append(new String(Character.toChars(n))).append("' (").append(this.characterCount.get(n)).append(");");
        }
        if (61438 == this.getCharacterMappedCodePoint()) {
            stringBuilder.append("( Unknown )");
        } else {
            stringBuilder.append("( choose: '").append(new String(Character.toChars(this.getCharacterMappedCodePoint()))).append("' )");
        }
        stringBuilder.append("Count: ").append(this.count);
        return stringBuilder.toString();
    }
}

