/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.filter.area;

import com.inet.annotations.JsonData;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.filter.area.FilterAreaPlugin;
import com.inet.pdfc.generator.filter.ISortFilter;
import com.inet.pdfc.generator.message.BasicHighlightDataImpl;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.ImageElement;
import com.inet.pdfc.plugin.ProfileHighlighter;
import com.inet.pdfc.util.FilterUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AreaSortFilter
implements ISortFilter,
ProfileHighlighter {
    public static final Color a = Color.GRAY;
    private boolean b = false;
    private HashSet<Area> filtedAreaForPage = new HashSet();
    private FilterHighlights c = new FilterHighlights();

    public ISortFilter setProfile(IProfile profile) {
        this.b = profile.getString(PDFCProperty.FILTERS).toLowerCase().contains("AREA".toLowerCase());
        this.filtedAreaForPage = this.a(profile.getString(FilterAreaPlugin.AREA).trim());
        this.c.setUpdateData(this.filtedAreaForPage);
        return this;
    }

    public void setTotalPages(int pageCount, boolean first) {
    }

    public void analyze(int pageNr, Dimension size, List<DrawableElement> pageElements, boolean first) {
    }

    public List<DrawableElement> sortOrFilterPage(int pageIndex, List<DrawableElement> pageElements, boolean first, @Nullable List<CompareDiffGroup> diffGroups) {
        if (this.b) {
            ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
            for (Area object : this.filtedAreaForPage) {
                if (object.getFirst() != null && object.getFirst() != first || object.getPageNumber() != -1 && object.getPageNumber() != pageIndex) continue;
                arrayList.add(object.getArea());
            }
            FilterAreaPlugin.LOGGER.debug((Object)FilterAreaPlugin.MSG.getMsg("pdfc.filter.debug", new Object[]{pageIndex + 1, FilterAreaPlugin.MSG.getMsg("pdfc.filter." + first, new Object[0]), arrayList.size()}));
            HashSet hashSet = new HashSet();
            for (Rectangle rectangle : arrayList) {
                for (DrawableElement drawableElement : pageElements) {
                    if (this.a(drawableElement, rectangle)) {
                        hashSet.add(drawableElement);
                        continue;
                    }
                    if (drawableElement.getType() != ElementType.Image) continue;
                    ImageElement imageElement = (ImageElement)drawableElement;
                    imageElement.setRenderClip(AreaSortFilter.a(imageElement.getRenderClip(), rectangle));
                }
            }
            pageElements.removeAll(hashSet);
        }
        return pageElements;
    }

    @Nullable
    public static Shape a(@Nullable Shape shape, @Nullable Shape shape2) {
        if (shape == null) {
            return null;
        }
        if (shape2 == null) {
            return shape;
        }
        java.awt.geom.Area area = new java.awt.geom.Area(shape);
        java.awt.geom.Area area2 = new java.awt.geom.Area(shape2);
        area.subtract(area2);
        Path2D.Double double_ = new Path2D.Double();
        ((Path2D)double_).append(area.getPathIterator(null), false);
        return double_;
    }

    private boolean a(DrawableElement drawableElement, Rectangle rectangle) {
        if (drawableElement.getBounds() == null) {
            return false;
        }
        double d = drawableElement.getX();
        double d2 = drawableElement.getY();
        double d3 = drawableElement.getBounds().getWidth();
        double d4 = drawableElement.getBounds().getHeight();
        if (d4 < 0.0) {
            d2 += d4;
            d4 = Math.abs(d4);
        }
        return rectangle.getX() <= d && rectangle.getX() + rectangle.getWidth() >= d + d3 && rectangle.getY() <= d2 && rectangle.getY() + rectangle.getHeight() >= d2 + d4;
    }

    public HighlightData getHighlightProvider() {
        return this.c;
    }

    public int getLookAheadWindowSize() {
        return 0;
    }

    public void setCurrentSyncOffset(int offset) {
    }

    public void reInit(IProfile profile) {
    }

    @Nonnull
    public String getExtensionName() {
        return "AREA";
    }

    public HighlightData getPageHighlight(IProfile profile, Object modelData) {
        this.b = profile.getString(PDFCProperty.FILTERS).toLowerCase().contains("AREA".toLowerCase());
        this.filtedAreaForPage = this.a(profile.getString(FilterAreaPlugin.AREA).trim());
        FilterHighlights filterHighlights = new FilterHighlights();
        filterHighlights.setUpdateData(this.filtedAreaForPage);
        filterHighlights.setColor(Color.RED);
        return filterHighlights;
    }

    public String getFilterKey() {
        return this.getExtensionName();
    }

    private HashSet<Area> a(String string) {
        HashSet<Area> hashSet = new HashSet<Area>();
        if (string.isEmpty()) {
            return hashSet;
        }
        if (FilterUtils.getErrorMessage((String)FilterAreaPlugin.AREA.name(), (String)string) == null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(";")) {
                int n;
                if (string2.trim().isEmpty()) continue;
                String[] stringArray2 = string2.split(",");
                int[] nArray = new int[4];
                for (n = 0; n < 4; ++n) {
                    if (stringArray2.length < n + 1 || stringArray2[n].trim().isEmpty()) continue;
                    nArray[n] = Integer.parseInt(stringArray2[n]);
                }
                n = -1;
                Boolean bl = null;
                for (int i = 4; i < stringArray2.length; ++i) {
                    String string3 = stringArray2[i].trim();
                    if (string3.isEmpty()) continue;
                    if (string3.equalsIgnoreCase("F")) {
                        bl = true;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("S")) {
                        bl = false;
                        continue;
                    }
                    if (!string3.matches("[0-9]+")) continue;
                    n = Integer.parseInt(string3) - 1;
                }
                hashSet.add(new Area(new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]), n, bl));
            }
        }
        return hashSet;
    }

    @JsonData
    private static class FilterHighlights
    extends BasicHighlightDataImpl {
        private Color outline = a;
        private HashSet<Area> filtedAreaForPage = new HashSet();

        public FilterHighlights() {
            super("AREA");
        }

        void setUpdateData(HashSet<Area> filtedAreaForPage) {
            this.filtedAreaForPage = filtedAreaForPage;
        }

        void setColor(Color color) {
            this.outline = color;
        }

        public List<HighlightData.Highlight> getPageHighlights(int pageNr, boolean firstDocument) {
            ArrayList<HighlightData.Highlight> arrayList = new ArrayList<HighlightData.Highlight>();
            ArrayList<Rectangle> arrayList2 = new ArrayList<Rectangle>();
            for (Area object : this.filtedAreaForPage) {
                if (object.getFirst() != null && object.getFirst() != firstDocument || object.getPageNumber() != -1 && object.getPageNumber() != pageNr) continue;
                arrayList2.add(object.getArea());
            }
            for (Rectangle rectangle : arrayList2) {
                arrayList.add(new HighlightData.Highlight(rectangle.x, rectangle.y, rectangle.width, rectangle.height, FilterAreaPlugin.MSG.getMsg("pdfc.filter.AREA", new Object[0]), HighlightData.Highlight.Appearance.FILLED_RECTANGLE, this.outline));
            }
            return arrayList;
        }
    }

    @JsonData
    private static class Area {
        private final Rectangle area;
        private final int pageNumber;
        private final Boolean isFirst;

        Rectangle getArea() {
            return this.area;
        }

        int getPageNumber() {
            return this.pageNumber;
        }

        Boolean getFirst() {
            return this.isFirst;
        }

        private Area(Rectangle area, int pageNumber, Boolean isFirst) {
            this.area = area;
            this.pageNumber = pageNumber;
            this.isFirst = isFirst;
        }
    }
}

