/*
 * Decompiled with CFR 0.152.
 */
package com.inet.fieldsettings.user;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.field.FieldManager;
import com.inet.fieldsettings.api.AbstractFieldSettingsManager;
import com.inet.fieldsettings.api.FieldSettingsPropertyExtension;
import com.inet.fieldsettings.api.FieldSettingsStructureInfo;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.api.model.nature.RegisteredNature;
import com.inet.fieldsettings.user.UserFieldDefinitionProvider;
import com.inet.fieldsettings.user.UserFieldSettingsManagerFactory;
import com.inet.fieldsettings.user.extension.UserFieldSettingsPropertyExtension;
import com.inet.fieldsettings.user.model.UserFieldCustom;
import com.inet.fieldsettings.user.model.UserFieldDefinitionNature;
import com.inet.fieldsettings.user.model.definitions.b;
import com.inet.fieldsettings.user.model.definitions.c;
import com.inet.fieldsettings.user.model.definitions.d;
import com.inet.fieldsettings.user.model.definitions.e;
import com.inet.fieldsettings.user.model.definitions.f;
import com.inet.fieldsettings.user.model.definitions.g;
import com.inet.fieldsettings.user.model.definitions.h;
import com.inet.fieldsettings.user.model.definitions.i;
import com.inet.fieldsettings.user.model.definitions.j;
import com.inet.id.GUID;
import com.inet.logging.Logger;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UF_Editability;
import com.inet.usersandgroups.api.ui.fields.user.UF_Visibility;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.BaseUserManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@InternalApi
public class UserFieldSettingsManager
extends AbstractFieldSettingsManager<UserFieldDefinition, UserField<?>> {
    public static final Logger LOGGER = UsersAndGroups.LOGGER;
    public static final I18nMessages USER_TRANSLATIONS = new I18nMessages("com.inet.fieldsettings.user.structure.i18n.UserTranslations", UserFieldSettingsManager.class);
    public static final I18nMessages USER_FIELD_TRANSLATIONS = new I18nMessages("com.inet.fieldsettings.user.structure.i18n.UserFieldTranslations", UserFieldSettingsManager.class);
    public static final String PROP_USER_FIELD_VISIBILITY = "users_visibility";
    public static final String PROP_USER_FIELD_EDITABILITY = "users_editability";
    private static UserFieldSettingsManager w;

    public static UserFieldSettingsManager getInstance() {
        if (w == null) {
            UserFieldSettingsManagerFactory userFieldSettingsManagerFactory = (UserFieldSettingsManagerFactory)ServerPluginManager.getInstance().getOptionalInstance(UserFieldSettingsManagerFactory.class);
            w = userFieldSettingsManagerFactory == null ? new UserFieldSettingsManager() : userFieldSettingsManagerFactory.getManager();
        }
        return w;
    }

    public UserFieldSettingsManager() {
        super("UserFields", LOGGER);
    }

    protected <T> UserFieldCustom<T> createUserField(GenericFieldSetting setting) {
        return UserFieldCustom.create(setting);
    }

    @Override
    protected <T> Map.Entry<UserFieldDefinition, UserField<?>> createAndRegisterForCustom(GenericFieldSetting setting) {
        Object object;
        Object object2;
        FieldSettingsType fieldSettingsType = setting.getType();
        UserFieldDefinition userFieldDefinition = null;
        UserFieldCustom<Double> userFieldCustom = null;
        if (fieldSettingsType == FieldSettingsType.TYPE_LINK) {
            userFieldDefinition = new g(setting);
            userFieldCustom = null;
        } else {
            userFieldCustom = this.createUserField(setting);
        }
        if (fieldSettingsType == FieldSettingsType.TYPE_DOUBLE) {
            userFieldDefinition = new e(userFieldCustom);
        } else if (fieldSettingsType == FieldSettingsType.TYPE_CURRENCY) {
            userFieldDefinition = new c(userFieldCustom);
        } else if (fieldSettingsType == FieldSettingsType.TYPE_TEXT) {
            userFieldDefinition = new i(userFieldCustom, "fieldtype_string");
        } else if (fieldSettingsType == FieldSettingsType.TYPE_MULTILINE_TEXT) {
            userFieldDefinition = new i(userFieldCustom, "fieldtype_multiline");
        } else if (fieldSettingsType == FieldSettingsType.TYPE_DATE || fieldSettingsType == FieldSettingsType.TYPE_DATE_TIME) {
            userFieldDefinition = new d(userFieldCustom, fieldSettingsType != FieldSettingsType.TYPE_DATE);
        } else if (fieldSettingsType == FieldSettingsType.TYPE_TIME) {
            userFieldDefinition = new j(userFieldCustom);
        } else if (fieldSettingsType == FieldSettingsType.TYPE_BOOLEAN) {
            userFieldDefinition = new b(userFieldCustom);
        } else if (fieldSettingsType == FieldSettingsType.TYPE_NUMBER) {
            userFieldDefinition = new f(userFieldCustom);
        } else if (fieldSettingsType == FieldSettingsType.TYPE_SELECT) {
            userFieldDefinition = new h(userFieldCustom, setting);
        } else {
            object2 = ServerPluginManager.getInstance().get(UserFieldDefinitionProvider.class);
            object = object2.iterator();
            while (object.hasNext()) {
                UserFieldDefinitionProvider userFieldDefinitionProvider = (UserFieldDefinitionProvider)object.next();
                UserFieldDefinition userFieldDefinition2 = userFieldDefinitionProvider.getFieldFor(setting);
                if (userFieldDefinition2 == null) continue;
                userFieldDefinition = userFieldDefinition2;
                break;
            }
            if (userFieldDefinition == null) {
                throw new IllegalStateException("Cannot create a UserFieldDefinition for type " + String.valueOf(fieldSettingsType) + ". You must register a UserFieldDefinitionProvider for that.");
            }
        }
        object2 = DynamicExtensionManager.getInstance();
        if (userFieldCustom != null) {
            object2.register(UserField.class, userFieldCustom);
        }
        object2.register(FieldDefinition.class, (Object)userFieldDefinition);
        object = new HashMap<g, UserFieldCustom<Double>>();
        ((HashMap)object).put(userFieldDefinition, userFieldCustom);
        return ((HashMap)object).entrySet().iterator().next();
    }

    @Override
    protected List<UserFieldDefinition> getAllRegisteredDefinitions() {
        List list = DynamicExtensionManager.getInstance().get(FieldDefinition.class);
        list.removeIf(fieldDefinition -> {
            if (fieldDefinition.getGroupingType() != Type.user || !(fieldDefinition instanceof UserFieldDefinition)) {
                return true;
            }
            try {
                UserFieldDefinitionNature.getTypeForDefinition((UserFieldDefinition)fieldDefinition);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return true;
            }
            return false;
        });
        return list;
    }

    @Override
    protected RegisteredNature getRegisteredNatureFor(UserFieldDefinition def) {
        return new UserFieldDefinitionNature(def);
    }

    @Override
    protected String setSpecificDefaultValues(UserFieldDefinition def, Map<String, String> properties) {
        if (def == null) {
            properties.putIfAbsent(PROP_USER_FIELD_EDITABILITY, UF_Editability.USERS_CAN_CHANGE.toString());
            properties.putIfAbsent(PROP_USER_FIELD_VISIBILITY, UF_Visibility.VISIBLE_FOR_ALL.toString());
            return null;
        }
        properties.putIfAbsent(PROP_USER_FIELD_EDITABILITY, def.getEditability().toString());
        properties.putIfAbsent(PROP_USER_FIELD_VISIBILITY, def.getVisibility().toString());
        UserField userField = def.getUserField();
        if (userField != null) {
            return userField.getDefaultValue() == null ? null : userField.getDefaultValue().toString();
        }
        return null;
    }

    @Override
    protected UserField unregisterForCustom(GenericFieldSetting setting) {
        List list = DynamicExtensionManager.getInstance().get(FieldDefinition.class);
        Optional<FieldDefinition> optional = list.stream().filter(fieldDefinition -> fieldDefinition.getFieldKey() != null && fieldDefinition.getFieldKey().equals(setting.getKey())).findFirst();
        if (optional.isPresent()) {
            DynamicExtensionManager.getInstance().unregister(FieldDefinition.class, (Object)optional.get());
            List list2 = DynamicExtensionManager.getInstance().get(UserField.class);
            Optional<UserField> optional2 = list2.stream().filter(userField -> userField.getKey().equals(setting.getKey())).findFirst();
            if (optional2.isPresent()) {
                DynamicExtensionManager.getInstance().unregister(UserField.class, (Object)optional2.get());
                return optional2.get();
            }
        } else {
            LOGGER.warn((Object)String.format("Try to remove UserFieldDefinition for key %s, but cannot find it.", setting.getKey()));
        }
        return null;
    }

    @Override
    public List<FieldSettingsType> getSupportedTypesForCustomFields() {
        List<FieldSettingsType> list = super.getSupportedTypesForCustomFields();
        return list;
    }

    @Override
    public List<? extends FieldSettingsPropertyExtension> getFieldPropertyExtensions() {
        return DynamicExtensionManager.getInstance().get(UserFieldSettingsPropertyExtension.class);
    }

    @Override
    public FieldSettingsStructureInfo getFieldSettingsStructureInfo() {
        return new FieldSettingsStructureInfo(BASE_TRANSLATIONS){

            @Override
            public String getFieldKindLabel() {
                return USER_TRANSLATIONS.getMsg("userfields.singleRow.title", new Object[0]);
            }

            @Override
            public String getHelpKey() {
                return "field.settings.user.edit";
            }

            @Override
            public String getIconKeyRegisteredField() {
                return "system-user";
            }

            @Override
            public String getIconKeyCustomField() {
                return "custom-user";
            }
        };
    }

    @Override
    public List<ConfigValidationMsg> validate(String key, Map<String, String> properties, boolean willBeNewField) {
        List list;
        List<ConfigValidationMsg> list2 = super.validate(key, properties, willBeNewField);
        try {
            UsersAndGroups.throwIfKeysOfRegisteredFieldsCollideWithReservedKeys((List)BaseUserManager.RESERVED_FIELD_KEYS, Collections.singletonList(key), UserField.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            list2.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, illegalArgumentException.getMessage(), "fieldsettingsKey"));
        }
        if (willBeNewField && list2.isEmpty() && (list = DynamicExtensionManager.getInstance().get(FieldDefinition.class)).stream().anyMatch(fieldDefinition -> Objects.equals(fieldDefinition.getFieldKey(), key))) {
            list2.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.reservedkey", new Object[]{key}), "fieldsettingsKey"));
        }
        return list2;
    }

    @Override
    protected void updateConfigurableValuesOfField(UserFieldDefinition definition, GenericFieldSetting setting) {
        super.updateConfigurableValuesOfField(definition, setting);
        try {
            UF_Editability uF_Editability;
            Object object;
            String string = setting.getSpecificProperty(PROP_USER_FIELD_VISIBILITY);
            if (string != null) {
                object = UF_Visibility.valueOf((String)string);
                definition.setVisibility(object);
                if (definition.getUserField() != null && (uF_Editability = definition.getUserField().getSearchTag()) != null) {
                    uF_Editability.setIncludeInTextSearch(object != UF_Visibility.COMPLETELY_HIDDEN);
                }
            }
            if ((object = setting.getSpecificProperty(PROP_USER_FIELD_EDITABILITY)) != null) {
                uF_Editability = UF_Editability.valueOf((String)object);
                definition.setEditability(uF_Editability);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            LOGGER.debug((Object)runtimeException);
        }
    }

    @Override
    protected UserField getIndexInfoForRegisteredField(UserFieldDefinition definition) {
        UserField userField = definition.getUserField();
        return userField;
    }

    @Override
    protected void deleteFields(List<UserField<?>> fieldsToDelete) {
        UserManager.getInstance().deleteValuesOfRemovedCustomFields(fieldsToDelete);
    }

    @Override
    public FieldManager<GUID> getManager() {
        return UserManager.getInstance();
    }
}

